/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BioSource_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_BIOSOURCE_BASE_HPP
#define OBJECTS_SEQFEAT_BIOSOURCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class COrg_ref;
class CPCRReactionSet;
class CSubSource;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///********************************************************************
///
/// BioSource gives the source of the biological material
///   for sequences
///
///********************************************************************
class NCBI_SEQFEAT_EXPORT CBioSource_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBioSource_Base(void);
    // destructor
    virtual ~CBioSource_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// biological context
    enum EGenome {
        eGenome_unknown                  =  0,
        eGenome_genomic                  =  1,
        eGenome_chloroplast              =  2,
        eGenome_chromoplast              =  3,
        eGenome_kinetoplast              =  4,
        eGenome_mitochondrion            =  5,
        eGenome_plastid                  =  6,
        eGenome_macronuclear             =  7,
        eGenome_extrachrom               =  8,
        eGenome_plasmid                  =  9,
        eGenome_transposon               = 10,
        eGenome_insertion_seq            = 11,
        eGenome_cyanelle                 = 12,
        eGenome_proviral                 = 13,
        eGenome_virion                   = 14,
        eGenome_nucleomorph              = 15,
        eGenome_apicoplast               = 16,
        eGenome_leucoplast               = 17,
        eGenome_proplastid               = 18,
        eGenome_endogenous_virus         = 19,
        eGenome_hydrogenosome            = 20,
        eGenome_chromosome               = 21,
        eGenome_chromatophore            = 22,
        eGenome_plasmid_in_mitochondrion = 23,
        eGenome_plasmid_in_plastid       = 24
    };
    
    /// Access to EGenome's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EGenome)(void);
    
    enum EOrigin {
        eOrigin_unknown    =   0,
        eOrigin_natural    =   1,  ///< normal biological entity
        eOrigin_natmut     =   2,  ///< naturally occurring mutant
        eOrigin_mut        =   3,  ///< artificially mutagenized
        eOrigin_artificial =   4,  ///< artificially engineered
        eOrigin_synthetic  =   5,  ///< purely synthetic
        eOrigin_other      = 255
    };
    
    /// Access to EOrigin's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EOrigin)(void);
    
    // types
    typedef int TGenome;
    typedef int TOrigin;
    typedef COrg_ref TOrg;
    typedef list< CRef< CSubSource > > TSubtype;
    typedef CPCRReactionSet TPcr_primers;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_genome,
        e_origin,
        e_org,
        e_subtype,
        e_is_focus,
        e_pcr_primers
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// optional with default eGenome_unknown
    /// typedef int TGenome
    ///  Check whether the Genome data member has been assigned a value.
    bool IsSetGenome(void) const;
    /// Check whether it is safe or not to call GetGenome method.
    bool CanGetGenome(void) const;
    void ResetGenome(void);
    void SetDefaultGenome(void);
    TGenome GetGenome(void) const;
    void SetGenome(TGenome value);
    TGenome& SetGenome(void);

    /// optional with default eOrigin_unknown
    /// typedef int TOrigin
    ///  Check whether the Origin data member has been assigned a value.
    bool IsSetOrigin(void) const;
    /// Check whether it is safe or not to call GetOrigin method.
    bool CanGetOrigin(void) const;
    void ResetOrigin(void);
    void SetDefaultOrigin(void);
    TOrigin GetOrigin(void) const;
    void SetOrigin(TOrigin value);
    TOrigin& SetOrigin(void);

    /// mandatory
    /// typedef COrg_ref TOrg
    ///  Check whether the Org data member has been assigned a value.
    bool IsSetOrg(void) const;
    /// Check whether it is safe or not to call GetOrg method.
    bool CanGetOrg(void) const;
    void ResetOrg(void);
    const TOrg& GetOrg(void) const;
    void SetOrg(TOrg& value);
    TOrg& SetOrg(void);

    /// optional
    /// typedef list< CRef< CSubSource > > TSubtype
    ///  Check whether the Subtype data member has been assigned a value.
    bool IsSetSubtype(void) const;
    /// Check whether it is safe or not to call GetSubtype method.
    bool CanGetSubtype(void) const;
    void ResetSubtype(void);
    const TSubtype& GetSubtype(void) const;
    TSubtype& SetSubtype(void);

    /// to distinguish biological focus
    /// optional
    ///  Check whether the Is_focus data member has been assigned a value.
    bool IsSetIs_focus(void) const;
    /// Check whether it is safe or not to call GetIs_focus method.
    bool CanGetIs_focus(void) const;
    void ResetIs_focus(void);
    void SetIs_focus(void);

    /// optional
    /// typedef CPCRReactionSet TPcr_primers
    ///  Check whether the Pcr_primers data member has been assigned a value.
    bool IsSetPcr_primers(void) const;
    /// Check whether it is safe or not to call GetPcr_primers method.
    bool CanGetPcr_primers(void) const;
    void ResetPcr_primers(void);
    const TPcr_primers& GetPcr_primers(void) const;
    void SetPcr_primers(TPcr_primers& value);
    TPcr_primers& SetPcr_primers(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBioSource_Base(const CBioSource_Base&);
    CBioSource_Base& operator=(const CBioSource_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Genome;
    int m_Origin;
    CRef< TOrg > m_Org;
    list< CRef< CSubSource > > m_Subtype;
    CRef< TPcr_primers > m_Pcr_primers;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBioSource_Base::IsSetGenome(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBioSource_Base::CanGetGenome(void) const
{
    return true;
}

inline
void CBioSource_Base::ResetGenome(void)
{
    m_Genome = eGenome_unknown;
    m_set_State[0] &= ~0x3;
}

inline
void CBioSource_Base::SetDefaultGenome(void)
{
    ResetGenome();
}

inline
CBioSource_Base::TGenome CBioSource_Base::GetGenome(void) const
{
    return m_Genome;
}

inline
void CBioSource_Base::SetGenome(CBioSource_Base::TGenome value)
{
    m_Genome = value;
    m_set_State[0] |= 0x3;
}

inline
CBioSource_Base::TGenome& CBioSource_Base::SetGenome(void)
{
#ifdef _DEBUG
    if (!IsSetGenome()) {
        memset(&m_Genome,UnassignedByte(),sizeof(m_Genome));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Genome;
}

inline
bool CBioSource_Base::IsSetOrigin(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBioSource_Base::CanGetOrigin(void) const
{
    return true;
}

inline
void CBioSource_Base::ResetOrigin(void)
{
    m_Origin = eOrigin_unknown;
    m_set_State[0] &= ~0xc;
}

inline
void CBioSource_Base::SetDefaultOrigin(void)
{
    ResetOrigin();
}

inline
CBioSource_Base::TOrigin CBioSource_Base::GetOrigin(void) const
{
    return m_Origin;
}

inline
void CBioSource_Base::SetOrigin(CBioSource_Base::TOrigin value)
{
    m_Origin = value;
    m_set_State[0] |= 0xc;
}

inline
CBioSource_Base::TOrigin& CBioSource_Base::SetOrigin(void)
{
#ifdef _DEBUG
    if (!IsSetOrigin()) {
        memset(&m_Origin,UnassignedByte(),sizeof(m_Origin));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Origin;
}

inline
bool CBioSource_Base::IsSetOrg(void) const
{
    return m_Org.NotEmpty();
}

inline
bool CBioSource_Base::CanGetOrg(void) const
{
    return true;
}

inline
const CBioSource_Base::TOrg& CBioSource_Base::GetOrg(void) const
{
    if ( !m_Org ) {
        const_cast<CBioSource_Base*>(this)->ResetOrg();
    }
    return (*m_Org);
}

inline
CBioSource_Base::TOrg& CBioSource_Base::SetOrg(void)
{
    if ( !m_Org ) {
        ResetOrg();
    }
    return (*m_Org);
}

inline
bool CBioSource_Base::IsSetSubtype(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBioSource_Base::CanGetSubtype(void) const
{
    return true;
}

inline
const CBioSource_Base::TSubtype& CBioSource_Base::GetSubtype(void) const
{
    return m_Subtype;
}

inline
CBioSource_Base::TSubtype& CBioSource_Base::SetSubtype(void)
{
    m_set_State[0] |= 0x40;
    return m_Subtype;
}

inline
bool CBioSource_Base::IsSetIs_focus(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBioSource_Base::CanGetIs_focus(void) const
{
    return false;
}

inline
void CBioSource_Base::ResetIs_focus(void)
{
    m_set_State[0] &= ~0x300;
}

inline
void CBioSource_Base::SetIs_focus(void)
{
    m_set_State[0] |= 0x300;
}

inline
bool CBioSource_Base::IsSetPcr_primers(void) const
{
    return m_Pcr_primers.NotEmpty();
}

inline
bool CBioSource_Base::CanGetPcr_primers(void) const
{
    return IsSetPcr_primers();
}

inline
const CBioSource_Base::TPcr_primers& CBioSource_Base::GetPcr_primers(void) const
{
    if (!CanGetPcr_primers()) {
        ThrowUnassigned(5);
    }
    return (*m_Pcr_primers);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_BIOSOURCE_BASE_HPP
