/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file EMBL_dbname_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_EMBL_DBNAME_BASE_HPP
#define OBJECTS_SEQBLOCK_EMBL_DBNAME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQBLOCK_EXPORT CEMBL_dbname_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEMBL_dbname_Base(void);
    // destructor
    virtual ~CEMBL_dbname_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ECode {
        eCode_embl      =   0,
        eCode_genbank   =   1,
        eCode_ddbj      =   2,
        eCode_geninfo   =   3,
        eCode_medline   =   4,
        eCode_swissprot =   5,
        eCode_pir       =   6,
        eCode_pdb       =   7,
        eCode_epd       =   8,
        eCode_ecd       =   9,
        eCode_tfd       =  10,
        eCode_flybase   =  11,
        eCode_prosite   =  12,
        eCode_enzyme    =  13,
        eCode_mim       =  14,
        eCode_ecoseq    =  15,
        eCode_hiv       =  16,
        eCode_other     = 255
    };
    
    /// Access to ECode's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ECode)(void);
    

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Code,
        e_Name
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Name+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef ECode TCode;
    typedef string TName;

    // getters
    // setters

    // typedef ECode TCode
    bool IsCode(void) const;
    TCode GetCode(void) const;
    TCode& SetCode(void);
    void SetCode(TCode value);

    // typedef string TName
    bool IsName(void) const;
    const TName& GetName(void) const;
    TName& SetName(void);
    void SetName(const TName& value);


private:
    // copy constructor and assignment operator
    CEMBL_dbname_Base(const CEMBL_dbname_Base& );
    CEMBL_dbname_Base& operator=(const CEMBL_dbname_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TCode m_Code;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CEMBL_dbname_Base::E_Choice CEMBL_dbname_Base::Which(void) const
{
    return m_choice;
}

inline
void CEMBL_dbname_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CEMBL_dbname_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CEMBL_dbname_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CEMBL_dbname_Base::IsCode(void) const
{
    return m_choice == e_Code;
}

inline
CEMBL_dbname_Base::TCode CEMBL_dbname_Base::GetCode(void) const
{
    CheckSelected(e_Code);
    return m_Code;
}

inline
CEMBL_dbname_Base::TCode& CEMBL_dbname_Base::SetCode(void)
{
    Select(e_Code, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Code;
}

inline
void CEMBL_dbname_Base::SetCode(CEMBL_dbname_Base::TCode value)
{
    Select(e_Code, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Code = value;
}

inline
bool CEMBL_dbname_Base::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CEMBL_dbname_Base::TName& CEMBL_dbname_Base::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CEMBL_dbname_Base::TName& CEMBL_dbname_Base::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_EMBL_DBNAME_BASE_HPP
