/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Spliced_exon_chunk_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPLICED_EXON_CHUNK_BASE_HPP
#define OBJECTS_SEQALIGN_SPLICED_EXON_CHUNK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Spliced-exon-chunk: piece of an exon
/// lengths are given in nucleotide bases (1/3 of aminoacid when product is a
/// protein)
class NCBI_SEQALIGN_EXPORT CSpliced_exon_chunk_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSpliced_exon_chunk_Base(void);
    // destructor
    virtual ~CSpliced_exon_chunk_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Match,        ///< both sequences represented, product and genomic sequences match
        e_Mismatch,     ///< both sequences represented, product and genomic sequences do not match
        e_Diag,         ///< both sequences are represented, there is sufficient similarity   between product and genomic sequences. Can be used to replace stretches  of matches and mismatches, mostly for protein to genomic where   definition of match or mismatch depends on translation table
        e_Product_ins,  ///< insertion in product sequence (i.e. gap in the genomic sequence)
        e_Genomic_ins   ///< insertion in genomic sequence (i.e. gap in the product sequence)
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Genomic_ins+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef TSeqPos TMatch;
    typedef TSeqPos TMismatch;
    typedef TSeqPos TDiag;
    typedef TSeqPos TProduct_ins;
    typedef TSeqPos TGenomic_ins;

    // getters
    // setters

    // typedef TSeqPos TMatch
    bool IsMatch(void) const;
    TMatch GetMatch(void) const;
    TMatch& SetMatch(void);
    void SetMatch(TMatch value);

    // typedef TSeqPos TMismatch
    bool IsMismatch(void) const;
    TMismatch GetMismatch(void) const;
    TMismatch& SetMismatch(void);
    void SetMismatch(TMismatch value);

    // typedef TSeqPos TDiag
    bool IsDiag(void) const;
    TDiag GetDiag(void) const;
    TDiag& SetDiag(void);
    void SetDiag(TDiag value);

    // typedef TSeqPos TProduct_ins
    bool IsProduct_ins(void) const;
    TProduct_ins GetProduct_ins(void) const;
    TProduct_ins& SetProduct_ins(void);
    void SetProduct_ins(TProduct_ins value);

    // typedef TSeqPos TGenomic_ins
    bool IsGenomic_ins(void) const;
    TGenomic_ins GetGenomic_ins(void) const;
    TGenomic_ins& SetGenomic_ins(void);
    void SetGenomic_ins(TGenomic_ins value);


private:
    // copy constructor and assignment operator
    CSpliced_exon_chunk_Base(const CSpliced_exon_chunk_Base& );
    CSpliced_exon_chunk_Base& operator=(const CSpliced_exon_chunk_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TMatch m_Match;
        TMismatch m_Mismatch;
        TDiag m_Diag;
        TProduct_ins m_Product_ins;
        TGenomic_ins m_Genomic_ins;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSpliced_exon_chunk_Base::E_Choice CSpliced_exon_chunk_Base::Which(void) const
{
    return m_choice;
}

inline
void CSpliced_exon_chunk_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSpliced_exon_chunk_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSpliced_exon_chunk_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSpliced_exon_chunk_Base::IsMatch(void) const
{
    return m_choice == e_Match;
}

inline
CSpliced_exon_chunk_Base::TMatch CSpliced_exon_chunk_Base::GetMatch(void) const
{
    CheckSelected(e_Match);
    return m_Match;
}

inline
CSpliced_exon_chunk_Base::TMatch& CSpliced_exon_chunk_Base::SetMatch(void)
{
    Select(e_Match, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Match;
}

inline
void CSpliced_exon_chunk_Base::SetMatch(CSpliced_exon_chunk_Base::TMatch value)
{
    Select(e_Match, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Match = value;
}

inline
bool CSpliced_exon_chunk_Base::IsMismatch(void) const
{
    return m_choice == e_Mismatch;
}

inline
CSpliced_exon_chunk_Base::TMismatch CSpliced_exon_chunk_Base::GetMismatch(void) const
{
    CheckSelected(e_Mismatch);
    return m_Mismatch;
}

inline
CSpliced_exon_chunk_Base::TMismatch& CSpliced_exon_chunk_Base::SetMismatch(void)
{
    Select(e_Mismatch, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mismatch;
}

inline
void CSpliced_exon_chunk_Base::SetMismatch(CSpliced_exon_chunk_Base::TMismatch value)
{
    Select(e_Mismatch, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mismatch = value;
}

inline
bool CSpliced_exon_chunk_Base::IsDiag(void) const
{
    return m_choice == e_Diag;
}

inline
CSpliced_exon_chunk_Base::TDiag CSpliced_exon_chunk_Base::GetDiag(void) const
{
    CheckSelected(e_Diag);
    return m_Diag;
}

inline
CSpliced_exon_chunk_Base::TDiag& CSpliced_exon_chunk_Base::SetDiag(void)
{
    Select(e_Diag, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Diag;
}

inline
void CSpliced_exon_chunk_Base::SetDiag(CSpliced_exon_chunk_Base::TDiag value)
{
    Select(e_Diag, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Diag = value;
}

inline
bool CSpliced_exon_chunk_Base::IsProduct_ins(void) const
{
    return m_choice == e_Product_ins;
}

inline
CSpliced_exon_chunk_Base::TProduct_ins CSpliced_exon_chunk_Base::GetProduct_ins(void) const
{
    CheckSelected(e_Product_ins);
    return m_Product_ins;
}

inline
CSpliced_exon_chunk_Base::TProduct_ins& CSpliced_exon_chunk_Base::SetProduct_ins(void)
{
    Select(e_Product_ins, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Product_ins;
}

inline
void CSpliced_exon_chunk_Base::SetProduct_ins(CSpliced_exon_chunk_Base::TProduct_ins value)
{
    Select(e_Product_ins, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Product_ins = value;
}

inline
bool CSpliced_exon_chunk_Base::IsGenomic_ins(void) const
{
    return m_choice == e_Genomic_ins;
}

inline
CSpliced_exon_chunk_Base::TGenomic_ins CSpliced_exon_chunk_Base::GetGenomic_ins(void) const
{
    CheckSelected(e_Genomic_ins);
    return m_Genomic_ins;
}

inline
CSpliced_exon_chunk_Base::TGenomic_ins& CSpliced_exon_chunk_Base::SetGenomic_ins(void)
{
    Select(e_Genomic_ins, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Genomic_ins;
}

inline
void CSpliced_exon_chunk_Base::SetGenomic_ins(CSpliced_exon_chunk_Base::TGenomic_ins value)
{
    Select(e_Genomic_ins, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Genomic_ins = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPLICED_EXON_CHUNK_BASE_HPP
