/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sparse_align_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_SPARSE_ALIGN_BASE_HPP
#define OBJECTS_SEQALIGN_SPARSE_ALIGN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CScore;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQALIGN_EXPORT CSparse_align_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSparse_align_Base(void);
    // destructor
    virtual ~CSparse_align_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TFirst_id;
    typedef CSeq_id TSecond_id;
    typedef int TNumseg;
    typedef vector< int > TFirst_starts;
    typedef vector< int > TSecond_starts;
    typedef vector< TSeqPos > TLens;
    typedef vector< ENa_strand > TSecond_strands;
    typedef vector< CRef< CScore > > TSeg_scores;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_first_id,
        e_second_id,
        e_numseg,
        e_first_starts,
        e_second_starts,
        e_lens,
        e_second_strands,
        e_seg_scores
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_id TFirst_id
    ///  Check whether the First_id data member has been assigned a value.
    bool IsSetFirst_id(void) const;
    /// Check whether it is safe or not to call GetFirst_id method.
    bool CanGetFirst_id(void) const;
    void ResetFirst_id(void);
    const TFirst_id& GetFirst_id(void) const;
    void SetFirst_id(TFirst_id& value);
    TFirst_id& SetFirst_id(void);

    /// mandatory
    /// typedef CSeq_id TSecond_id
    ///  Check whether the Second_id data member has been assigned a value.
    bool IsSetSecond_id(void) const;
    /// Check whether it is safe or not to call GetSecond_id method.
    bool CanGetSecond_id(void) const;
    void ResetSecond_id(void);
    const TSecond_id& GetSecond_id(void) const;
    void SetSecond_id(TSecond_id& value);
    TSecond_id& SetSecond_id(void);

    ///number of segments
    /// mandatory
    /// typedef int TNumseg
    ///  Check whether the Numseg data member has been assigned a value.
    bool IsSetNumseg(void) const;
    /// Check whether it is safe or not to call GetNumseg method.
    bool CanGetNumseg(void) const;
    void ResetNumseg(void);
    TNumseg GetNumseg(void) const;
    void SetNumseg(TNumseg value);
    TNumseg& SetNumseg(void);

    ///starts on the first sequence [numseg]
    /// mandatory
    /// typedef vector< int > TFirst_starts
    ///  Check whether the First_starts data member has been assigned a value.
    bool IsSetFirst_starts(void) const;
    /// Check whether it is safe or not to call GetFirst_starts method.
    bool CanGetFirst_starts(void) const;
    void ResetFirst_starts(void);
    const TFirst_starts& GetFirst_starts(void) const;
    TFirst_starts& SetFirst_starts(void);

    ///starts on the second sequence [numseg]
    /// mandatory
    /// typedef vector< int > TSecond_starts
    ///  Check whether the Second_starts data member has been assigned a value.
    bool IsSetSecond_starts(void) const;
    /// Check whether it is safe or not to call GetSecond_starts method.
    bool CanGetSecond_starts(void) const;
    void ResetSecond_starts(void);
    const TSecond_starts& GetSecond_starts(void) const;
    TSecond_starts& SetSecond_starts(void);

    ///lengths of segments [numseg]
    /// mandatory
    /// typedef vector< TSeqPos > TLens
    ///  Check whether the Lens data member has been assigned a value.
    bool IsSetLens(void) const;
    /// Check whether it is safe or not to call GetLens method.
    bool CanGetLens(void) const;
    void ResetLens(void);
    const TLens& GetLens(void) const;
    TLens& SetLens(void);

    /// optional
    /// typedef vector< ENa_strand > TSecond_strands
    ///  Check whether the Second_strands data member has been assigned a value.
    bool IsSetSecond_strands(void) const;
    /// Check whether it is safe or not to call GetSecond_strands method.
    bool CanGetSecond_strands(void) const;
    void ResetSecond_strands(void);
    const TSecond_strands& GetSecond_strands(void) const;
    TSecond_strands& SetSecond_strands(void);

    /// per-segment scores
    /// optional
    /// typedef vector< CRef< CScore > > TSeg_scores
    ///  Check whether the Seg_scores data member has been assigned a value.
    bool IsSetSeg_scores(void) const;
    /// Check whether it is safe or not to call GetSeg_scores method.
    bool CanGetSeg_scores(void) const;
    void ResetSeg_scores(void);
    const TSeg_scores& GetSeg_scores(void) const;
    TSeg_scores& SetSeg_scores(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSparse_align_Base(const CSparse_align_Base&);
    CSparse_align_Base& operator=(const CSparse_align_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TFirst_id > m_First_id;
    CRef< TSecond_id > m_Second_id;
    int m_Numseg;
    vector< int > m_First_starts;
    vector< int > m_Second_starts;
    vector< TSeqPos > m_Lens;
    vector< ENa_strand > m_Second_strands;
    vector< CRef< CScore > > m_Seg_scores;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSparse_align_Base::IsSetFirst_id(void) const
{
    return m_First_id.NotEmpty();
}

inline
bool CSparse_align_Base::CanGetFirst_id(void) const
{
    return true;
}

inline
const CSparse_align_Base::TFirst_id& CSparse_align_Base::GetFirst_id(void) const
{
    if ( !m_First_id ) {
        const_cast<CSparse_align_Base*>(this)->ResetFirst_id();
    }
    return (*m_First_id);
}

inline
CSparse_align_Base::TFirst_id& CSparse_align_Base::SetFirst_id(void)
{
    if ( !m_First_id ) {
        ResetFirst_id();
    }
    return (*m_First_id);
}

inline
bool CSparse_align_Base::IsSetSecond_id(void) const
{
    return m_Second_id.NotEmpty();
}

inline
bool CSparse_align_Base::CanGetSecond_id(void) const
{
    return true;
}

inline
const CSparse_align_Base::TSecond_id& CSparse_align_Base::GetSecond_id(void) const
{
    if ( !m_Second_id ) {
        const_cast<CSparse_align_Base*>(this)->ResetSecond_id();
    }
    return (*m_Second_id);
}

inline
CSparse_align_Base::TSecond_id& CSparse_align_Base::SetSecond_id(void)
{
    if ( !m_Second_id ) {
        ResetSecond_id();
    }
    return (*m_Second_id);
}

inline
bool CSparse_align_Base::IsSetNumseg(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSparse_align_Base::CanGetNumseg(void) const
{
    return IsSetNumseg();
}

inline
void CSparse_align_Base::ResetNumseg(void)
{
    m_Numseg = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSparse_align_Base::TNumseg CSparse_align_Base::GetNumseg(void) const
{
    if (!CanGetNumseg()) {
        ThrowUnassigned(2);
    }
    return m_Numseg;
}

inline
void CSparse_align_Base::SetNumseg(CSparse_align_Base::TNumseg value)
{
    m_Numseg = value;
    m_set_State[0] |= 0x30;
}

inline
CSparse_align_Base::TNumseg& CSparse_align_Base::SetNumseg(void)
{
#ifdef _DEBUG
    if (!IsSetNumseg()) {
        memset(&m_Numseg,UnassignedByte(),sizeof(m_Numseg));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Numseg;
}

inline
bool CSparse_align_Base::IsSetFirst_starts(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSparse_align_Base::CanGetFirst_starts(void) const
{
    return true;
}

inline
const CSparse_align_Base::TFirst_starts& CSparse_align_Base::GetFirst_starts(void) const
{
    return m_First_starts;
}

inline
CSparse_align_Base::TFirst_starts& CSparse_align_Base::SetFirst_starts(void)
{
    m_set_State[0] |= 0x40;
    return m_First_starts;
}

inline
bool CSparse_align_Base::IsSetSecond_starts(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSparse_align_Base::CanGetSecond_starts(void) const
{
    return true;
}

inline
const CSparse_align_Base::TSecond_starts& CSparse_align_Base::GetSecond_starts(void) const
{
    return m_Second_starts;
}

inline
CSparse_align_Base::TSecond_starts& CSparse_align_Base::SetSecond_starts(void)
{
    m_set_State[0] |= 0x100;
    return m_Second_starts;
}

inline
bool CSparse_align_Base::IsSetLens(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSparse_align_Base::CanGetLens(void) const
{
    return true;
}

inline
const CSparse_align_Base::TLens& CSparse_align_Base::GetLens(void) const
{
    return m_Lens;
}

inline
CSparse_align_Base::TLens& CSparse_align_Base::SetLens(void)
{
    m_set_State[0] |= 0x400;
    return m_Lens;
}

inline
bool CSparse_align_Base::IsSetSecond_strands(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSparse_align_Base::CanGetSecond_strands(void) const
{
    return true;
}

inline
const CSparse_align_Base::TSecond_strands& CSparse_align_Base::GetSecond_strands(void) const
{
    return m_Second_strands;
}

inline
CSparse_align_Base::TSecond_strands& CSparse_align_Base::SetSecond_strands(void)
{
    m_set_State[0] |= 0x1000;
    return m_Second_strands;
}

inline
bool CSparse_align_Base::IsSetSeg_scores(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSparse_align_Base::CanGetSeg_scores(void) const
{
    return true;
}

inline
const CSparse_align_Base::TSeg_scores& CSparse_align_Base::GetSeg_scores(void) const
{
    return m_Seg_scores;
}

inline
CSparse_align_Base::TSeg_scores& CSparse_align_Base::SetSeg_scores(void)
{
    m_set_State[0] |= 0x4000;
    return m_Seg_scores;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_SPARSE_ALIGN_BASE_HPP
