/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Dense_diag_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqalign.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQALIGN_DENSE_DIAG_BASE_HPP
#define OBJECTS_SEQALIGN_DENSE_DIAG_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CScore;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// for (multiway) diagonals
class NCBI_SEQALIGN_EXPORT CDense_diag_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDense_diag_Base(void);
    // destructor
    virtual ~CDense_diag_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TDim;
    typedef vector< CRef< CSeq_id > > TIds;
    typedef vector< TSeqPos > TStarts;
    typedef TSeqPos TLen;
    typedef vector< ENa_strand > TStrands;
    typedef vector< CRef< CScore > > TScores;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dim,
        e_ids,
        e_starts,
        e_len,
        e_strands,
        e_scores
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// dimensionality
    /// optional with default 2
    /// typedef int TDim
    ///  Check whether the Dim data member has been assigned a value.
    bool IsSetDim(void) const;
    /// Check whether it is safe or not to call GetDim method.
    bool CanGetDim(void) const;
    void ResetDim(void);
    void SetDefaultDim(void);
    TDim GetDim(void) const;
    void SetDim(TDim value);
    TDim& SetDim(void);

    /// sequences in order
    /// mandatory
    /// typedef vector< CRef< CSeq_id > > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// start OFFSETS in ids order
    /// mandatory
    /// typedef vector< TSeqPos > TStarts
    ///  Check whether the Starts data member has been assigned a value.
    bool IsSetStarts(void) const;
    /// Check whether it is safe or not to call GetStarts method.
    bool CanGetStarts(void) const;
    void ResetStarts(void);
    const TStarts& GetStarts(void) const;
    TStarts& SetStarts(void);

    /// len of aligned segments
    /// mandatory
    /// typedef TSeqPos TLen
    ///  Check whether the Len data member has been assigned a value.
    bool IsSetLen(void) const;
    /// Check whether it is safe or not to call GetLen method.
    bool CanGetLen(void) const;
    void ResetLen(void);
    TLen GetLen(void) const;
    void SetLen(TLen value);
    TLen& SetLen(void);

    /// optional
    /// typedef vector< ENa_strand > TStrands
    ///  Check whether the Strands data member has been assigned a value.
    bool IsSetStrands(void) const;
    /// Check whether it is safe or not to call GetStrands method.
    bool CanGetStrands(void) const;
    void ResetStrands(void);
    const TStrands& GetStrands(void) const;
    TStrands& SetStrands(void);

    /// optional
    /// typedef vector< CRef< CScore > > TScores
    ///  Check whether the Scores data member has been assigned a value.
    bool IsSetScores(void) const;
    /// Check whether it is safe or not to call GetScores method.
    bool CanGetScores(void) const;
    void ResetScores(void);
    const TScores& GetScores(void) const;
    TScores& SetScores(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDense_diag_Base(const CDense_diag_Base&);
    CDense_diag_Base& operator=(const CDense_diag_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Dim;
    vector< CRef< CSeq_id > > m_Ids;
    vector< TSeqPos > m_Starts;
    TSeqPos m_Len;
    vector< ENa_strand > m_Strands;
    vector< CRef< CScore > > m_Scores;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDense_diag_Base::IsSetDim(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDense_diag_Base::CanGetDim(void) const
{
    return true;
}

inline
void CDense_diag_Base::ResetDim(void)
{
    m_Dim = 2;
    m_set_State[0] &= ~0x3;
}

inline
void CDense_diag_Base::SetDefaultDim(void)
{
    ResetDim();
}

inline
CDense_diag_Base::TDim CDense_diag_Base::GetDim(void) const
{
    return m_Dim;
}

inline
void CDense_diag_Base::SetDim(CDense_diag_Base::TDim value)
{
    m_Dim = value;
    m_set_State[0] |= 0x3;
}

inline
CDense_diag_Base::TDim& CDense_diag_Base::SetDim(void)
{
#ifdef _DEBUG
    if (!IsSetDim()) {
        memset(&m_Dim,UnassignedByte(),sizeof(m_Dim));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Dim;
}

inline
bool CDense_diag_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDense_diag_Base::CanGetIds(void) const
{
    return true;
}

inline
const CDense_diag_Base::TIds& CDense_diag_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CDense_diag_Base::TIds& CDense_diag_Base::SetIds(void)
{
    m_set_State[0] |= 0x4;
    return m_Ids;
}

inline
bool CDense_diag_Base::IsSetStarts(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CDense_diag_Base::CanGetStarts(void) const
{
    return true;
}

inline
const CDense_diag_Base::TStarts& CDense_diag_Base::GetStarts(void) const
{
    return m_Starts;
}

inline
CDense_diag_Base::TStarts& CDense_diag_Base::SetStarts(void)
{
    m_set_State[0] |= 0x10;
    return m_Starts;
}

inline
bool CDense_diag_Base::IsSetLen(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CDense_diag_Base::CanGetLen(void) const
{
    return IsSetLen();
}

inline
void CDense_diag_Base::ResetLen(void)
{
    m_Len = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CDense_diag_Base::TLen CDense_diag_Base::GetLen(void) const
{
    if (!CanGetLen()) {
        ThrowUnassigned(3);
    }
    return m_Len;
}

inline
void CDense_diag_Base::SetLen(CDense_diag_Base::TLen value)
{
    m_Len = value;
    m_set_State[0] |= 0xc0;
}

inline
CDense_diag_Base::TLen& CDense_diag_Base::SetLen(void)
{
#ifdef _DEBUG
    if (!IsSetLen()) {
        memset(&m_Len,UnassignedByte(),sizeof(m_Len));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Len;
}

inline
bool CDense_diag_Base::IsSetStrands(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CDense_diag_Base::CanGetStrands(void) const
{
    return true;
}

inline
const CDense_diag_Base::TStrands& CDense_diag_Base::GetStrands(void) const
{
    return m_Strands;
}

inline
CDense_diag_Base::TStrands& CDense_diag_Base::SetStrands(void)
{
    m_set_State[0] |= 0x100;
    return m_Strands;
}

inline
bool CDense_diag_Base::IsSetScores(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CDense_diag_Base::CanGetScores(void) const
{
    return true;
}

inline
const CDense_diag_Base::TScores& CDense_diag_Base::GetScores(void) const
{
    return m_Scores;
}

inline
CDense_diag_Base::TScores& CDense_diag_Base::SetScores(void)
{
    m_set_State[0] |= 0x400;
    return m_Scores;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQALIGN_DENSE_DIAG_BASE_HPP
