/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seqdesc_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQDESC_BASE_HPP
#define OBJECTS_SEQ_SEQDESC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/seq/GIBB_method.hpp>
#include <objects/seq/GIBB_mod.hpp>
#include <objects/seq/GIBB_mol.hpp>
#include <objects/seq/Heterogen.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioSource;
class CDate;
class CDbtag;
class CEMBL_block;
class CGB_block;
class CModelEvidenceSupport;
class CMolInfo;
class CNumbering;
class COrg_ref;
class CPDB_block;
class CPIR_block;
class CPRF_block;
class CPubdesc;
class CSP_block;
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqdesc_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqdesc_Base(void);
    // destructor
    virtual ~CSeqdesc_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Mol_type,     ///< type of molecule
        e_Modif,        ///< modifiers
        e_Method,       ///< sequencing method
        e_Name,         ///< a name for this sequence
        e_Title,        ///< a title for this sequence
        e_Org,          ///< if all from one organism
        e_Comment,      ///< a more extensive comment
        e_Num,          ///< a numbering system
        e_Maploc,       ///< map location of this sequence
        e_Pir,          ///< PIR specific info
        e_Genbank,      ///< GenBank specific info
        e_Pub,          ///< a reference to the publication
        e_Region,       ///< overall region (globin locus)
        e_User,         ///< user defined object
        e_Sp,           ///< SWISSPROT specific info
        e_Dbxref,       ///< xref to other databases
        e_Embl,         ///< EMBL specific information
        e_Create_date,  ///< date entry first created/released
        e_Update_date,  ///< date of last update
        e_Prf,          ///< PRF specific information
        e_Pdb,          ///< PDB specific information
        e_Het,          ///< cofactor, etc associated but not bound
        e_Source,       ///< source of materials, includes Org-ref
        e_Molinfo,      ///< info on the molecule and techniques
        e_Modelev       ///< model evidence for XM records
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 26 ///< == e_Modelev+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef EGIBB_mol TMol_type;
    typedef list< EGIBB_mod > TModif;
    typedef EGIBB_method TMethod;
    typedef string TName;
    typedef string TTitle;
    typedef COrg_ref TOrg;
    typedef string TComment;
    typedef CNumbering TNum;
    typedef CDbtag TMaploc;
    typedef CPIR_block TPir;
    typedef CGB_block TGenbank;
    typedef CPubdesc TPub;
    typedef string TRegion;
    typedef CUser_object TUser;
    typedef CSP_block TSp;
    typedef CDbtag TDbxref;
    typedef CEMBL_block TEmbl;
    typedef CDate TCreate_date;
    typedef CDate TUpdate_date;
    typedef CPRF_block TPrf;
    typedef CPDB_block TPdb;
    typedef CHeterogen THet;
    typedef CBioSource TSource;
    typedef CMolInfo TMolinfo;
    typedef CModelEvidenceSupport TModelev;

    // getters
    // setters

    // typedef EGIBB_mol TMol_type
    bool IsMol_type(void) const;
    TMol_type GetMol_type(void) const;
    TMol_type& SetMol_type(void);
    void SetMol_type(TMol_type value);

    // typedef list< EGIBB_mod > TModif
    bool IsModif(void) const;
    const TModif& GetModif(void) const;
    TModif& SetModif(void);

    // typedef EGIBB_method TMethod
    bool IsMethod(void) const;
    TMethod GetMethod(void) const;
    TMethod& SetMethod(void);
    void SetMethod(TMethod value);

    // typedef string TName
    bool IsName(void) const;
    const TName& GetName(void) const;
    TName& SetName(void);
    void SetName(const TName& value);

    // typedef string TTitle
    bool IsTitle(void) const;
    const TTitle& GetTitle(void) const;
    TTitle& SetTitle(void);
    void SetTitle(const TTitle& value);

    // typedef COrg_ref TOrg
    bool IsOrg(void) const;
    const TOrg& GetOrg(void) const;
    TOrg& SetOrg(void);
    void SetOrg(TOrg& value);

    // typedef string TComment
    bool IsComment(void) const;
    const TComment& GetComment(void) const;
    TComment& SetComment(void);
    void SetComment(const TComment& value);

    // typedef CNumbering TNum
    bool IsNum(void) const;
    const TNum& GetNum(void) const;
    TNum& SetNum(void);
    void SetNum(TNum& value);

    // typedef CDbtag TMaploc
    bool IsMaploc(void) const;
    const TMaploc& GetMaploc(void) const;
    TMaploc& SetMaploc(void);
    void SetMaploc(TMaploc& value);

    // typedef CPIR_block TPir
    bool IsPir(void) const;
    const TPir& GetPir(void) const;
    TPir& SetPir(void);
    void SetPir(TPir& value);

    // typedef CGB_block TGenbank
    bool IsGenbank(void) const;
    const TGenbank& GetGenbank(void) const;
    TGenbank& SetGenbank(void);
    void SetGenbank(TGenbank& value);

    // typedef CPubdesc TPub
    bool IsPub(void) const;
    const TPub& GetPub(void) const;
    TPub& SetPub(void);
    void SetPub(TPub& value);

    // typedef string TRegion
    bool IsRegion(void) const;
    const TRegion& GetRegion(void) const;
    TRegion& SetRegion(void);
    void SetRegion(const TRegion& value);

    // typedef CUser_object TUser
    bool IsUser(void) const;
    const TUser& GetUser(void) const;
    TUser& SetUser(void);
    void SetUser(TUser& value);

    // typedef CSP_block TSp
    bool IsSp(void) const;
    const TSp& GetSp(void) const;
    TSp& SetSp(void);
    void SetSp(TSp& value);

    // typedef CDbtag TDbxref
    bool IsDbxref(void) const;
    const TDbxref& GetDbxref(void) const;
    TDbxref& SetDbxref(void);
    void SetDbxref(TDbxref& value);

    // typedef CEMBL_block TEmbl
    bool IsEmbl(void) const;
    const TEmbl& GetEmbl(void) const;
    TEmbl& SetEmbl(void);
    void SetEmbl(TEmbl& value);

    // typedef CDate TCreate_date
    bool IsCreate_date(void) const;
    const TCreate_date& GetCreate_date(void) const;
    TCreate_date& SetCreate_date(void);
    void SetCreate_date(TCreate_date& value);

    // typedef CDate TUpdate_date
    bool IsUpdate_date(void) const;
    const TUpdate_date& GetUpdate_date(void) const;
    TUpdate_date& SetUpdate_date(void);
    void SetUpdate_date(TUpdate_date& value);

    // typedef CPRF_block TPrf
    bool IsPrf(void) const;
    const TPrf& GetPrf(void) const;
    TPrf& SetPrf(void);
    void SetPrf(TPrf& value);

    // typedef CPDB_block TPdb
    bool IsPdb(void) const;
    const TPdb& GetPdb(void) const;
    TPdb& SetPdb(void);
    void SetPdb(TPdb& value);

    // typedef CHeterogen THet
    bool IsHet(void) const;
    const THet& GetHet(void) const;
    THet& SetHet(void);
    void SetHet(const THet& value);

    // typedef CBioSource TSource
    bool IsSource(void) const;
    const TSource& GetSource(void) const;
    TSource& SetSource(void);
    void SetSource(TSource& value);

    // typedef CMolInfo TMolinfo
    bool IsMolinfo(void) const;
    const TMolinfo& GetMolinfo(void) const;
    TMolinfo& SetMolinfo(void);
    void SetMolinfo(TMolinfo& value);

    // typedef CModelEvidenceSupport TModelev
    bool IsModelev(void) const;
    const TModelev& GetModelev(void) const;
    TModelev& SetModelev(void);
    void SetModelev(TModelev& value);


private:
    // copy constructor and assignment operator
    CSeqdesc_Base(const CSeqdesc_Base& );
    CSeqdesc_Base& operator=(const CSeqdesc_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TMol_type m_Mol_type;
        NCBI_NS_NCBI::CUnionBuffer<TModif> m_Modif;
        TMethod m_Method;
        NCBI_NS_NCBI::CUnionBuffer<THet> m_Het;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeqdesc_Base::E_Choice CSeqdesc_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeqdesc_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqdesc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqdesc_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqdesc_Base::IsMol_type(void) const
{
    return m_choice == e_Mol_type;
}

inline
CSeqdesc_Base::TMol_type CSeqdesc_Base::GetMol_type(void) const
{
    CheckSelected(e_Mol_type);
    return m_Mol_type;
}

inline
CSeqdesc_Base::TMol_type& CSeqdesc_Base::SetMol_type(void)
{
    Select(e_Mol_type, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mol_type;
}

inline
void CSeqdesc_Base::SetMol_type(CSeqdesc_Base::TMol_type value)
{
    Select(e_Mol_type, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mol_type = value;
}

inline
bool CSeqdesc_Base::IsModif(void) const
{
    return m_choice == e_Modif;
}

inline
const CSeqdesc_Base::TModif& CSeqdesc_Base::GetModif(void) const
{
    CheckSelected(e_Modif);
    return *m_Modif;
}

inline
CSeqdesc_Base::TModif& CSeqdesc_Base::SetModif(void)
{
    Select(e_Modif, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Modif;
}

inline
bool CSeqdesc_Base::IsMethod(void) const
{
    return m_choice == e_Method;
}

inline
CSeqdesc_Base::TMethod CSeqdesc_Base::GetMethod(void) const
{
    CheckSelected(e_Method);
    return m_Method;
}

inline
CSeqdesc_Base::TMethod& CSeqdesc_Base::SetMethod(void)
{
    Select(e_Method, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Method;
}

inline
void CSeqdesc_Base::SetMethod(CSeqdesc_Base::TMethod value)
{
    Select(e_Method, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Method = value;
}

inline
bool CSeqdesc_Base::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CSeqdesc_Base::TName& CSeqdesc_Base::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CSeqdesc_Base::TName& CSeqdesc_Base::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqdesc_Base::IsTitle(void) const
{
    return m_choice == e_Title;
}

inline
const CSeqdesc_Base::TTitle& CSeqdesc_Base::GetTitle(void) const
{
    CheckSelected(e_Title);
    return *m_string;
}

inline
CSeqdesc_Base::TTitle& CSeqdesc_Base::SetTitle(void)
{
    Select(e_Title, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqdesc_Base::IsOrg(void) const
{
    return m_choice == e_Org;
}

inline
bool CSeqdesc_Base::IsComment(void) const
{
    return m_choice == e_Comment;
}

inline
const CSeqdesc_Base::TComment& CSeqdesc_Base::GetComment(void) const
{
    CheckSelected(e_Comment);
    return *m_string;
}

inline
CSeqdesc_Base::TComment& CSeqdesc_Base::SetComment(void)
{
    Select(e_Comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqdesc_Base::IsNum(void) const
{
    return m_choice == e_Num;
}

inline
bool CSeqdesc_Base::IsMaploc(void) const
{
    return m_choice == e_Maploc;
}

inline
bool CSeqdesc_Base::IsPir(void) const
{
    return m_choice == e_Pir;
}

inline
bool CSeqdesc_Base::IsGenbank(void) const
{
    return m_choice == e_Genbank;
}

inline
bool CSeqdesc_Base::IsPub(void) const
{
    return m_choice == e_Pub;
}

inline
bool CSeqdesc_Base::IsRegion(void) const
{
    return m_choice == e_Region;
}

inline
const CSeqdesc_Base::TRegion& CSeqdesc_Base::GetRegion(void) const
{
    CheckSelected(e_Region);
    return *m_string;
}

inline
CSeqdesc_Base::TRegion& CSeqdesc_Base::SetRegion(void)
{
    Select(e_Region, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSeqdesc_Base::IsUser(void) const
{
    return m_choice == e_User;
}

inline
bool CSeqdesc_Base::IsSp(void) const
{
    return m_choice == e_Sp;
}

inline
bool CSeqdesc_Base::IsDbxref(void) const
{
    return m_choice == e_Dbxref;
}

inline
bool CSeqdesc_Base::IsEmbl(void) const
{
    return m_choice == e_Embl;
}

inline
bool CSeqdesc_Base::IsCreate_date(void) const
{
    return m_choice == e_Create_date;
}

inline
bool CSeqdesc_Base::IsUpdate_date(void) const
{
    return m_choice == e_Update_date;
}

inline
bool CSeqdesc_Base::IsPrf(void) const
{
    return m_choice == e_Prf;
}

inline
bool CSeqdesc_Base::IsPdb(void) const
{
    return m_choice == e_Pdb;
}

inline
bool CSeqdesc_Base::IsHet(void) const
{
    return m_choice == e_Het;
}

inline
const CSeqdesc_Base::THet& CSeqdesc_Base::GetHet(void) const
{
    CheckSelected(e_Het);
    return *m_Het;
}

inline
CSeqdesc_Base::THet& CSeqdesc_Base::SetHet(void)
{
    Select(e_Het, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Het;
}

inline
bool CSeqdesc_Base::IsSource(void) const
{
    return m_choice == e_Source;
}

inline
bool CSeqdesc_Base::IsMolinfo(void) const
{
    return m_choice == e_Molinfo;
}

inline
bool CSeqdesc_Base::IsModelev(void) const
{
    return m_choice == e_Modelev;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQDESC_BASE_HPP
