/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Num_cont_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_NUM_CONT_BASE_HPP
#define OBJECTS_SEQ_NUM_CONT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// continuous display numbering system
class NCBI_SEQ_EXPORT CNum_cont_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNum_cont_Base(void);
    // destructor
    virtual ~CNum_cont_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSignedSeqPos TRefnum;
    typedef bool THas_zero;
    typedef bool TAscending;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_refnum,
        e_has_zero,
        e_ascending
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// number assigned to first residue
    /// optional with default 1
    /// typedef TSignedSeqPos TRefnum
    ///  Check whether the Refnum data member has been assigned a value.
    bool IsSetRefnum(void) const;
    /// Check whether it is safe or not to call GetRefnum method.
    bool CanGetRefnum(void) const;
    void ResetRefnum(void);
    void SetDefaultRefnum(void);
    TRefnum GetRefnum(void) const;
    void SetRefnum(TRefnum value);
    TRefnum& SetRefnum(void);

    /// 0 used?
    /// optional with default false
    /// typedef bool THas_zero
    ///  Check whether the Has_zero data member has been assigned a value.
    bool IsSetHas_zero(void) const;
    /// Check whether it is safe or not to call GetHas_zero method.
    bool CanGetHas_zero(void) const;
    void ResetHas_zero(void);
    void SetDefaultHas_zero(void);
    THas_zero GetHas_zero(void) const;
    void SetHas_zero(THas_zero value);
    THas_zero& SetHas_zero(void);

    /// ascending numbers?
    /// optional with default true
    /// typedef bool TAscending
    ///  Check whether the Ascending data member has been assigned a value.
    bool IsSetAscending(void) const;
    /// Check whether it is safe or not to call GetAscending method.
    bool CanGetAscending(void) const;
    void ResetAscending(void);
    void SetDefaultAscending(void);
    TAscending GetAscending(void) const;
    void SetAscending(TAscending value);
    TAscending& SetAscending(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNum_cont_Base(const CNum_cont_Base&);
    CNum_cont_Base& operator=(const CNum_cont_Base&);

    // data
    Uint4 m_set_State[1];
    TSignedSeqPos m_Refnum;
    bool m_Has_zero;
    bool m_Ascending;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNum_cont_Base::IsSetRefnum(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNum_cont_Base::CanGetRefnum(void) const
{
    return true;
}

inline
void CNum_cont_Base::ResetRefnum(void)
{
    m_Refnum = 1;
    m_set_State[0] &= ~0x3;
}

inline
void CNum_cont_Base::SetDefaultRefnum(void)
{
    ResetRefnum();
}

inline
CNum_cont_Base::TRefnum CNum_cont_Base::GetRefnum(void) const
{
    return m_Refnum;
}

inline
void CNum_cont_Base::SetRefnum(CNum_cont_Base::TRefnum value)
{
    m_Refnum = value;
    m_set_State[0] |= 0x3;
}

inline
CNum_cont_Base::TRefnum& CNum_cont_Base::SetRefnum(void)
{
#ifdef _DEBUG
    if (!IsSetRefnum()) {
        memset(&m_Refnum,UnassignedByte(),sizeof(m_Refnum));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Refnum;
}

inline
bool CNum_cont_Base::IsSetHas_zero(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNum_cont_Base::CanGetHas_zero(void) const
{
    return true;
}

inline
void CNum_cont_Base::ResetHas_zero(void)
{
    m_Has_zero = false;
    m_set_State[0] &= ~0xc;
}

inline
void CNum_cont_Base::SetDefaultHas_zero(void)
{
    ResetHas_zero();
}

inline
CNum_cont_Base::THas_zero CNum_cont_Base::GetHas_zero(void) const
{
    return m_Has_zero;
}

inline
void CNum_cont_Base::SetHas_zero(CNum_cont_Base::THas_zero value)
{
    m_Has_zero = value;
    m_set_State[0] |= 0xc;
}

inline
CNum_cont_Base::THas_zero& CNum_cont_Base::SetHas_zero(void)
{
#ifdef _DEBUG
    if (!IsSetHas_zero()) {
        memset(&m_Has_zero,UnassignedByte(),sizeof(m_Has_zero));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Has_zero;
}

inline
bool CNum_cont_Base::IsSetAscending(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CNum_cont_Base::CanGetAscending(void) const
{
    return true;
}

inline
void CNum_cont_Base::ResetAscending(void)
{
    m_Ascending = true;
    m_set_State[0] &= ~0x30;
}

inline
void CNum_cont_Base::SetDefaultAscending(void)
{
    ResetAscending();
}

inline
CNum_cont_Base::TAscending CNum_cont_Base::GetAscending(void) const
{
    return m_Ascending;
}

inline
void CNum_cont_Base::SetAscending(CNum_cont_Base::TAscending value)
{
    m_Ascending = value;
    m_set_State[0] |= 0x30;
}

inline
CNum_cont_Base::TAscending& CNum_cont_Base::SetAscending(void)
{
#ifdef _DEBUG
    if (!IsSetAscending()) {
        memset(&m_Ascending,UnassignedByte(),sizeof(m_Ascending));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Ascending;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_NUM_CONT_BASE_HPP
