/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MolInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_MOLINFO_BASE_HPP
#define OBJECTS_SEQ_MOLINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///******* NOTE:
///*       mol-type, modif, method, and org are consolidated and expanded
///*       in Org-ref, BioSource, and MolInfo in this specification. They
///*       will be removed in later specifications. Do not use them in the
///*       the future. Instead expect the new structures.
///*
///***************************
///********************************************************************
///
/// MolInfo gives information on the
/// classification of the type and quality of the sequence
///
/// WARNING: this will replace GIBB-mol, GIBB-mod, GIBB-method
///
///********************************************************************
class NCBI_SEQ_EXPORT CMolInfo_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolInfo_Base(void);
    // destructor
    virtual ~CMolInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EBiomol {
        eBiomol_unknown         =   0,
        eBiomol_genomic         =   1,
        eBiomol_pre_RNA         =   2,  ///< precursor RNA of any sort really
        eBiomol_mRNA            =   3,
        eBiomol_rRNA            =   4,
        eBiomol_tRNA            =   5,
        eBiomol_snRNA           =   6,
        eBiomol_scRNA           =   7,
        eBiomol_peptide         =   8,
        eBiomol_other_genetic   =   9,  ///< other genetic material
        eBiomol_genomic_mRNA    =  10,  ///< reported a mix of genomic and cdna sequence
        eBiomol_cRNA            =  11,  ///< viral RNA genome copy intermediate
        eBiomol_snoRNA          =  12,  ///< small nucleolar RNA
        eBiomol_transcribed_RNA =  13,  ///< transcribed RNA other than existing classes
        eBiomol_ncRNA           =  14,
        eBiomol_tmRNA           =  15,
        eBiomol_other           = 255
    };
    
    /// Access to EBiomol's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EBiomol)(void);
    
    enum ETech {
        eTech_unknown            =   0,
        eTech_standard           =   1,  ///< standard sequencing
        eTech_est                =   2,  ///< Expressed Sequence Tag
        eTech_sts                =   3,  ///< Sequence Tagged Site
        eTech_survey             =   4,  ///< one-pass genomic sequence
        eTech_genemap            =   5,  ///< from genetic mapping techniques
        eTech_physmap            =   6,  ///< from physical mapping techniques
        eTech_derived            =   7,  ///< derived from other data, not a primary entity
        eTech_concept_trans      =   8,  ///< conceptual translation
        eTech_seq_pept           =   9,  ///< peptide was sequenced
        eTech_both               =  10,  ///< concept transl. w/ partial pept. seq.
        eTech_seq_pept_overlap   =  11,  ///< sequenced peptide, ordered by overlap
        eTech_seq_pept_homol     =  12,  ///< sequenced peptide, ordered by homology
        eTech_concept_trans_a    =  13,  ///< conceptual transl. supplied by author
        eTech_htgs_1             =  14,  ///< unordered High Throughput sequence contig
        eTech_htgs_2             =  15,  ///< ordered High Throughput sequence contig
        eTech_htgs_3             =  16,  ///< finished High Throughput sequence
        eTech_fli_cdna           =  17,  ///< full length insert cDNA
        eTech_htgs_0             =  18,  ///< single genomic reads for coordination
        eTech_htc                =  19,  ///< high throughput cDNA
        eTech_wgs                =  20,  ///< whole genome shotgun sequencing
        eTech_barcode            =  21,  ///< barcode of life project
        eTech_composite_wgs_htgs =  22,  ///< composite of WGS and HTGS
        eTech_tsa                =  23,  ///< transcriptome shotgun assembly
        eTech_targeted           =  24,  ///< targeted locus sets/studies
        eTech_other              = 255  ///< use Source.techexp
    };
    
    /// Access to ETech's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETech)(void);
    
    enum ECompleteness {
        eCompleteness_unknown   =   0,
        eCompleteness_complete  =   1,  ///< complete biological entity
        eCompleteness_partial   =   2,  ///< partial but no details given
        eCompleteness_no_left   =   3,  ///< missing 5' or NH3 end
        eCompleteness_no_right  =   4,  ///< missing 3' or COOH end
        eCompleteness_no_ends   =   5,  ///< missing both ends
        eCompleteness_has_left  =   6,  ///< 5' or NH3 end present
        eCompleteness_has_right =   7,  ///< 3' or COOH end present
        eCompleteness_other     = 255
    };
    
    /// Access to ECompleteness's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ECompleteness)(void);
    
    // types
    typedef int TBiomol;
    typedef int TTech;
    typedef string TTechexp;
    typedef int TCompleteness;
    typedef string TGbmoltype;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_biomol,
        e_tech,
        e_techexp,
        e_completeness,
        e_gbmoltype
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// optional with default eBiomol_unknown
    /// typedef int TBiomol
    ///  Check whether the Biomol data member has been assigned a value.
    bool IsSetBiomol(void) const;
    /// Check whether it is safe or not to call GetBiomol method.
    bool CanGetBiomol(void) const;
    void ResetBiomol(void);
    void SetDefaultBiomol(void);
    TBiomol GetBiomol(void) const;
    void SetBiomol(TBiomol value);
    TBiomol& SetBiomol(void);

    /// optional with default eTech_unknown
    /// typedef int TTech
    ///  Check whether the Tech data member has been assigned a value.
    bool IsSetTech(void) const;
    /// Check whether it is safe or not to call GetTech method.
    bool CanGetTech(void) const;
    void ResetTech(void);
    void SetDefaultTech(void);
    TTech GetTech(void) const;
    void SetTech(TTech value);
    TTech& SetTech(void);

    /// explanation if tech not enough
    ///
    /// Completeness is not indicated in most records.  For genomes, assume
    /// the sequences are incomplete unless specifically marked as complete.
    /// For mRNAs, assume the ends are not known exactly unless marked as
    /// having the left or right end.
    ///
    /// optional
    /// typedef string TTechexp
    ///  Check whether the Techexp data member has been assigned a value.
    bool IsSetTechexp(void) const;
    /// Check whether it is safe or not to call GetTechexp method.
    bool CanGetTechexp(void) const;
    void ResetTechexp(void);
    const TTechexp& GetTechexp(void) const;
    void SetTechexp(const TTechexp& value);
    void SetTechexp(TTechexp&& value);
    TTechexp& SetTechexp(void);

    /// optional with default eCompleteness_unknown
    /// typedef int TCompleteness
    ///  Check whether the Completeness data member has been assigned a value.
    bool IsSetCompleteness(void) const;
    /// Check whether it is safe or not to call GetCompleteness method.
    bool CanGetCompleteness(void) const;
    void ResetCompleteness(void);
    void SetDefaultCompleteness(void);
    TCompleteness GetCompleteness(void) const;
    void SetCompleteness(TCompleteness value);
    TCompleteness& SetCompleteness(void);

    /// identifies particular ncRNA
    /// optional
    /// typedef string TGbmoltype
    ///  Check whether the Gbmoltype data member has been assigned a value.
    bool IsSetGbmoltype(void) const;
    /// Check whether it is safe or not to call GetGbmoltype method.
    bool CanGetGbmoltype(void) const;
    void ResetGbmoltype(void);
    const TGbmoltype& GetGbmoltype(void) const;
    void SetGbmoltype(const TGbmoltype& value);
    void SetGbmoltype(TGbmoltype&& value);
    TGbmoltype& SetGbmoltype(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMolInfo_Base(const CMolInfo_Base&);
    CMolInfo_Base& operator=(const CMolInfo_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Biomol;
    int m_Tech;
    string m_Techexp;
    int m_Completeness;
    string m_Gbmoltype;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMolInfo_Base::IsSetBiomol(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMolInfo_Base::CanGetBiomol(void) const
{
    return true;
}

inline
void CMolInfo_Base::ResetBiomol(void)
{
    m_Biomol = eBiomol_unknown;
    m_set_State[0] &= ~0x3;
}

inline
void CMolInfo_Base::SetDefaultBiomol(void)
{
    ResetBiomol();
}

inline
CMolInfo_Base::TBiomol CMolInfo_Base::GetBiomol(void) const
{
    return m_Biomol;
}

inline
void CMolInfo_Base::SetBiomol(CMolInfo_Base::TBiomol value)
{
    m_Biomol = value;
    m_set_State[0] |= 0x3;
}

inline
CMolInfo_Base::TBiomol& CMolInfo_Base::SetBiomol(void)
{
#ifdef _DEBUG
    if (!IsSetBiomol()) {
        memset(&m_Biomol,UnassignedByte(),sizeof(m_Biomol));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Biomol;
}

inline
bool CMolInfo_Base::IsSetTech(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMolInfo_Base::CanGetTech(void) const
{
    return true;
}

inline
void CMolInfo_Base::ResetTech(void)
{
    m_Tech = eTech_unknown;
    m_set_State[0] &= ~0xc;
}

inline
void CMolInfo_Base::SetDefaultTech(void)
{
    ResetTech();
}

inline
CMolInfo_Base::TTech CMolInfo_Base::GetTech(void) const
{
    return m_Tech;
}

inline
void CMolInfo_Base::SetTech(CMolInfo_Base::TTech value)
{
    m_Tech = value;
    m_set_State[0] |= 0xc;
}

inline
CMolInfo_Base::TTech& CMolInfo_Base::SetTech(void)
{
#ifdef _DEBUG
    if (!IsSetTech()) {
        memset(&m_Tech,UnassignedByte(),sizeof(m_Tech));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Tech;
}

inline
bool CMolInfo_Base::IsSetTechexp(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMolInfo_Base::CanGetTechexp(void) const
{
    return IsSetTechexp();
}

inline
const CMolInfo_Base::TTechexp& CMolInfo_Base::GetTechexp(void) const
{
    if (!CanGetTechexp()) {
        ThrowUnassigned(2);
    }
    return m_Techexp;
}

inline
void CMolInfo_Base::SetTechexp(const CMolInfo_Base::TTechexp& value)
{
    m_Techexp = value;
    m_set_State[0] |= 0x30;
}

inline
void CMolInfo_Base::SetTechexp(CMolInfo_Base::TTechexp&& value)
{
    m_Techexp = std::forward<CMolInfo_Base::TTechexp>(value);
    m_set_State[0] |= 0x30;
}

inline
CMolInfo_Base::TTechexp& CMolInfo_Base::SetTechexp(void)
{
#ifdef _DEBUG
    if (!IsSetTechexp()) {
        m_Techexp = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Techexp;
}

inline
bool CMolInfo_Base::IsSetCompleteness(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMolInfo_Base::CanGetCompleteness(void) const
{
    return true;
}

inline
void CMolInfo_Base::ResetCompleteness(void)
{
    m_Completeness = eCompleteness_unknown;
    m_set_State[0] &= ~0xc0;
}

inline
void CMolInfo_Base::SetDefaultCompleteness(void)
{
    ResetCompleteness();
}

inline
CMolInfo_Base::TCompleteness CMolInfo_Base::GetCompleteness(void) const
{
    return m_Completeness;
}

inline
void CMolInfo_Base::SetCompleteness(CMolInfo_Base::TCompleteness value)
{
    m_Completeness = value;
    m_set_State[0] |= 0xc0;
}

inline
CMolInfo_Base::TCompleteness& CMolInfo_Base::SetCompleteness(void)
{
#ifdef _DEBUG
    if (!IsSetCompleteness()) {
        memset(&m_Completeness,UnassignedByte(),sizeof(m_Completeness));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Completeness;
}

inline
bool CMolInfo_Base::IsSetGbmoltype(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMolInfo_Base::CanGetGbmoltype(void) const
{
    return IsSetGbmoltype();
}

inline
const CMolInfo_Base::TGbmoltype& CMolInfo_Base::GetGbmoltype(void) const
{
    if (!CanGetGbmoltype()) {
        ThrowUnassigned(4);
    }
    return m_Gbmoltype;
}

inline
void CMolInfo_Base::SetGbmoltype(const CMolInfo_Base::TGbmoltype& value)
{
    m_Gbmoltype = value;
    m_set_State[0] |= 0x300;
}

inline
void CMolInfo_Base::SetGbmoltype(CMolInfo_Base::TGbmoltype&& value)
{
    m_Gbmoltype = std::forward<CMolInfo_Base::TGbmoltype>(value);
    m_set_State[0] |= 0x300;
}

inline
CMolInfo_Base::TGbmoltype& CMolInfo_Base::SetGbmoltype(void)
{
#ifdef _DEBUG
    if (!IsSetGbmoltype()) {
        m_Gbmoltype = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Gbmoltype;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_MOLINFO_BASE_HPP
