/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PssmIntermediateData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_PSSMINTERMEDIATEDATA_BASE_HPP
#define OBJECTS_SCOREMAT_PSSMINTERMEDIATEDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Contains the PSSM's intermediate data used to create the PSSM's scores 
/// and statistical parameters. Dimensions and order in which scores are 
/// stored must be the same as that specified in Pssm::numRows, 
/// Pssm::numColumns, and Pssm::byrow
class NCBI_SCOREMAT_EXPORT CPssmIntermediateData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPssmIntermediateData_Base(void);
    // destructor
    virtual ~CPssmIntermediateData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< int > TResFreqsPerPos;
    typedef list< double > TWeightedResFreqsPerPos;
    typedef list< double > TFreqRatios;
    typedef list< double > TInformationContent;
    typedef list< double > TGaplessColumnWeights;
    typedef list< double > TSigma;
    typedef list< int > TIntervalSizes;
    typedef list< int > TNumMatchingSeqs;
    typedef list< double > TNumIndeptObsr;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_resFreqsPerPos,
        e_weightedResFreqsPerPos,
        e_freqRatios,
        e_informationContent,
        e_gaplessColumnWeights,
        e_sigma,
        e_intervalSizes,
        e_numMatchingSeqs,
        e_numIndeptObsr
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// observed residue frequencies (or counts) per position of the PSSM 
    /// (prior to application of pseudocounts)
    /// optional
    /// typedef list< int > TResFreqsPerPos
    ///  Check whether the ResFreqsPerPos data member has been assigned a value.
    bool IsSetResFreqsPerPos(void) const;
    /// Check whether it is safe or not to call GetResFreqsPerPos method.
    bool CanGetResFreqsPerPos(void) const;
    void ResetResFreqsPerPos(void);
    const TResFreqsPerPos& GetResFreqsPerPos(void) const;
    TResFreqsPerPos& SetResFreqsPerPos(void);

    /// Weighted observed residue frequencies per position of the PSSM.
    /// (N.B.: each position's weights should add up to 1.0).
    /// This field corresponds to f_i (f sub i) in equation 2 of 
    /// Nucleic Acids Res. 2001 Jul 15;29(14):2994-3005.
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< double > TWeightedResFreqsPerPos
    ///  Check whether the WeightedResFreqsPerPos data member has been assigned a value.
    bool IsSetWeightedResFreqsPerPos(void) const;
    /// Check whether it is safe or not to call GetWeightedResFreqsPerPos method.
    bool CanGetWeightedResFreqsPerPos(void) const;
    void ResetWeightedResFreqsPerPos(void);
    const TWeightedResFreqsPerPos& GetWeightedResFreqsPerPos(void) const;
    TWeightedResFreqsPerPos& SetWeightedResFreqsPerPos(void);

    /// PSSM's frequency ratios
    /// mandatory
    /// typedef list< double > TFreqRatios
    ///  Check whether the FreqRatios data member has been assigned a value.
    bool IsSetFreqRatios(void) const;
    /// Check whether it is safe or not to call GetFreqRatios method.
    bool CanGetFreqRatios(void) const;
    void ResetFreqRatios(void);
    const TFreqRatios& GetFreqRatios(void) const;
    TFreqRatios& SetFreqRatios(void);

    /// Information content per position of the PSSM
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< double > TInformationContent
    ///  Check whether the InformationContent data member has been assigned a value.
    bool IsSetInformationContent(void) const;
    /// Check whether it is safe or not to call GetInformationContent method.
    bool CanGetInformationContent(void) const;
    void ResetInformationContent(void);
    const TInformationContent& GetInformationContent(void) const;
    TInformationContent& SetInformationContent(void);

    /// Relative weight for columns of the PSSM without gaps to pseudocounts
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< double > TGaplessColumnWeights
    ///  Check whether the GaplessColumnWeights data member has been assigned a value.
    bool IsSetGaplessColumnWeights(void) const;
    /// Check whether it is safe or not to call GetGaplessColumnWeights method.
    bool CanGetGaplessColumnWeights(void) const;
    void ResetGaplessColumnWeights(void);
    const TGaplessColumnWeights& GetGaplessColumnWeights(void) const;
    TGaplessColumnWeights& SetGaplessColumnWeights(void);

    /// Used in sequence weights computation
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< double > TSigma
    ///  Check whether the Sigma data member has been assigned a value.
    bool IsSetSigma(void) const;
    /// Check whether it is safe or not to call GetSigma method.
    bool CanGetSigma(void) const;
    void ResetSigma(void);
    const TSigma& GetSigma(void) const;
    TSigma& SetSigma(void);

    /// Length of the aligned regions per position of the query sequence
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< int > TIntervalSizes
    ///  Check whether the IntervalSizes data member has been assigned a value.
    bool IsSetIntervalSizes(void) const;
    /// Check whether it is safe or not to call GetIntervalSizes method.
    bool CanGetIntervalSizes(void) const;
    void ResetIntervalSizes(void);
    const TIntervalSizes& GetIntervalSizes(void) const;
    TIntervalSizes& SetIntervalSizes(void);

    /// Number of matching sequences per position of the PSSM (including the
    /// query)
    /// NOTE: this is needed for diagnostics information only (i.e.:
    /// -out_ascii_pssm option in psiblast)
    /// optional
    /// typedef list< int > TNumMatchingSeqs
    ///  Check whether the NumMatchingSeqs data member has been assigned a value.
    bool IsSetNumMatchingSeqs(void) const;
    /// Check whether it is safe or not to call GetNumMatchingSeqs method.
    bool CanGetNumMatchingSeqs(void) const;
    void ResetNumMatchingSeqs(void);
    const TNumMatchingSeqs& GetNumMatchingSeqs(void) const;
    TNumMatchingSeqs& SetNumMatchingSeqs(void);

    /// Number of independent observations per position of the PSSM
    /// NOTE: this is needed for building CDD database for DELTA-BLAST
    /// optional
    /// typedef list< double > TNumIndeptObsr
    ///  Check whether the NumIndeptObsr data member has been assigned a value.
    bool IsSetNumIndeptObsr(void) const;
    /// Check whether it is safe or not to call GetNumIndeptObsr method.
    bool CanGetNumIndeptObsr(void) const;
    void ResetNumIndeptObsr(void);
    const TNumIndeptObsr& GetNumIndeptObsr(void) const;
    TNumIndeptObsr& SetNumIndeptObsr(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPssmIntermediateData_Base(const CPssmIntermediateData_Base&);
    CPssmIntermediateData_Base& operator=(const CPssmIntermediateData_Base&);

    // data
    Uint4 m_set_State[1];
    list< int > m_ResFreqsPerPos;
    list< double > m_WeightedResFreqsPerPos;
    list< double > m_FreqRatios;
    list< double > m_InformationContent;
    list< double > m_GaplessColumnWeights;
    list< double > m_Sigma;
    list< int > m_IntervalSizes;
    list< int > m_NumMatchingSeqs;
    list< double > m_NumIndeptObsr;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPssmIntermediateData_Base::IsSetResFreqsPerPos(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetResFreqsPerPos(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TResFreqsPerPos& CPssmIntermediateData_Base::GetResFreqsPerPos(void) const
{
    return m_ResFreqsPerPos;
}

inline
CPssmIntermediateData_Base::TResFreqsPerPos& CPssmIntermediateData_Base::SetResFreqsPerPos(void)
{
    m_set_State[0] |= 0x1;
    return m_ResFreqsPerPos;
}

inline
bool CPssmIntermediateData_Base::IsSetWeightedResFreqsPerPos(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetWeightedResFreqsPerPos(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TWeightedResFreqsPerPos& CPssmIntermediateData_Base::GetWeightedResFreqsPerPos(void) const
{
    return m_WeightedResFreqsPerPos;
}

inline
CPssmIntermediateData_Base::TWeightedResFreqsPerPos& CPssmIntermediateData_Base::SetWeightedResFreqsPerPos(void)
{
    m_set_State[0] |= 0x4;
    return m_WeightedResFreqsPerPos;
}

inline
bool CPssmIntermediateData_Base::IsSetFreqRatios(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetFreqRatios(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TFreqRatios& CPssmIntermediateData_Base::GetFreqRatios(void) const
{
    return m_FreqRatios;
}

inline
CPssmIntermediateData_Base::TFreqRatios& CPssmIntermediateData_Base::SetFreqRatios(void)
{
    m_set_State[0] |= 0x10;
    return m_FreqRatios;
}

inline
bool CPssmIntermediateData_Base::IsSetInformationContent(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetInformationContent(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TInformationContent& CPssmIntermediateData_Base::GetInformationContent(void) const
{
    return m_InformationContent;
}

inline
CPssmIntermediateData_Base::TInformationContent& CPssmIntermediateData_Base::SetInformationContent(void)
{
    m_set_State[0] |= 0x40;
    return m_InformationContent;
}

inline
bool CPssmIntermediateData_Base::IsSetGaplessColumnWeights(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetGaplessColumnWeights(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TGaplessColumnWeights& CPssmIntermediateData_Base::GetGaplessColumnWeights(void) const
{
    return m_GaplessColumnWeights;
}

inline
CPssmIntermediateData_Base::TGaplessColumnWeights& CPssmIntermediateData_Base::SetGaplessColumnWeights(void)
{
    m_set_State[0] |= 0x100;
    return m_GaplessColumnWeights;
}

inline
bool CPssmIntermediateData_Base::IsSetSigma(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetSigma(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TSigma& CPssmIntermediateData_Base::GetSigma(void) const
{
    return m_Sigma;
}

inline
CPssmIntermediateData_Base::TSigma& CPssmIntermediateData_Base::SetSigma(void)
{
    m_set_State[0] |= 0x400;
    return m_Sigma;
}

inline
bool CPssmIntermediateData_Base::IsSetIntervalSizes(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetIntervalSizes(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TIntervalSizes& CPssmIntermediateData_Base::GetIntervalSizes(void) const
{
    return m_IntervalSizes;
}

inline
CPssmIntermediateData_Base::TIntervalSizes& CPssmIntermediateData_Base::SetIntervalSizes(void)
{
    m_set_State[0] |= 0x1000;
    return m_IntervalSizes;
}

inline
bool CPssmIntermediateData_Base::IsSetNumMatchingSeqs(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetNumMatchingSeqs(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TNumMatchingSeqs& CPssmIntermediateData_Base::GetNumMatchingSeqs(void) const
{
    return m_NumMatchingSeqs;
}

inline
CPssmIntermediateData_Base::TNumMatchingSeqs& CPssmIntermediateData_Base::SetNumMatchingSeqs(void)
{
    m_set_State[0] |= 0x4000;
    return m_NumMatchingSeqs;
}

inline
bool CPssmIntermediateData_Base::IsSetNumIndeptObsr(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPssmIntermediateData_Base::CanGetNumIndeptObsr(void) const
{
    return true;
}

inline
const CPssmIntermediateData_Base::TNumIndeptObsr& CPssmIntermediateData_Base::GetNumIndeptObsr(void) const
{
    return m_NumIndeptObsr;
}

inline
CPssmIntermediateData_Base::TNumIndeptObsr& CPssmIntermediateData_Base::SetNumIndeptObsr(void)
{
    m_set_State[0] |= 0x10000;
    return m_NumIndeptObsr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSMINTERMEDIATEDATA_BASE_HPP
