/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file remap_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'remap.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_REMAP_REMAP_CLIENT_BASE_HPP
#define OBJECTS_REMAP_REMAP_CLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/remap/RMReply.hpp>
#include <objects/remap/RMRequest.hpp>
#include <objects/remap/Remap_reply.hpp>
#include <objects/remap/Remap_request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_REMAP_EXPORT CRemapClient_Base : public CRPCClient<CRemap_request, CRemap_reply>
{
    typedef CRPCClient<CRemap_request, CRemap_reply> Tparent;
public:
    // constructor
    CRemapClient_Base(void);
    // destructor
    virtual ~CRemapClient_Base(void);

    typedef CRemap_request TRequest;
    typedef CRemap_reply TReply;
    typedef CRMRequest TRequestChoice;
    typedef CRMReply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);


    virtual const TRequest& GetDefaultRequest(void) const;
    virtual TRequest&       SetDefaultRequest(void);
    virtual void            SetDefaultRequest(const TRequest& request);

    virtual void Ask(const TRequestChoice& req, TReply& reply);
    virtual void Ask(const TRequestChoice& req, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual CRef<CRemap_result> AskRemap
        (const CRemap_query& req, TReply* reply = 0);

    virtual list< string > AskMaps_to_builds
        (const string& req, TReply* reply = 0);

    virtual list< string > AskMaps_from_builds
        (const string& req, TReply* reply = 0);

    virtual list< string > AskAll_builds
        (TReply* reply = 0);


private:
    CRef<TRequest> m_DefaultRequest;

    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CRemapClient_Base::TReplyChoice& CRemapClient_Base::x_Choice(CRemapClient_Base::TReply& reply)
{
    return reply.SetReply();
}

inline
void CRemapClient_Base::Ask(const CRemapClient_Base::TRequest& request, CRemapClient_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


inline
const CRemapClient_Base::TRequest& CRemapClient_Base::GetDefaultRequest(void) const
{
    return *m_DefaultRequest;
}

inline
CRemapClient_Base::TRequest& CRemapClient_Base::SetDefaultRequest(void)
{
    return *m_DefaultRequest;
}

inline
void CRemapClient_Base::SetDefaultRequest(const CRemapClient_Base::TRequest& request)
{
    m_DefaultRequest->Assign(request);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_REMAP_REMAP_CLIENT_BASE_HPP
