/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_XRefData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_XREFDATA_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_XREFDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Depositor Provided X-Ref and LinkOut data for Entrez
class NCBI_PCSUBSTANCE_EXPORT CPC_XRefData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_XRefData_Base(void);
    // destructor
    virtual ~CPC_XRefData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,           ///< No variant selected
        e_Regid,                 ///< External Database Registry ID
        e_Rn,                    ///< Registry Number (e.g., EC Number, CAS Number)
        e_Mesh,                  ///< MESH Index Term
        e_Pmid,                  ///< PubMed ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Gi,                    ///< GenBank General ID    Note: Please use protein-gi or nucleotide-gi, if possible    Note: Must be greater than "0" or, if invalid, "0"
        e_Mmdb,                  ///< MMDB ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Sid,                   ///< PubChem Substance ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Cid,                   ///< PubChem Compound ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Dburl,                 ///< Depositor Source Database Homepage
        e_Sburl,                 ///< Depositor Homepage for a Substance
        e_Asurl,                 ///< Depositor Homepage for an Assay
        e_Protein_gi,            ///< GenBank General ID for a Protein    Note: Must be greater than "0" or, if invalid, "0"
        e_Nucleotide_gi,         ///< GenBank General ID for a Nucleotide    Note: Must be greater than "0" or, if invalid, "0"
        e_Taxonomy,              ///< Taxonomy ID for an Organism    Note: Must be greater than "0" or, if invalid, "0"
        e_Aid,                   ///< PubChem BioAssay ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Mim,                   ///< MIM, Mendelian Inheritance in Man, Number    Note: Must be greater than "0" or, if invalid, "0"
        e_Gene,                  ///< Entrez Gene ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Probe,                 ///< Probe ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Biosystem,             ///< BioSystem ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Geogse,                ///< Gene Expression Omnibus Series Accession (GEO GSE) ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Geogsm,                ///< Gene Expression Omnibus Sample Accession (GEO GSM) ID    Note: Must be greater than "0" or, if invalid, "0"
        e_Patent,                ///< Patent Identifier (e.g., USPTO, EPO, WPO, JPO, CPO)
        e_Protein_accession,     ///< GenBank Accession for a Protein
        e_Nucleotide_accession,  ///< GenBank Accession for a Nucleotide
        e_Doi,                   ///< digital object identifier (DOI)
        e_Citation               ///< citation when PMID or DOI are not available
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 27 ///< == e_Citation+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TRegid;
    typedef string TRn;
    typedef string TMesh;
    typedef int TPmid;
    typedef int TGi;
    typedef int TMmdb;
    typedef int TSid;
    typedef int TCid;
    typedef string TDburl;
    typedef string TSburl;
    typedef string TAsurl;
    typedef int TProtein_gi;
    typedef int TNucleotide_gi;
    typedef int TTaxonomy;
    typedef int TAid;
    typedef int TMim;
    typedef int TGene;
    typedef int TProbe;
    typedef int TBiosystem;
    typedef int TGeogse;
    typedef int TGeogsm;
    typedef string TPatent;
    typedef string TProtein_accession;
    typedef string TNucleotide_accession;
    typedef string TDoi;
    typedef string TCitation;

    // getters
    // setters

    // typedef string TRegid
    bool IsRegid(void) const;
    const TRegid& GetRegid(void) const;
    TRegid& SetRegid(void);
    void SetRegid(const TRegid& value);

    // typedef string TRn
    bool IsRn(void) const;
    const TRn& GetRn(void) const;
    TRn& SetRn(void);
    void SetRn(const TRn& value);

    // typedef string TMesh
    bool IsMesh(void) const;
    const TMesh& GetMesh(void) const;
    TMesh& SetMesh(void);
    void SetMesh(const TMesh& value);

    // typedef int TPmid
    bool IsPmid(void) const;
    TPmid GetPmid(void) const;
    TPmid& SetPmid(void);
    void SetPmid(TPmid value);

    // typedef int TGi
    bool IsGi(void) const;
    TGi GetGi(void) const;
    TGi& SetGi(void);
    void SetGi(TGi value);

    // typedef int TMmdb
    bool IsMmdb(void) const;
    TMmdb GetMmdb(void) const;
    TMmdb& SetMmdb(void);
    void SetMmdb(TMmdb value);

    // typedef int TSid
    bool IsSid(void) const;
    TSid GetSid(void) const;
    TSid& SetSid(void);
    void SetSid(TSid value);

    // typedef int TCid
    bool IsCid(void) const;
    TCid GetCid(void) const;
    TCid& SetCid(void);
    void SetCid(TCid value);

    // typedef string TDburl
    bool IsDburl(void) const;
    const TDburl& GetDburl(void) const;
    TDburl& SetDburl(void);
    void SetDburl(const TDburl& value);

    // typedef string TSburl
    bool IsSburl(void) const;
    const TSburl& GetSburl(void) const;
    TSburl& SetSburl(void);
    void SetSburl(const TSburl& value);

    // typedef string TAsurl
    bool IsAsurl(void) const;
    const TAsurl& GetAsurl(void) const;
    TAsurl& SetAsurl(void);
    void SetAsurl(const TAsurl& value);

    // typedef int TProtein_gi
    bool IsProtein_gi(void) const;
    TProtein_gi GetProtein_gi(void) const;
    TProtein_gi& SetProtein_gi(void);
    void SetProtein_gi(TProtein_gi value);

    // typedef int TNucleotide_gi
    bool IsNucleotide_gi(void) const;
    TNucleotide_gi GetNucleotide_gi(void) const;
    TNucleotide_gi& SetNucleotide_gi(void);
    void SetNucleotide_gi(TNucleotide_gi value);

    // typedef int TTaxonomy
    bool IsTaxonomy(void) const;
    TTaxonomy GetTaxonomy(void) const;
    TTaxonomy& SetTaxonomy(void);
    void SetTaxonomy(TTaxonomy value);

    // typedef int TAid
    bool IsAid(void) const;
    TAid GetAid(void) const;
    TAid& SetAid(void);
    void SetAid(TAid value);

    // typedef int TMim
    bool IsMim(void) const;
    TMim GetMim(void) const;
    TMim& SetMim(void);
    void SetMim(TMim value);

    // typedef int TGene
    bool IsGene(void) const;
    TGene GetGene(void) const;
    TGene& SetGene(void);
    void SetGene(TGene value);

    // typedef int TProbe
    bool IsProbe(void) const;
    TProbe GetProbe(void) const;
    TProbe& SetProbe(void);
    void SetProbe(TProbe value);

    // typedef int TBiosystem
    bool IsBiosystem(void) const;
    TBiosystem GetBiosystem(void) const;
    TBiosystem& SetBiosystem(void);
    void SetBiosystem(TBiosystem value);

    // typedef int TGeogse
    bool IsGeogse(void) const;
    TGeogse GetGeogse(void) const;
    TGeogse& SetGeogse(void);
    void SetGeogse(TGeogse value);

    // typedef int TGeogsm
    bool IsGeogsm(void) const;
    TGeogsm GetGeogsm(void) const;
    TGeogsm& SetGeogsm(void);
    void SetGeogsm(TGeogsm value);

    // typedef string TPatent
    bool IsPatent(void) const;
    const TPatent& GetPatent(void) const;
    TPatent& SetPatent(void);
    void SetPatent(const TPatent& value);

    // typedef string TProtein_accession
    bool IsProtein_accession(void) const;
    const TProtein_accession& GetProtein_accession(void) const;
    TProtein_accession& SetProtein_accession(void);
    void SetProtein_accession(const TProtein_accession& value);

    // typedef string TNucleotide_accession
    bool IsNucleotide_accession(void) const;
    const TNucleotide_accession& GetNucleotide_accession(void) const;
    TNucleotide_accession& SetNucleotide_accession(void);
    void SetNucleotide_accession(const TNucleotide_accession& value);

    // typedef string TDoi
    bool IsDoi(void) const;
    const TDoi& GetDoi(void) const;
    TDoi& SetDoi(void);
    void SetDoi(const TDoi& value);

    // typedef string TCitation
    bool IsCitation(void) const;
    const TCitation& GetCitation(void) const;
    TCitation& SetCitation(void);
    void SetCitation(const TCitation& value);


private:
    // copy constructor and assignment operator
    CPC_XRefData_Base(const CPC_XRefData_Base& );
    CPC_XRefData_Base& operator=(const CPC_XRefData_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TPmid m_Pmid;
        TGi m_Gi;
        TMmdb m_Mmdb;
        TSid m_Sid;
        TCid m_Cid;
        TProtein_gi m_Protein_gi;
        TNucleotide_gi m_Nucleotide_gi;
        TTaxonomy m_Taxonomy;
        TAid m_Aid;
        TMim m_Mim;
        TGene m_Gene;
        TProbe m_Probe;
        TBiosystem m_Biosystem;
        TGeogse m_Geogse;
        TGeogsm m_Geogsm;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_XRefData_Base::E_Choice CPC_XRefData_Base::Which(void) const
{
    return m_choice;
}

inline
void CPC_XRefData_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_XRefData_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_XRefData_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_XRefData_Base::IsRegid(void) const
{
    return m_choice == e_Regid;
}

inline
const CPC_XRefData_Base::TRegid& CPC_XRefData_Base::GetRegid(void) const
{
    CheckSelected(e_Regid);
    return *m_string;
}

inline
CPC_XRefData_Base::TRegid& CPC_XRefData_Base::SetRegid(void)
{
    Select(e_Regid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsRn(void) const
{
    return m_choice == e_Rn;
}

inline
const CPC_XRefData_Base::TRn& CPC_XRefData_Base::GetRn(void) const
{
    CheckSelected(e_Rn);
    return *m_string;
}

inline
CPC_XRefData_Base::TRn& CPC_XRefData_Base::SetRn(void)
{
    Select(e_Rn, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsMesh(void) const
{
    return m_choice == e_Mesh;
}

inline
const CPC_XRefData_Base::TMesh& CPC_XRefData_Base::GetMesh(void) const
{
    CheckSelected(e_Mesh);
    return *m_string;
}

inline
CPC_XRefData_Base::TMesh& CPC_XRefData_Base::SetMesh(void)
{
    Select(e_Mesh, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsPmid(void) const
{
    return m_choice == e_Pmid;
}

inline
CPC_XRefData_Base::TPmid CPC_XRefData_Base::GetPmid(void) const
{
    CheckSelected(e_Pmid);
    return m_Pmid;
}

inline
CPC_XRefData_Base::TPmid& CPC_XRefData_Base::SetPmid(void)
{
    Select(e_Pmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Pmid;
}

inline
void CPC_XRefData_Base::SetPmid(CPC_XRefData_Base::TPmid value)
{
    Select(e_Pmid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Pmid = value;
}

inline
bool CPC_XRefData_Base::IsGi(void) const
{
    return m_choice == e_Gi;
}

inline
CPC_XRefData_Base::TGi CPC_XRefData_Base::GetGi(void) const
{
    CheckSelected(e_Gi);
    return m_Gi;
}

inline
CPC_XRefData_Base::TGi& CPC_XRefData_Base::SetGi(void)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gi;
}

inline
void CPC_XRefData_Base::SetGi(CPC_XRefData_Base::TGi value)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gi = value;
}

inline
bool CPC_XRefData_Base::IsMmdb(void) const
{
    return m_choice == e_Mmdb;
}

inline
CPC_XRefData_Base::TMmdb CPC_XRefData_Base::GetMmdb(void) const
{
    CheckSelected(e_Mmdb);
    return m_Mmdb;
}

inline
CPC_XRefData_Base::TMmdb& CPC_XRefData_Base::SetMmdb(void)
{
    Select(e_Mmdb, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mmdb;
}

inline
void CPC_XRefData_Base::SetMmdb(CPC_XRefData_Base::TMmdb value)
{
    Select(e_Mmdb, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mmdb = value;
}

inline
bool CPC_XRefData_Base::IsSid(void) const
{
    return m_choice == e_Sid;
}

inline
CPC_XRefData_Base::TSid CPC_XRefData_Base::GetSid(void) const
{
    CheckSelected(e_Sid);
    return m_Sid;
}

inline
CPC_XRefData_Base::TSid& CPC_XRefData_Base::SetSid(void)
{
    Select(e_Sid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Sid;
}

inline
void CPC_XRefData_Base::SetSid(CPC_XRefData_Base::TSid value)
{
    Select(e_Sid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Sid = value;
}

inline
bool CPC_XRefData_Base::IsCid(void) const
{
    return m_choice == e_Cid;
}

inline
CPC_XRefData_Base::TCid CPC_XRefData_Base::GetCid(void) const
{
    CheckSelected(e_Cid);
    return m_Cid;
}

inline
CPC_XRefData_Base::TCid& CPC_XRefData_Base::SetCid(void)
{
    Select(e_Cid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Cid;
}

inline
void CPC_XRefData_Base::SetCid(CPC_XRefData_Base::TCid value)
{
    Select(e_Cid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Cid = value;
}

inline
bool CPC_XRefData_Base::IsDburl(void) const
{
    return m_choice == e_Dburl;
}

inline
const CPC_XRefData_Base::TDburl& CPC_XRefData_Base::GetDburl(void) const
{
    CheckSelected(e_Dburl);
    return *m_string;
}

inline
CPC_XRefData_Base::TDburl& CPC_XRefData_Base::SetDburl(void)
{
    Select(e_Dburl, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsSburl(void) const
{
    return m_choice == e_Sburl;
}

inline
const CPC_XRefData_Base::TSburl& CPC_XRefData_Base::GetSburl(void) const
{
    CheckSelected(e_Sburl);
    return *m_string;
}

inline
CPC_XRefData_Base::TSburl& CPC_XRefData_Base::SetSburl(void)
{
    Select(e_Sburl, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsAsurl(void) const
{
    return m_choice == e_Asurl;
}

inline
const CPC_XRefData_Base::TAsurl& CPC_XRefData_Base::GetAsurl(void) const
{
    CheckSelected(e_Asurl);
    return *m_string;
}

inline
CPC_XRefData_Base::TAsurl& CPC_XRefData_Base::SetAsurl(void)
{
    Select(e_Asurl, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsProtein_gi(void) const
{
    return m_choice == e_Protein_gi;
}

inline
CPC_XRefData_Base::TProtein_gi CPC_XRefData_Base::GetProtein_gi(void) const
{
    CheckSelected(e_Protein_gi);
    return m_Protein_gi;
}

inline
CPC_XRefData_Base::TProtein_gi& CPC_XRefData_Base::SetProtein_gi(void)
{
    Select(e_Protein_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Protein_gi;
}

inline
void CPC_XRefData_Base::SetProtein_gi(CPC_XRefData_Base::TProtein_gi value)
{
    Select(e_Protein_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Protein_gi = value;
}

inline
bool CPC_XRefData_Base::IsNucleotide_gi(void) const
{
    return m_choice == e_Nucleotide_gi;
}

inline
CPC_XRefData_Base::TNucleotide_gi CPC_XRefData_Base::GetNucleotide_gi(void) const
{
    CheckSelected(e_Nucleotide_gi);
    return m_Nucleotide_gi;
}

inline
CPC_XRefData_Base::TNucleotide_gi& CPC_XRefData_Base::SetNucleotide_gi(void)
{
    Select(e_Nucleotide_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Nucleotide_gi;
}

inline
void CPC_XRefData_Base::SetNucleotide_gi(CPC_XRefData_Base::TNucleotide_gi value)
{
    Select(e_Nucleotide_gi, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Nucleotide_gi = value;
}

inline
bool CPC_XRefData_Base::IsTaxonomy(void) const
{
    return m_choice == e_Taxonomy;
}

inline
CPC_XRefData_Base::TTaxonomy CPC_XRefData_Base::GetTaxonomy(void) const
{
    CheckSelected(e_Taxonomy);
    return m_Taxonomy;
}

inline
CPC_XRefData_Base::TTaxonomy& CPC_XRefData_Base::SetTaxonomy(void)
{
    Select(e_Taxonomy, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Taxonomy;
}

inline
void CPC_XRefData_Base::SetTaxonomy(CPC_XRefData_Base::TTaxonomy value)
{
    Select(e_Taxonomy, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Taxonomy = value;
}

inline
bool CPC_XRefData_Base::IsAid(void) const
{
    return m_choice == e_Aid;
}

inline
CPC_XRefData_Base::TAid CPC_XRefData_Base::GetAid(void) const
{
    CheckSelected(e_Aid);
    return m_Aid;
}

inline
CPC_XRefData_Base::TAid& CPC_XRefData_Base::SetAid(void)
{
    Select(e_Aid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Aid;
}

inline
void CPC_XRefData_Base::SetAid(CPC_XRefData_Base::TAid value)
{
    Select(e_Aid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Aid = value;
}

inline
bool CPC_XRefData_Base::IsMim(void) const
{
    return m_choice == e_Mim;
}

inline
CPC_XRefData_Base::TMim CPC_XRefData_Base::GetMim(void) const
{
    CheckSelected(e_Mim);
    return m_Mim;
}

inline
CPC_XRefData_Base::TMim& CPC_XRefData_Base::SetMim(void)
{
    Select(e_Mim, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Mim;
}

inline
void CPC_XRefData_Base::SetMim(CPC_XRefData_Base::TMim value)
{
    Select(e_Mim, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Mim = value;
}

inline
bool CPC_XRefData_Base::IsGene(void) const
{
    return m_choice == e_Gene;
}

inline
CPC_XRefData_Base::TGene CPC_XRefData_Base::GetGene(void) const
{
    CheckSelected(e_Gene);
    return m_Gene;
}

inline
CPC_XRefData_Base::TGene& CPC_XRefData_Base::SetGene(void)
{
    Select(e_Gene, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gene;
}

inline
void CPC_XRefData_Base::SetGene(CPC_XRefData_Base::TGene value)
{
    Select(e_Gene, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gene = value;
}

inline
bool CPC_XRefData_Base::IsProbe(void) const
{
    return m_choice == e_Probe;
}

inline
CPC_XRefData_Base::TProbe CPC_XRefData_Base::GetProbe(void) const
{
    CheckSelected(e_Probe);
    return m_Probe;
}

inline
CPC_XRefData_Base::TProbe& CPC_XRefData_Base::SetProbe(void)
{
    Select(e_Probe, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Probe;
}

inline
void CPC_XRefData_Base::SetProbe(CPC_XRefData_Base::TProbe value)
{
    Select(e_Probe, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Probe = value;
}

inline
bool CPC_XRefData_Base::IsBiosystem(void) const
{
    return m_choice == e_Biosystem;
}

inline
CPC_XRefData_Base::TBiosystem CPC_XRefData_Base::GetBiosystem(void) const
{
    CheckSelected(e_Biosystem);
    return m_Biosystem;
}

inline
CPC_XRefData_Base::TBiosystem& CPC_XRefData_Base::SetBiosystem(void)
{
    Select(e_Biosystem, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Biosystem;
}

inline
void CPC_XRefData_Base::SetBiosystem(CPC_XRefData_Base::TBiosystem value)
{
    Select(e_Biosystem, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Biosystem = value;
}

inline
bool CPC_XRefData_Base::IsGeogse(void) const
{
    return m_choice == e_Geogse;
}

inline
CPC_XRefData_Base::TGeogse CPC_XRefData_Base::GetGeogse(void) const
{
    CheckSelected(e_Geogse);
    return m_Geogse;
}

inline
CPC_XRefData_Base::TGeogse& CPC_XRefData_Base::SetGeogse(void)
{
    Select(e_Geogse, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Geogse;
}

inline
void CPC_XRefData_Base::SetGeogse(CPC_XRefData_Base::TGeogse value)
{
    Select(e_Geogse, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Geogse = value;
}

inline
bool CPC_XRefData_Base::IsGeogsm(void) const
{
    return m_choice == e_Geogsm;
}

inline
CPC_XRefData_Base::TGeogsm CPC_XRefData_Base::GetGeogsm(void) const
{
    CheckSelected(e_Geogsm);
    return m_Geogsm;
}

inline
CPC_XRefData_Base::TGeogsm& CPC_XRefData_Base::SetGeogsm(void)
{
    Select(e_Geogsm, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Geogsm;
}

inline
void CPC_XRefData_Base::SetGeogsm(CPC_XRefData_Base::TGeogsm value)
{
    Select(e_Geogsm, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Geogsm = value;
}

inline
bool CPC_XRefData_Base::IsPatent(void) const
{
    return m_choice == e_Patent;
}

inline
const CPC_XRefData_Base::TPatent& CPC_XRefData_Base::GetPatent(void) const
{
    CheckSelected(e_Patent);
    return *m_string;
}

inline
CPC_XRefData_Base::TPatent& CPC_XRefData_Base::SetPatent(void)
{
    Select(e_Patent, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsProtein_accession(void) const
{
    return m_choice == e_Protein_accession;
}

inline
const CPC_XRefData_Base::TProtein_accession& CPC_XRefData_Base::GetProtein_accession(void) const
{
    CheckSelected(e_Protein_accession);
    return *m_string;
}

inline
CPC_XRefData_Base::TProtein_accession& CPC_XRefData_Base::SetProtein_accession(void)
{
    Select(e_Protein_accession, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsNucleotide_accession(void) const
{
    return m_choice == e_Nucleotide_accession;
}

inline
const CPC_XRefData_Base::TNucleotide_accession& CPC_XRefData_Base::GetNucleotide_accession(void) const
{
    CheckSelected(e_Nucleotide_accession);
    return *m_string;
}

inline
CPC_XRefData_Base::TNucleotide_accession& CPC_XRefData_Base::SetNucleotide_accession(void)
{
    Select(e_Nucleotide_accession, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsDoi(void) const
{
    return m_choice == e_Doi;
}

inline
const CPC_XRefData_Base::TDoi& CPC_XRefData_Base::GetDoi(void) const
{
    CheckSelected(e_Doi);
    return *m_string;
}

inline
CPC_XRefData_Base::TDoi& CPC_XRefData_Base::SetDoi(void)
{
    Select(e_Doi, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_XRefData_Base::IsCitation(void) const
{
    return m_choice == e_Citation;
}

inline
const CPC_XRefData_Base::TCitation& CPC_XRefData_Base::GetCitation(void) const
{
    CheckSelected(e_Citation);
    return *m_string;
}

inline
CPC_XRefData_Base::TCitation& CPC_XRefData_Base::SetCitation(void)
{
    Select(e_Citation, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_XREFDATA_BASE_HPP
