/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_InfoData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_INFODATA_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_INFODATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CPC_Urn;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Compound Description/Descriptor Data
class NCBI_PCSUBSTANCE_EXPORT CPC_InfoData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_InfoData_Base(void);
    // destructor
    virtual ~CPC_InfoData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// Data Value
    class NCBI_PCSUBSTANCE_EXPORT C_Value : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Value(void);
        // destructor
        ~C_Value(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Bval,         ///< Boolean or Binary
            e_Bvec,         ///< Boolean Vector
            e_Ival,         ///< Integer (signed or unsigned)
            e_Ivec,         ///< Integer Vector
            e_Fval,         ///< Float or Double
            e_Fvec,         ///< Double Vector
            e_Sval,         ///< String
            e_Slist,        ///< List of Strings
            e_Date,         ///< Date
            e_Binary,       ///< Binary Data
            e_Bitlist       ///< Bit List (specialized version of Boolean vector)
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 12 ///< == e_Bitlist+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef bool TBval;
        typedef vector< char > TBvec;
        typedef int TIval;
        typedef vector< int > TIvec;
        typedef double TFval;
        typedef vector< double > TFvec;
        typedef string TSval;
        typedef list< string > TSlist;
        typedef CDate TDate;
        typedef vector< char > TBinary;
        typedef CBitString TBitlist;
    
        // getters
        // setters
    
        // typedef bool TBval
        bool IsBval(void) const;
        TBval GetBval(void) const;
        TBval& SetBval(void);
        void SetBval(TBval value);
    
        // typedef vector< char > TBvec
        bool IsBvec(void) const;
        const TBvec& GetBvec(void) const;
        TBvec& SetBvec(void);
    
        // typedef int TIval
        bool IsIval(void) const;
        TIval GetIval(void) const;
        TIval& SetIval(void);
        void SetIval(TIval value);
    
        // typedef vector< int > TIvec
        bool IsIvec(void) const;
        const TIvec& GetIvec(void) const;
        TIvec& SetIvec(void);
    
        // typedef double TFval
        bool IsFval(void) const;
        TFval GetFval(void) const;
        TFval& SetFval(void);
        void SetFval(TFval value);
    
        // typedef vector< double > TFvec
        bool IsFvec(void) const;
        const TFvec& GetFvec(void) const;
        TFvec& SetFvec(void);
    
        // typedef string TSval
        bool IsSval(void) const;
        const TSval& GetSval(void) const;
        TSval& SetSval(void);
        void SetSval(const TSval& value);
    
        // typedef list< string > TSlist
        bool IsSlist(void) const;
        const TSlist& GetSlist(void) const;
        TSlist& SetSlist(void);
    
        // typedef CDate TDate
        bool IsDate(void) const;
        const TDate& GetDate(void) const;
        TDate& SetDate(void);
        void SetDate(TDate& value);
    
        // typedef vector< char > TBinary
        bool IsBinary(void) const;
        const TBinary& GetBinary(void) const;
        TBinary& SetBinary(void);
    
        // typedef CBitString TBitlist
        bool IsBitlist(void) const;
        const TBitlist& GetBitlist(void) const;
        TBitlist& SetBitlist(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Value(const C_Value& );
        C_Value& operator=(const C_Value& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TBval m_Bval;
            NCBI_NS_NCBI::CUnionBuffer<TBvec> m_Bvec;
            TIval m_Ival;
            NCBI_NS_NCBI::CUnionBuffer<TIvec> m_Ivec;
            TFval m_Fval;
            NCBI_NS_NCBI::CUnionBuffer<TFvec> m_Fvec;
            NCBI_NS_NCBI::CUnionBuffer<TSlist> m_Slist;
            NCBI_NS_NCBI::CUnionBuffer<TBinary> m_Binary;
            NCBI_NS_NCBI::CUnionBuffer<TBitlist> m_Bitlist;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef CPC_Urn TUrn;
    typedef C_Value TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_urn,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Universal Resource Name  [for Value Qualification]
    /// mandatory
    /// typedef CPC_Urn TUrn
    ///  Check whether the Urn data member has been assigned a value.
    bool IsSetUrn(void) const;
    /// Check whether it is safe or not to call GetUrn method.
    bool CanGetUrn(void) const;
    void ResetUrn(void);
    const TUrn& GetUrn(void) const;
    void SetUrn(TUrn& value);
    TUrn& SetUrn(void);

    /// mandatory
    /// typedef C_Value TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(TValue& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_InfoData_Base(const CPC_InfoData_Base&);
    CPC_InfoData_Base& operator=(const CPC_InfoData_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TUrn > m_Urn;
    CRef< TValue > m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_InfoData_Base::C_Value::E_Choice CPC_InfoData_Base::C_Value::Which(void) const
{
    return m_choice;
}

inline
void CPC_InfoData_Base::C_Value::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_InfoData_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_InfoData_Base::C_Value::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_InfoData_Base::C_Value::IsBval(void) const
{
    return m_choice == e_Bval;
}

inline
CPC_InfoData_Base::C_Value::TBval CPC_InfoData_Base::C_Value::GetBval(void) const
{
    CheckSelected(e_Bval);
    return m_Bval;
}

inline
CPC_InfoData_Base::C_Value::TBval& CPC_InfoData_Base::C_Value::SetBval(void)
{
    Select(e_Bval, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Bval;
}

inline
void CPC_InfoData_Base::C_Value::SetBval(CPC_InfoData_Base::C_Value::TBval value)
{
    Select(e_Bval, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Bval = value;
}

inline
bool CPC_InfoData_Base::C_Value::IsBvec(void) const
{
    return m_choice == e_Bvec;
}

inline
const CPC_InfoData_Base::C_Value::TBvec& CPC_InfoData_Base::C_Value::GetBvec(void) const
{
    CheckSelected(e_Bvec);
    return *m_Bvec;
}

inline
CPC_InfoData_Base::C_Value::TBvec& CPC_InfoData_Base::C_Value::SetBvec(void)
{
    Select(e_Bvec, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bvec;
}

inline
bool CPC_InfoData_Base::C_Value::IsIval(void) const
{
    return m_choice == e_Ival;
}

inline
CPC_InfoData_Base::C_Value::TIval CPC_InfoData_Base::C_Value::GetIval(void) const
{
    CheckSelected(e_Ival);
    return m_Ival;
}

inline
CPC_InfoData_Base::C_Value::TIval& CPC_InfoData_Base::C_Value::SetIval(void)
{
    Select(e_Ival, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Ival;
}

inline
void CPC_InfoData_Base::C_Value::SetIval(CPC_InfoData_Base::C_Value::TIval value)
{
    Select(e_Ival, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Ival = value;
}

inline
bool CPC_InfoData_Base::C_Value::IsIvec(void) const
{
    return m_choice == e_Ivec;
}

inline
const CPC_InfoData_Base::C_Value::TIvec& CPC_InfoData_Base::C_Value::GetIvec(void) const
{
    CheckSelected(e_Ivec);
    return *m_Ivec;
}

inline
CPC_InfoData_Base::C_Value::TIvec& CPC_InfoData_Base::C_Value::SetIvec(void)
{
    Select(e_Ivec, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ivec;
}

inline
bool CPC_InfoData_Base::C_Value::IsFval(void) const
{
    return m_choice == e_Fval;
}

inline
CPC_InfoData_Base::C_Value::TFval CPC_InfoData_Base::C_Value::GetFval(void) const
{
    CheckSelected(e_Fval);
    return m_Fval;
}

inline
CPC_InfoData_Base::C_Value::TFval& CPC_InfoData_Base::C_Value::SetFval(void)
{
    Select(e_Fval, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Fval;
}

inline
void CPC_InfoData_Base::C_Value::SetFval(CPC_InfoData_Base::C_Value::TFval value)
{
    Select(e_Fval, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Fval = value;
}

inline
bool CPC_InfoData_Base::C_Value::IsFvec(void) const
{
    return m_choice == e_Fvec;
}

inline
const CPC_InfoData_Base::C_Value::TFvec& CPC_InfoData_Base::C_Value::GetFvec(void) const
{
    CheckSelected(e_Fvec);
    return *m_Fvec;
}

inline
CPC_InfoData_Base::C_Value::TFvec& CPC_InfoData_Base::C_Value::SetFvec(void)
{
    Select(e_Fvec, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Fvec;
}

inline
bool CPC_InfoData_Base::C_Value::IsSval(void) const
{
    return m_choice == e_Sval;
}

inline
const CPC_InfoData_Base::C_Value::TSval& CPC_InfoData_Base::C_Value::GetSval(void) const
{
    CheckSelected(e_Sval);
    return *m_string;
}

inline
CPC_InfoData_Base::C_Value::TSval& CPC_InfoData_Base::C_Value::SetSval(void)
{
    Select(e_Sval, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_InfoData_Base::C_Value::IsSlist(void) const
{
    return m_choice == e_Slist;
}

inline
const CPC_InfoData_Base::C_Value::TSlist& CPC_InfoData_Base::C_Value::GetSlist(void) const
{
    CheckSelected(e_Slist);
    return *m_Slist;
}

inline
CPC_InfoData_Base::C_Value::TSlist& CPC_InfoData_Base::C_Value::SetSlist(void)
{
    Select(e_Slist, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Slist;
}

inline
bool CPC_InfoData_Base::C_Value::IsDate(void) const
{
    return m_choice == e_Date;
}

inline
bool CPC_InfoData_Base::C_Value::IsBinary(void) const
{
    return m_choice == e_Binary;
}

inline
const CPC_InfoData_Base::C_Value::TBinary& CPC_InfoData_Base::C_Value::GetBinary(void) const
{
    CheckSelected(e_Binary);
    return *m_Binary;
}

inline
CPC_InfoData_Base::C_Value::TBinary& CPC_InfoData_Base::C_Value::SetBinary(void)
{
    Select(e_Binary, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Binary;
}

inline
bool CPC_InfoData_Base::C_Value::IsBitlist(void) const
{
    return m_choice == e_Bitlist;
}

inline
const CPC_InfoData_Base::C_Value::TBitlist& CPC_InfoData_Base::C_Value::GetBitlist(void) const
{
    CheckSelected(e_Bitlist);
    return *m_Bitlist;
}

inline
CPC_InfoData_Base::C_Value::TBitlist& CPC_InfoData_Base::C_Value::SetBitlist(void)
{
    Select(e_Bitlist, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bitlist;
}

inline
bool CPC_InfoData_Base::IsSetUrn(void) const
{
    return m_Urn.NotEmpty();
}

inline
bool CPC_InfoData_Base::CanGetUrn(void) const
{
    return true;
}

inline
const CPC_InfoData_Base::TUrn& CPC_InfoData_Base::GetUrn(void) const
{
    if ( !m_Urn ) {
        const_cast<CPC_InfoData_Base*>(this)->ResetUrn();
    }
    return (*m_Urn);
}

inline
CPC_InfoData_Base::TUrn& CPC_InfoData_Base::SetUrn(void)
{
    if ( !m_Urn ) {
        ResetUrn();
    }
    return (*m_Urn);
}

inline
bool CPC_InfoData_Base::IsSetValue(void) const
{
    return m_Value.NotEmpty();
}

inline
bool CPC_InfoData_Base::CanGetValue(void) const
{
    return true;
}

inline
const CPC_InfoData_Base::TValue& CPC_InfoData_Base::GetValue(void) const
{
    if ( !m_Value ) {
        const_cast<CPC_InfoData_Base*>(this)->ResetValue();
    }
    return (*m_Value);
}

inline
CPC_InfoData_Base::TValue& CPC_InfoData_Base::SetValue(void)
{
    if ( !m_Value ) {
        ResetValue();
    }
    return (*m_Value);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_INFODATA_BASE_HPP
