/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Coordinates_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_COORDINATES_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_COORDINATES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <vector>
#include <objects/pcsubstance/PC_CoordinateType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_AtomString;
class CPC_Conformer;
class CPC_InfoData;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Coordinates for the Compound of a given type
class NCBI_PCSUBSTANCE_EXPORT CPC_Coordinates_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Coordinates_Base(void);
    // destructor
    virtual ~CPC_Coordinates_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef vector< int > TType;
    typedef vector< int > TAid;
    typedef list< CRef< CPC_Conformer > > TConformers;
    typedef list< CRef< CPC_AtomString > > TAtomlabels;
    typedef list< CRef< CPC_InfoData > > TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_aid,
        e_conformers,
        e_atomlabels,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// Coordinate Type Information (vector)
    /// mandatory
    /// typedef vector< int > TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    const TType& GetType(void) const;
    TType& SetType(void);

    /// Conformer Atom IDs (vector)
    ///   (to be kept synchronized with Conformers)
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef vector< int > TAid
    ///  Check whether the Aid data member has been assigned a value.
    bool IsSetAid(void) const;
    /// Check whether it is safe or not to call GetAid method.
    bool CanGetAid(void) const;
    void ResetAid(void);
    const TAid& GetAid(void) const;
    TAid& SetAid(void);

    /// Conformers for this Coordinate Set
    /// optional
    /// typedef list< CRef< CPC_Conformer > > TConformers
    ///  Check whether the Conformers data member has been assigned a value.
    bool IsSetConformers(void) const;
    /// Check whether it is safe or not to call GetConformers method.
    bool CanGetConformers(void) const;
    void ResetConformers(void);
    const TConformers& GetConformers(void) const;
    TConformers& SetConformers(void);

    /// Atom labels for Conformer Set
    /// optional
    /// typedef list< CRef< CPC_AtomString > > TAtomlabels
    ///  Check whether the Atomlabels data member has been assigned a value.
    bool IsSetAtomlabels(void) const;
    /// Check whether it is safe or not to call GetAtomlabels method.
    bool CanGetAtomlabels(void) const;
    void ResetAtomlabels(void);
    const TAtomlabels& GetAtomlabels(void) const;
    TAtomlabels& SetAtomlabels(void);

    /// Data Associated with these Coordinates
    /// optional
    /// typedef list< CRef< CPC_InfoData > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Coordinates_Base(const CPC_Coordinates_Base&);
    CPC_Coordinates_Base& operator=(const CPC_Coordinates_Base&);

    // data
    Uint4 m_set_State[1];
    vector< int > m_Type;
    vector< int > m_Aid;
    list< CRef< CPC_Conformer > > m_Conformers;
    list< CRef< CPC_AtomString > > m_Atomlabels;
    list< CRef< CPC_InfoData > > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Coordinates_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Coordinates_Base::CanGetType(void) const
{
    return true;
}

inline
const CPC_Coordinates_Base::TType& CPC_Coordinates_Base::GetType(void) const
{
    return m_Type;
}

inline
CPC_Coordinates_Base::TType& CPC_Coordinates_Base::SetType(void)
{
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CPC_Coordinates_Base::IsSetAid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Coordinates_Base::CanGetAid(void) const
{
    return true;
}

inline
const CPC_Coordinates_Base::TAid& CPC_Coordinates_Base::GetAid(void) const
{
    return m_Aid;
}

inline
CPC_Coordinates_Base::TAid& CPC_Coordinates_Base::SetAid(void)
{
    m_set_State[0] |= 0x4;
    return m_Aid;
}

inline
bool CPC_Coordinates_Base::IsSetConformers(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Coordinates_Base::CanGetConformers(void) const
{
    return true;
}

inline
const CPC_Coordinates_Base::TConformers& CPC_Coordinates_Base::GetConformers(void) const
{
    return m_Conformers;
}

inline
CPC_Coordinates_Base::TConformers& CPC_Coordinates_Base::SetConformers(void)
{
    m_set_State[0] |= 0x10;
    return m_Conformers;
}

inline
bool CPC_Coordinates_Base::IsSetAtomlabels(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Coordinates_Base::CanGetAtomlabels(void) const
{
    return true;
}

inline
const CPC_Coordinates_Base::TAtomlabels& CPC_Coordinates_Base::GetAtomlabels(void) const
{
    return m_Atomlabels;
}

inline
CPC_Coordinates_Base::TAtomlabels& CPC_Coordinates_Base::SetAtomlabels(void)
{
    m_set_State[0] |= 0x40;
    return m_Atomlabels;
}

inline
bool CPC_Coordinates_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Coordinates_Base::CanGetData(void) const
{
    return true;
}

inline
const CPC_Coordinates_Base::TData& CPC_Coordinates_Base::GetData(void) const
{
    return m_Data;
}

inline
CPC_Coordinates_Base::TData& CPC_Coordinates_Base::SetData(void)
{
    m_set_State[0] |= 0x100;
    return m_Data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_COORDINATES_BASE_HPP
