/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Bracket_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_BRACKET_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_BRACKET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Display coordinates for a bracket (e.g. from MOL field SDI)
class NCBI_PCSUBSTANCE_EXPORT CPC_Bracket_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Bracket_Base(void);
    // destructor
    virtual ~CPC_Bracket_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TX1;
    typedef double TY1;
    typedef double TX2;
    typedef double TY2;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_x1,
        e_y1,
        e_x2,
        e_y2
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TX1
    ///  Check whether the X1 data member has been assigned a value.
    bool IsSetX1(void) const;
    /// Check whether it is safe or not to call GetX1 method.
    bool CanGetX1(void) const;
    void ResetX1(void);
    TX1 GetX1(void) const;
    void SetX1(TX1 value);
    TX1& SetX1(void);

    /// mandatory
    /// typedef double TY1
    ///  Check whether the Y1 data member has been assigned a value.
    bool IsSetY1(void) const;
    /// Check whether it is safe or not to call GetY1 method.
    bool CanGetY1(void) const;
    void ResetY1(void);
    TY1 GetY1(void) const;
    void SetY1(TY1 value);
    TY1& SetY1(void);

    /// mandatory
    /// typedef double TX2
    ///  Check whether the X2 data member has been assigned a value.
    bool IsSetX2(void) const;
    /// Check whether it is safe or not to call GetX2 method.
    bool CanGetX2(void) const;
    void ResetX2(void);
    TX2 GetX2(void) const;
    void SetX2(TX2 value);
    TX2& SetX2(void);

    /// mandatory
    /// typedef double TY2
    ///  Check whether the Y2 data member has been assigned a value.
    bool IsSetY2(void) const;
    /// Check whether it is safe or not to call GetY2 method.
    bool CanGetY2(void) const;
    void ResetY2(void);
    TY2 GetY2(void) const;
    void SetY2(TY2 value);
    TY2& SetY2(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Bracket_Base(const CPC_Bracket_Base&);
    CPC_Bracket_Base& operator=(const CPC_Bracket_Base&);

    // data
    Uint4 m_set_State[1];
    double m_X1;
    double m_Y1;
    double m_X2;
    double m_Y2;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Bracket_Base::IsSetX1(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Bracket_Base::CanGetX1(void) const
{
    return IsSetX1();
}

inline
void CPC_Bracket_Base::ResetX1(void)
{
    m_X1 = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_Bracket_Base::TX1 CPC_Bracket_Base::GetX1(void) const
{
    if (!CanGetX1()) {
        ThrowUnassigned(0);
    }
    return m_X1;
}

inline
void CPC_Bracket_Base::SetX1(CPC_Bracket_Base::TX1 value)
{
    m_X1 = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_Bracket_Base::TX1& CPC_Bracket_Base::SetX1(void)
{
#ifdef _DEBUG
    if (!IsSetX1()) {
        memset(&m_X1,UnassignedByte(),sizeof(m_X1));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_X1;
}

inline
bool CPC_Bracket_Base::IsSetY1(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Bracket_Base::CanGetY1(void) const
{
    return IsSetY1();
}

inline
void CPC_Bracket_Base::ResetY1(void)
{
    m_Y1 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_Bracket_Base::TY1 CPC_Bracket_Base::GetY1(void) const
{
    if (!CanGetY1()) {
        ThrowUnassigned(1);
    }
    return m_Y1;
}

inline
void CPC_Bracket_Base::SetY1(CPC_Bracket_Base::TY1 value)
{
    m_Y1 = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_Bracket_Base::TY1& CPC_Bracket_Base::SetY1(void)
{
#ifdef _DEBUG
    if (!IsSetY1()) {
        memset(&m_Y1,UnassignedByte(),sizeof(m_Y1));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Y1;
}

inline
bool CPC_Bracket_Base::IsSetX2(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Bracket_Base::CanGetX2(void) const
{
    return IsSetX2();
}

inline
void CPC_Bracket_Base::ResetX2(void)
{
    m_X2 = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_Bracket_Base::TX2 CPC_Bracket_Base::GetX2(void) const
{
    if (!CanGetX2()) {
        ThrowUnassigned(2);
    }
    return m_X2;
}

inline
void CPC_Bracket_Base::SetX2(CPC_Bracket_Base::TX2 value)
{
    m_X2 = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_Bracket_Base::TX2& CPC_Bracket_Base::SetX2(void)
{
#ifdef _DEBUG
    if (!IsSetX2()) {
        memset(&m_X2,UnassignedByte(),sizeof(m_X2));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_X2;
}

inline
bool CPC_Bracket_Base::IsSetY2(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Bracket_Base::CanGetY2(void) const
{
    return IsSetY2();
}

inline
void CPC_Bracket_Base::ResetY2(void)
{
    m_Y2 = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_Bracket_Base::TY2 CPC_Bracket_Base::GetY2(void) const
{
    if (!CanGetY2()) {
        ThrowUnassigned(3);
    }
    return m_Y2;
}

inline
void CPC_Bracket_Base::SetY2(CPC_Bracket_Base::TY2 value)
{
    m_Y2 = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_Bracket_Base::TY2& CPC_Bracket_Base::SetY2(void)
{
#ifdef _DEBUG
    if (!IsSetY2()) {
        memset(&m_Y2,UnassignedByte(),sizeof(m_Y2));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Y2;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_BRACKET_BASE_HPP
