/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Atoms_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_ATOMS_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_ATOMS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <vector>
#include <objects/pcsubstance/PC_Element.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_AtomInt;
class CPC_AtomRadical;
class CPC_AtomSource;
class CPC_AtomString;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Atom Information  (in Parallel Arrays)
class NCBI_PCSUBSTANCE_EXPORT CPC_Atoms_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Atoms_Base(void);
    // destructor
    virtual ~CPC_Atoms_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef vector< int > TAid;
    typedef vector< int > TElement;
    typedef list< CRef< CPC_AtomString > > TLabel;
    typedef list< CRef< CPC_AtomInt > > TIsotope;
    typedef list< CRef< CPC_AtomInt > > TCharge;
    typedef list< CRef< CPC_AtomRadical > > TRadical;
    typedef list< CRef< CPC_AtomSource > > TSource;
    typedef list< CRef< CPC_AtomString > > TComment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_aid,
        e_element,
        e_label,
        e_isotope,
        e_charge,
        e_radical,
        e_source,
        e_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    ///  [Note: Parallel Arrays must be kept Synchronized]
    /// Atom Identifiers (vector)
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef vector< int > TAid
    ///  Check whether the Aid data member has been assigned a value.
    bool IsSetAid(void) const;
    /// Check whether it is safe or not to call GetAid method.
    bool CanGetAid(void) const;
    void ResetAid(void);
    const TAid& GetAid(void) const;
    TAid& SetAid(void);

    /// Atomic Numbers (vector)
    /// mandatory
    /// typedef vector< int > TElement
    ///  Check whether the Element data member has been assigned a value.
    bool IsSetElement(void) const;
    /// Check whether it is safe or not to call GetElement method.
    bool CanGetElement(void) const;
    void ResetElement(void);
    const TElement& GetElement(void) const;
    TElement& SetElement(void);

    /// Independent Arrays of ID-Value Pairs  (Technically allows multiple values per Atom)
    /// Atom labels
    /// optional
    /// typedef list< CRef< CPC_AtomString > > TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    TLabel& SetLabel(void);

    /// Isotopic Information
    /// optional
    /// typedef list< CRef< CPC_AtomInt > > TIsotope
    ///  Check whether the Isotope data member has been assigned a value.
    bool IsSetIsotope(void) const;
    /// Check whether it is safe or not to call GetIsotope method.
    bool CanGetIsotope(void) const;
    void ResetIsotope(void);
    const TIsotope& GetIsotope(void) const;
    TIsotope& SetIsotope(void);

    /// Formal Charges
    /// optional
    /// typedef list< CRef< CPC_AtomInt > > TCharge
    ///  Check whether the Charge data member has been assigned a value.
    bool IsSetCharge(void) const;
    /// Check whether it is safe or not to call GetCharge method.
    bool CanGetCharge(void) const;
    void ResetCharge(void);
    const TCharge& GetCharge(void) const;
    TCharge& SetCharge(void);

    /// Radical Information
    /// optional
    /// typedef list< CRef< CPC_AtomRadical > > TRadical
    ///  Check whether the Radical data member has been assigned a value.
    bool IsSetRadical(void) const;
    /// Check whether it is safe or not to call GetRadical method.
    bool CanGetRadical(void) const;
    void ResetRadical(void);
    const TRadical& GetRadical(void) const;
    TRadical& SetRadical(void);

    /// E.g. identity of MMDB "R" groups
    /// optional
    /// typedef list< CRef< CPC_AtomSource > > TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    TSource& SetSource(void);

    /// Atom Comments
    /// optional
    /// typedef list< CRef< CPC_AtomString > > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Atoms_Base(const CPC_Atoms_Base&);
    CPC_Atoms_Base& operator=(const CPC_Atoms_Base&);

    // data
    Uint4 m_set_State[1];
    vector< int > m_Aid;
    vector< int > m_Element;
    list< CRef< CPC_AtomString > > m_Label;
    list< CRef< CPC_AtomInt > > m_Isotope;
    list< CRef< CPC_AtomInt > > m_Charge;
    list< CRef< CPC_AtomRadical > > m_Radical;
    list< CRef< CPC_AtomSource > > m_Source;
    list< CRef< CPC_AtomString > > m_Comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Atoms_Base::IsSetAid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Atoms_Base::CanGetAid(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TAid& CPC_Atoms_Base::GetAid(void) const
{
    return m_Aid;
}

inline
CPC_Atoms_Base::TAid& CPC_Atoms_Base::SetAid(void)
{
    m_set_State[0] |= 0x1;
    return m_Aid;
}

inline
bool CPC_Atoms_Base::IsSetElement(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Atoms_Base::CanGetElement(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TElement& CPC_Atoms_Base::GetElement(void) const
{
    return m_Element;
}

inline
CPC_Atoms_Base::TElement& CPC_Atoms_Base::SetElement(void)
{
    m_set_State[0] |= 0x4;
    return m_Element;
}

inline
bool CPC_Atoms_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Atoms_Base::CanGetLabel(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TLabel& CPC_Atoms_Base::GetLabel(void) const
{
    return m_Label;
}

inline
CPC_Atoms_Base::TLabel& CPC_Atoms_Base::SetLabel(void)
{
    m_set_State[0] |= 0x10;
    return m_Label;
}

inline
bool CPC_Atoms_Base::IsSetIsotope(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Atoms_Base::CanGetIsotope(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TIsotope& CPC_Atoms_Base::GetIsotope(void) const
{
    return m_Isotope;
}

inline
CPC_Atoms_Base::TIsotope& CPC_Atoms_Base::SetIsotope(void)
{
    m_set_State[0] |= 0x40;
    return m_Isotope;
}

inline
bool CPC_Atoms_Base::IsSetCharge(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Atoms_Base::CanGetCharge(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TCharge& CPC_Atoms_Base::GetCharge(void) const
{
    return m_Charge;
}

inline
CPC_Atoms_Base::TCharge& CPC_Atoms_Base::SetCharge(void)
{
    m_set_State[0] |= 0x100;
    return m_Charge;
}

inline
bool CPC_Atoms_Base::IsSetRadical(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Atoms_Base::CanGetRadical(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TRadical& CPC_Atoms_Base::GetRadical(void) const
{
    return m_Radical;
}

inline
CPC_Atoms_Base::TRadical& CPC_Atoms_Base::SetRadical(void)
{
    m_set_State[0] |= 0x400;
    return m_Radical;
}

inline
bool CPC_Atoms_Base::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_Atoms_Base::CanGetSource(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TSource& CPC_Atoms_Base::GetSource(void) const
{
    return m_Source;
}

inline
CPC_Atoms_Base::TSource& CPC_Atoms_Base::SetSource(void)
{
    m_set_State[0] |= 0x1000;
    return m_Source;
}

inline
bool CPC_Atoms_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_Atoms_Base::CanGetComment(void) const
{
    return true;
}

inline
const CPC_Atoms_Base::TComment& CPC_Atoms_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CPC_Atoms_Base::TComment& CPC_Atoms_Base::SetComment(void)
{
    m_set_State[0] |= 0x4000;
    return m_Comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_ATOMS_BASE_HPP
