/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_CategorizedComment_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_CATEGORIZEDCOMMENT_BASE_HPP
#define OBJECTS_PCASSAY2_PC_CATEGORIZEDCOMMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Definition for Categorized description/comment
/// This field is added to provide flexibility for depositors to present textual description/comments in a desirable way
/// and to facilitate information validation by the depositor and data exchange with PubChem
class CPC_CategorizedComment_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_CategorizedComment_Base(void);
    // destructor
    virtual ~CPC_CategorizedComment_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CStringUTF8 TTitle;
    typedef list< CStringUTF8 > TComment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// title for the description/comment
    /// mandatory
    /// typedef CStringUTF8 TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// description/comment content
    /// mandatory
    /// typedef list< CStringUTF8 > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_CategorizedComment_Base(const CPC_CategorizedComment_Base&);
    CPC_CategorizedComment_Base& operator=(const CPC_CategorizedComment_Base&);

    // data
    Uint4 m_set_State[1];
    CStringUTF8 m_Title;
    list< CStringUTF8 > m_Comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_CategorizedComment_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_CategorizedComment_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CPC_CategorizedComment_Base::TTitle& CPC_CategorizedComment_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CPC_CategorizedComment_Base::SetTitle(const CPC_CategorizedComment_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CPC_CategorizedComment_Base::SetTitle(CPC_CategorizedComment_Base::TTitle&& value)
{
    m_Title = std::forward<CPC_CategorizedComment_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CPC_CategorizedComment_Base::TTitle& CPC_CategorizedComment_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CPC_CategorizedComment_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_CategorizedComment_Base::CanGetComment(void) const
{
    return true;
}

inline
const CPC_CategorizedComment_Base::TComment& CPC_CategorizedComment_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CPC_CategorizedComment_Base::TComment& CPC_CategorizedComment_Base::SetComment(void)
{
    m_set_State[0] |= 0x4;
    return m_Comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_CATEGORIZEDCOMMENT_BASE_HPP
