/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssaySubmit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_ASSAYSUBMIT_BASE_HPP
#define OBJECTS_PCASSAY_PC_ASSAYSUBMIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_AssayDescription;
class CPC_AssayResults;
class CPC_ID;
class CPC_Source;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Container for Data Depositions and Assay Definitions
class NCBI_PCASSAY_EXPORT CPC_AssaySubmit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssaySubmit_Base(void);
    // destructor
    virtual ~CPC_AssaySubmit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// Assay Description or pre-existing Identifier
    class NCBI_PCASSAY_EXPORT C_Assay : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Assay(void);
        // destructor
        ~C_Assay(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Aid,          ///<   Assay Identifier
            e_Aid_source,   ///<   External Assay Identifier
            e_Descr,        ///<   Assay Description (new or updated)
            e_Aidver        ///<   Assay Identifier/Version (for internal use)
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 5 ///< == e_Aidver+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TAid;
        typedef CPC_Source TAid_source;
        typedef CPC_AssayDescription TDescr;
        typedef CPC_ID TAidver;
    
        // getters
        // setters
    
        // typedef int TAid
        bool IsAid(void) const;
        TAid GetAid(void) const;
        TAid& SetAid(void);
        void SetAid(TAid value);
    
        // typedef CPC_Source TAid_source
        bool IsAid_source(void) const;
        const TAid_source& GetAid_source(void) const;
        TAid_source& SetAid_source(void);
        void SetAid_source(TAid_source& value);
    
        // typedef CPC_AssayDescription TDescr
        bool IsDescr(void) const;
        const TDescr& GetDescr(void) const;
        TDescr& SetDescr(void);
        void SetDescr(TDescr& value);
    
        // typedef CPC_ID TAidver
        bool IsAidver(void) const;
        const TAidver& GetAidver(void) const;
        TAidver& SetAidver(void);
        void SetAidver(TAidver& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Assay(const C_Assay& );
        C_Assay& operator=(const C_Assay& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TAid m_Aid;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Assay TAssay;
    typedef vector< CRef< CPC_AssayResults > > TData;
    typedef vector< int > TRevoke;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_assay,
        e_data,
        e_revoke
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Assay TAssay
    ///  Check whether the Assay data member has been assigned a value.
    bool IsSetAssay(void) const;
    /// Check whether it is safe or not to call GetAssay method.
    bool CanGetAssay(void) const;
    void ResetAssay(void);
    const TAssay& GetAssay(void) const;
    void SetAssay(TAssay& value);
    TAssay& SetAssay(void);

    /// Assay Data Deposition (vector)
    /// optional
    /// typedef vector< CRef< CPC_AssayResults > > TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    TData& SetData(void);

    /// List of SID's whose data is to be suppressed
    /// optional
    /// typedef vector< int > TRevoke
    ///  Check whether the Revoke data member has been assigned a value.
    bool IsSetRevoke(void) const;
    /// Check whether it is safe or not to call GetRevoke method.
    bool CanGetRevoke(void) const;
    void ResetRevoke(void);
    const TRevoke& GetRevoke(void) const;
    TRevoke& SetRevoke(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssaySubmit_Base(const CPC_AssaySubmit_Base&);
    CPC_AssaySubmit_Base& operator=(const CPC_AssaySubmit_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAssay > m_Assay;
    vector< CRef< CPC_AssayResults > > m_Data;
    vector< int > m_Revoke;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_AssaySubmit_Base::C_Assay::E_Choice CPC_AssaySubmit_Base::C_Assay::Which(void) const
{
    return m_choice;
}

inline
void CPC_AssaySubmit_Base::C_Assay::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_AssaySubmit_Base::C_Assay::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_AssaySubmit_Base::C_Assay::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_AssaySubmit_Base::C_Assay::IsAid(void) const
{
    return m_choice == e_Aid;
}

inline
CPC_AssaySubmit_Base::C_Assay::TAid CPC_AssaySubmit_Base::C_Assay::GetAid(void) const
{
    CheckSelected(e_Aid);
    return m_Aid;
}

inline
CPC_AssaySubmit_Base::C_Assay::TAid& CPC_AssaySubmit_Base::C_Assay::SetAid(void)
{
    Select(e_Aid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Aid;
}

inline
void CPC_AssaySubmit_Base::C_Assay::SetAid(CPC_AssaySubmit_Base::C_Assay::TAid value)
{
    Select(e_Aid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Aid = value;
}

inline
bool CPC_AssaySubmit_Base::C_Assay::IsAid_source(void) const
{
    return m_choice == e_Aid_source;
}

inline
bool CPC_AssaySubmit_Base::C_Assay::IsDescr(void) const
{
    return m_choice == e_Descr;
}

inline
bool CPC_AssaySubmit_Base::C_Assay::IsAidver(void) const
{
    return m_choice == e_Aidver;
}

inline
bool CPC_AssaySubmit_Base::IsSetAssay(void) const
{
    return m_Assay.NotEmpty();
}

inline
bool CPC_AssaySubmit_Base::CanGetAssay(void) const
{
    return true;
}

inline
const CPC_AssaySubmit_Base::TAssay& CPC_AssaySubmit_Base::GetAssay(void) const
{
    if ( !m_Assay ) {
        const_cast<CPC_AssaySubmit_Base*>(this)->ResetAssay();
    }
    return (*m_Assay);
}

inline
CPC_AssaySubmit_Base::TAssay& CPC_AssaySubmit_Base::SetAssay(void)
{
    if ( !m_Assay ) {
        ResetAssay();
    }
    return (*m_Assay);
}

inline
bool CPC_AssaySubmit_Base::IsSetData(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AssaySubmit_Base::CanGetData(void) const
{
    return true;
}

inline
const CPC_AssaySubmit_Base::TData& CPC_AssaySubmit_Base::GetData(void) const
{
    return m_Data;
}

inline
CPC_AssaySubmit_Base::TData& CPC_AssaySubmit_Base::SetData(void)
{
    m_set_State[0] |= 0x4;
    return m_Data;
}

inline
bool CPC_AssaySubmit_Base::IsSetRevoke(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_AssaySubmit_Base::CanGetRevoke(void) const
{
    return true;
}

inline
const CPC_AssaySubmit_Base::TRevoke& CPC_AssaySubmit_Base::GetRevoke(void) const
{
    return m_Revoke;
}

inline
CPC_AssaySubmit_Base::TRevoke& CPC_AssaySubmit_Base::SetRevoke(void)
{
    m_set_State[0] |= 0x10;
    return m_Revoke;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_ASSAYSUBMIT_BASE_HPP
