/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayPanel_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_ASSAYPANEL_BASE_HPP
#define OBJECTS_PCASSAY_PC_ASSAYPANEL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_AssayPanelMember;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Description for Panel Assay
/// Describe general information about the panel, and link to information for each panel member 
class NCBI_PCASSAY_EXPORT CPC_AssayPanel_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayPanel_Base(void);
    // destructor
    virtual ~CPC_AssayPanel_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef string TDescr;
    typedef list< CRef< CPC_AssayPanelMember > > TMember;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_descr,
        e_member
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// short name for the panel, such as 'Kinase Profiling'
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// short description of this panel
    /// optional
    /// typedef string TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// store panel member information
    /// optional
    /// typedef list< CRef< CPC_AssayPanelMember > > TMember
    ///  Check whether the Member data member has been assigned a value.
    bool IsSetMember(void) const;
    /// Check whether it is safe or not to call GetMember method.
    bool CanGetMember(void) const;
    void ResetMember(void);
    const TMember& GetMember(void) const;
    TMember& SetMember(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayPanel_Base(const CPC_AssayPanel_Base&);
    CPC_AssayPanel_Base& operator=(const CPC_AssayPanel_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    string m_Descr;
    list< CRef< CPC_AssayPanelMember > > m_Member;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AssayPanel_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayPanel_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPC_AssayPanel_Base::TName& CPC_AssayPanel_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CPC_AssayPanel_Base::SetName(const CPC_AssayPanel_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CPC_AssayPanel_Base::SetName(CPC_AssayPanel_Base::TName&& value)
{
    m_Name = std::forward<CPC_AssayPanel_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayPanel_Base::TName& CPC_AssayPanel_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CPC_AssayPanel_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AssayPanel_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CPC_AssayPanel_Base::TDescr& CPC_AssayPanel_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(1);
    }
    return m_Descr;
}

inline
void CPC_AssayPanel_Base::SetDescr(const CPC_AssayPanel_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0xc;
}

inline
void CPC_AssayPanel_Base::SetDescr(CPC_AssayPanel_Base::TDescr&& value)
{
    m_Descr = std::forward<CPC_AssayPanel_Base::TDescr>(value);
    m_set_State[0] |= 0xc;
}

inline
CPC_AssayPanel_Base::TDescr& CPC_AssayPanel_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CPC_AssayPanel_Base::IsSetMember(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_AssayPanel_Base::CanGetMember(void) const
{
    return true;
}

inline
const CPC_AssayPanel_Base::TMember& CPC_AssayPanel_Base::GetMember(void) const
{
    return m_Member;
}

inline
CPC_AssayPanel_Base::TMember& CPC_AssayPanel_Base::SetMember(void)
{
    m_set_State[0] |= 0x10;
    return m_Member;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_ASSAYPANEL_BASE_HPP
