/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSPepHit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSPEPHIT_BASE_HPP
#define OBJECTS_OMSSA_MSPEPHIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// contains information about sequences with identical peptide
/// sequences
class NCBI_OMSSA_EXPORT CMSPepHit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSPepHit_Base(void);
    // destructor
    virtual ~CMSPepHit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TStart;
    typedef int TStop;
    typedef NCBI_NS_NCBI::TGi TGi;
    typedef string TAccession;
    typedef string TDefline;
    typedef int TProtlength;
    typedef int TOid;
    typedef bool TReversed;
    typedef string TPepstart;
    typedef string TPepstop;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_start,
        e_stop,
        e_gi,
        e_accession,
        e_defline,
        e_protlength,
        e_oid,
        e_reversed,
        e_pepstart,
        e_pepstop
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// start position (inclusive) in sequence
    /// mandatory
    /// typedef int TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    TStart GetStart(void) const;
    void SetStart(TStart value);
    TStart& SetStart(void);

    /// stop position (inclusive) in sequence
    /// mandatory
    /// typedef int TStop
    ///  Check whether the Stop data member has been assigned a value.
    bool IsSetStop(void) const;
    /// Check whether it is safe or not to call GetStop method.
    bool CanGetStop(void) const;
    void ResetStop(void);
    TStop GetStop(void) const;
    void SetStop(TStop value);
    TStop& SetStop(void);

    /// genbank identifier
    /// optional
    /// typedef NCBI_NS_NCBI::TGi TGi
    ///  Check whether the Gi data member has been assigned a value.
    bool IsSetGi(void) const;
    /// Check whether it is safe or not to call GetGi method.
    bool CanGetGi(void) const;
    void ResetGi(void);
    TGi GetGi(void) const;
    void SetGi(TGi value);
    TGi& SetGi(void);

    /// sequence accession
    /// optional
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// sequence description
    /// optional
    /// typedef string TDefline
    ///  Check whether the Defline data member has been assigned a value.
    bool IsSetDefline(void) const;
    /// Check whether it is safe or not to call GetDefline method.
    bool CanGetDefline(void) const;
    void ResetDefline(void);
    const TDefline& GetDefline(void) const;
    void SetDefline(const TDefline& value);
    void SetDefline(TDefline&& value);
    TDefline& SetDefline(void);

    /// length of protein
    /// optional
    /// typedef int TProtlength
    ///  Check whether the Protlength data member has been assigned a value.
    bool IsSetProtlength(void) const;
    /// Check whether it is safe or not to call GetProtlength method.
    bool CanGetProtlength(void) const;
    void ResetProtlength(void);
    TProtlength GetProtlength(void) const;
    void SetProtlength(TProtlength value);
    TProtlength& SetProtlength(void);

    /// blast library oid 
    /// optional
    /// typedef int TOid
    ///  Check whether the Oid data member has been assigned a value.
    bool IsSetOid(void) const;
    /// Check whether it is safe or not to call GetOid method.
    bool CanGetOid(void) const;
    void ResetOid(void);
    TOid GetOid(void) const;
    void SetOid(TOid value);
    TOid& SetOid(void);

    /// reversed sequence
    /// optional
    /// typedef bool TReversed
    ///  Check whether the Reversed data member has been assigned a value.
    bool IsSetReversed(void) const;
    /// Check whether it is safe or not to call GetReversed method.
    bool CanGetReversed(void) const;
    void ResetReversed(void);
    TReversed GetReversed(void) const;
    void SetReversed(TReversed value);
    TReversed& SetReversed(void);

    /// AA before the peptide
    /// optional
    /// typedef string TPepstart
    ///  Check whether the Pepstart data member has been assigned a value.
    bool IsSetPepstart(void) const;
    /// Check whether it is safe or not to call GetPepstart method.
    bool CanGetPepstart(void) const;
    void ResetPepstart(void);
    const TPepstart& GetPepstart(void) const;
    void SetPepstart(const TPepstart& value);
    void SetPepstart(TPepstart&& value);
    TPepstart& SetPepstart(void);

    /// AA after the peptide
    /// optional
    /// typedef string TPepstop
    ///  Check whether the Pepstop data member has been assigned a value.
    bool IsSetPepstop(void) const;
    /// Check whether it is safe or not to call GetPepstop method.
    bool CanGetPepstop(void) const;
    void ResetPepstop(void);
    const TPepstop& GetPepstop(void) const;
    void SetPepstop(const TPepstop& value);
    void SetPepstop(TPepstop&& value);
    TPepstop& SetPepstop(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSPepHit_Base(const CMSPepHit_Base&);
    CMSPepHit_Base& operator=(const CMSPepHit_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Start;
    int m_Stop;
    ncbi::TIntId m_Gi;
    string m_Accession;
    string m_Defline;
    int m_Protlength;
    int m_Oid;
    bool m_Reversed;
    string m_Pepstart;
    string m_Pepstop;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSPepHit_Base::IsSetStart(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSPepHit_Base::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CMSPepHit_Base::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSPepHit_Base::TStart CMSPepHit_Base::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(0);
    }
    return m_Start;
}

inline
void CMSPepHit_Base::SetStart(CMSPepHit_Base::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0x3;
}

inline
CMSPepHit_Base::TStart& CMSPepHit_Base::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Start;
}

inline
bool CMSPepHit_Base::IsSetStop(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSPepHit_Base::CanGetStop(void) const
{
    return IsSetStop();
}

inline
void CMSPepHit_Base::ResetStop(void)
{
    m_Stop = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMSPepHit_Base::TStop CMSPepHit_Base::GetStop(void) const
{
    if (!CanGetStop()) {
        ThrowUnassigned(1);
    }
    return m_Stop;
}

inline
void CMSPepHit_Base::SetStop(CMSPepHit_Base::TStop value)
{
    m_Stop = value;
    m_set_State[0] |= 0xc;
}

inline
CMSPepHit_Base::TStop& CMSPepHit_Base::SetStop(void)
{
#ifdef _DEBUG
    if (!IsSetStop()) {
        memset(&m_Stop,UnassignedByte(),sizeof(m_Stop));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Stop;
}

inline
bool CMSPepHit_Base::IsSetGi(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSPepHit_Base::CanGetGi(void) const
{
    return IsSetGi();
}

inline
void CMSPepHit_Base::ResetGi(void)
{
    m_Gi = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSPepHit_Base::TGi CMSPepHit_Base::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(2);
    }
    return reinterpret_cast<const TGi&>(m_Gi);
}

inline
void CMSPepHit_Base::SetGi(CMSPepHit_Base::TGi value)
{
    reinterpret_cast<TGi&>(m_Gi) = value;
    m_set_State[0] |= 0x30;
}

inline
CMSPepHit_Base::TGi& CMSPepHit_Base::SetGi(void)
{
#ifdef _DEBUG
    if (!IsSetGi()) {
        memset(&m_Gi,UnassignedByte(),sizeof(m_Gi));
    }
#endif
    m_set_State[0] |= 0x10;
    return reinterpret_cast<TGi&>(m_Gi);
}

inline
bool CMSPepHit_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSPepHit_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CMSPepHit_Base::TAccession& CMSPepHit_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(3);
    }
    return m_Accession;
}

inline
void CMSPepHit_Base::SetAccession(const CMSPepHit_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMSPepHit_Base::SetAccession(CMSPepHit_Base::TAccession&& value)
{
    m_Accession = std::forward<CMSPepHit_Base::TAccession>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMSPepHit_Base::TAccession& CMSPepHit_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Accession;
}

inline
bool CMSPepHit_Base::IsSetDefline(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSPepHit_Base::CanGetDefline(void) const
{
    return IsSetDefline();
}

inline
const CMSPepHit_Base::TDefline& CMSPepHit_Base::GetDefline(void) const
{
    if (!CanGetDefline()) {
        ThrowUnassigned(4);
    }
    return m_Defline;
}

inline
void CMSPepHit_Base::SetDefline(const CMSPepHit_Base::TDefline& value)
{
    m_Defline = value;
    m_set_State[0] |= 0x300;
}

inline
void CMSPepHit_Base::SetDefline(CMSPepHit_Base::TDefline&& value)
{
    m_Defline = std::forward<CMSPepHit_Base::TDefline>(value);
    m_set_State[0] |= 0x300;
}

inline
CMSPepHit_Base::TDefline& CMSPepHit_Base::SetDefline(void)
{
#ifdef _DEBUG
    if (!IsSetDefline()) {
        m_Defline = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Defline;
}

inline
bool CMSPepHit_Base::IsSetProtlength(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSPepHit_Base::CanGetProtlength(void) const
{
    return IsSetProtlength();
}

inline
void CMSPepHit_Base::ResetProtlength(void)
{
    m_Protlength = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMSPepHit_Base::TProtlength CMSPepHit_Base::GetProtlength(void) const
{
    if (!CanGetProtlength()) {
        ThrowUnassigned(5);
    }
    return m_Protlength;
}

inline
void CMSPepHit_Base::SetProtlength(CMSPepHit_Base::TProtlength value)
{
    m_Protlength = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSPepHit_Base::TProtlength& CMSPepHit_Base::SetProtlength(void)
{
#ifdef _DEBUG
    if (!IsSetProtlength()) {
        memset(&m_Protlength,UnassignedByte(),sizeof(m_Protlength));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Protlength;
}

inline
bool CMSPepHit_Base::IsSetOid(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSPepHit_Base::CanGetOid(void) const
{
    return IsSetOid();
}

inline
void CMSPepHit_Base::ResetOid(void)
{
    m_Oid = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CMSPepHit_Base::TOid CMSPepHit_Base::GetOid(void) const
{
    if (!CanGetOid()) {
        ThrowUnassigned(6);
    }
    return m_Oid;
}

inline
void CMSPepHit_Base::SetOid(CMSPepHit_Base::TOid value)
{
    m_Oid = value;
    m_set_State[0] |= 0x3000;
}

inline
CMSPepHit_Base::TOid& CMSPepHit_Base::SetOid(void)
{
#ifdef _DEBUG
    if (!IsSetOid()) {
        memset(&m_Oid,UnassignedByte(),sizeof(m_Oid));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Oid;
}

inline
bool CMSPepHit_Base::IsSetReversed(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMSPepHit_Base::CanGetReversed(void) const
{
    return IsSetReversed();
}

inline
void CMSPepHit_Base::ResetReversed(void)
{
    m_Reversed = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CMSPepHit_Base::TReversed CMSPepHit_Base::GetReversed(void) const
{
    if (!CanGetReversed()) {
        ThrowUnassigned(7);
    }
    return m_Reversed;
}

inline
void CMSPepHit_Base::SetReversed(CMSPepHit_Base::TReversed value)
{
    m_Reversed = value;
    m_set_State[0] |= 0xc000;
}

inline
CMSPepHit_Base::TReversed& CMSPepHit_Base::SetReversed(void)
{
#ifdef _DEBUG
    if (!IsSetReversed()) {
        memset(&m_Reversed,UnassignedByte(),sizeof(m_Reversed));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Reversed;
}

inline
bool CMSPepHit_Base::IsSetPepstart(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMSPepHit_Base::CanGetPepstart(void) const
{
    return IsSetPepstart();
}

inline
const CMSPepHit_Base::TPepstart& CMSPepHit_Base::GetPepstart(void) const
{
    if (!CanGetPepstart()) {
        ThrowUnassigned(8);
    }
    return m_Pepstart;
}

inline
void CMSPepHit_Base::SetPepstart(const CMSPepHit_Base::TPepstart& value)
{
    m_Pepstart = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMSPepHit_Base::SetPepstart(CMSPepHit_Base::TPepstart&& value)
{
    m_Pepstart = std::forward<CMSPepHit_Base::TPepstart>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMSPepHit_Base::TPepstart& CMSPepHit_Base::SetPepstart(void)
{
#ifdef _DEBUG
    if (!IsSetPepstart()) {
        m_Pepstart = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Pepstart;
}

inline
bool CMSPepHit_Base::IsSetPepstop(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMSPepHit_Base::CanGetPepstop(void) const
{
    return IsSetPepstop();
}

inline
const CMSPepHit_Base::TPepstop& CMSPepHit_Base::GetPepstop(void) const
{
    if (!CanGetPepstop()) {
        ThrowUnassigned(9);
    }
    return m_Pepstop;
}

inline
void CMSPepHit_Base::SetPepstop(const CMSPepHit_Base::TPepstop& value)
{
    m_Pepstop = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMSPepHit_Base::SetPepstop(CMSPepHit_Base::TPepstop&& value)
{
    m_Pepstop = std::forward<CMSPepHit_Base::TPepstop>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMSPepHit_Base::TPepstop& CMSPepHit_Base::SetPepstop(void)
{
#ifdef _DEBUG
    if (!IsSetPepstop()) {
        m_Pepstop = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Pepstop;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSPEPHIT_BASE_HPP
