/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSOutFile_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSOUTFILE_BASE_HPP
#define OBJECTS_OMSSA_MSOUTFILE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/omssa/MSSerialDataFormat.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_OMSSA_EXPORT CMSOutFile_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSOutFile_Base(void);
    // destructor
    virtual ~CMSOutFile_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TOutfile;
    typedef int TOutfiletype;
    typedef bool TIncluderequest;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_outfile,
        e_outfiletype,
        e_includerequest
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// output file name
    /// mandatory
    /// typedef string TOutfile
    ///  Check whether the Outfile data member has been assigned a value.
    bool IsSetOutfile(void) const;
    /// Check whether it is safe or not to call GetOutfile method.
    bool CanGetOutfile(void) const;
    void ResetOutfile(void);
    const TOutfile& GetOutfile(void) const;
    void SetOutfile(const TOutfile& value);
    void SetOutfile(TOutfile&& value);
    TOutfile& SetOutfile(void);

    /// output file type
    /// mandatory
    /// typedef int TOutfiletype
    ///  Check whether the Outfiletype data member has been assigned a value.
    bool IsSetOutfiletype(void) const;
    /// Check whether it is safe or not to call GetOutfiletype method.
    bool CanGetOutfiletype(void) const;
    void ResetOutfiletype(void);
    TOutfiletype GetOutfiletype(void) const;
    void SetOutfiletype(TOutfiletype value);
    TOutfiletype& SetOutfiletype(void);

    /// should the output include the request?
    /// mandatory
    /// typedef bool TIncluderequest
    ///  Check whether the Includerequest data member has been assigned a value.
    bool IsSetIncluderequest(void) const;
    /// Check whether it is safe or not to call GetIncluderequest method.
    bool CanGetIncluderequest(void) const;
    void ResetIncluderequest(void);
    TIncluderequest GetIncluderequest(void) const;
    void SetIncluderequest(TIncluderequest value);
    TIncluderequest& SetIncluderequest(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSOutFile_Base(const CMSOutFile_Base&);
    CMSOutFile_Base& operator=(const CMSOutFile_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Outfile;
    int m_Outfiletype;
    bool m_Includerequest;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSOutFile_Base::IsSetOutfile(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSOutFile_Base::CanGetOutfile(void) const
{
    return IsSetOutfile();
}

inline
const CMSOutFile_Base::TOutfile& CMSOutFile_Base::GetOutfile(void) const
{
    if (!CanGetOutfile()) {
        ThrowUnassigned(0);
    }
    return m_Outfile;
}

inline
void CMSOutFile_Base::SetOutfile(const CMSOutFile_Base::TOutfile& value)
{
    m_Outfile = value;
    m_set_State[0] |= 0x3;
}

inline
void CMSOutFile_Base::SetOutfile(CMSOutFile_Base::TOutfile&& value)
{
    m_Outfile = std::forward<CMSOutFile_Base::TOutfile>(value);
    m_set_State[0] |= 0x3;
}

inline
CMSOutFile_Base::TOutfile& CMSOutFile_Base::SetOutfile(void)
{
#ifdef _DEBUG
    if (!IsSetOutfile()) {
        m_Outfile = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Outfile;
}

inline
bool CMSOutFile_Base::IsSetOutfiletype(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSOutFile_Base::CanGetOutfiletype(void) const
{
    return IsSetOutfiletype();
}

inline
void CMSOutFile_Base::ResetOutfiletype(void)
{
    m_Outfiletype = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSOutFile_Base::TOutfiletype CMSOutFile_Base::GetOutfiletype(void) const
{
    if (!CanGetOutfiletype()) {
        ThrowUnassigned(1);
    }
    return m_Outfiletype;
}

inline
void CMSOutFile_Base::SetOutfiletype(CMSOutFile_Base::TOutfiletype value)
{
    m_Outfiletype = value;
    m_set_State[0] |= 0xc;
}

inline
CMSOutFile_Base::TOutfiletype& CMSOutFile_Base::SetOutfiletype(void)
{
#ifdef _DEBUG
    if (!IsSetOutfiletype()) {
        memset(&m_Outfiletype,UnassignedByte(),sizeof(m_Outfiletype));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Outfiletype;
}

inline
bool CMSOutFile_Base::IsSetIncluderequest(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSOutFile_Base::CanGetIncluderequest(void) const
{
    return IsSetIncluderequest();
}

inline
void CMSOutFile_Base::ResetIncluderequest(void)
{
    m_Includerequest = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSOutFile_Base::TIncluderequest CMSOutFile_Base::GetIncluderequest(void) const
{
    if (!CanGetIncluderequest()) {
        ThrowUnassigned(2);
    }
    return m_Includerequest;
}

inline
void CMSOutFile_Base::SetIncluderequest(CMSOutFile_Base::TIncluderequest value)
{
    m_Includerequest = value;
    m_set_State[0] |= 0x30;
}

inline
CMSOutFile_Base::TIncluderequest& CMSOutFile_Base::SetIncluderequest(void)
{
#ifdef _DEBUG
    if (!IsSetIncluderequest()) {
        memset(&m_Includerequest,UnassignedByte(),sizeof(m_Includerequest));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Includerequest;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSOUTFILE_BASE_HPP
