/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSHitSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSHITSET_BASE_HPP
#define OBJECTS_OMSSA_MSHITSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>
#include <objects/omssa/MSHitError.hpp>
#include <objects/omssa/MSUserAnnot.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSHits;
class CNameValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// contains a set of hits to a single spectrum
class NCBI_OMSSA_EXPORT CMSHitSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSHitSet_Base(void);
    // destructor
    virtual ~CMSHitSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNumber;
    typedef int TError;
    typedef vector< CRef< CMSHits > > THits;
    typedef list< string > TIds;
    typedef list< CRef< CNameValue > > TNamevalue;
    typedef int TSettingid;
    typedef int TUserannotation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number,
        e_error,
        e_hits,
        e_ids,
        e_namevalue,
        e_settingid,
        e_userannotation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// unique number of spectrum
    /// mandatory
    /// typedef int TNumber
    ///  Check whether the Number data member has been assigned a value.
    bool IsSetNumber(void) const;
    /// Check whether it is safe or not to call GetNumber method.
    bool CanGetNumber(void) const;
    void ResetNumber(void);
    TNumber GetNumber(void) const;
    void SetNumber(TNumber value);
    TNumber& SetNumber(void);

    /// error, if any
    /// optional
    /// typedef int TError
    ///  Check whether the Error data member has been assigned a value.
    bool IsSetError(void) const;
    /// Check whether it is safe or not to call GetError method.
    bool CanGetError(void) const;
    void ResetError(void);
    TError GetError(void) const;
    void SetError(TError value);
    TError& SetError(void);

    /// set of hit to spectrum
    /// optional
    /// typedef vector< CRef< CMSHits > > THits
    ///  Check whether the Hits data member has been assigned a value.
    bool IsSetHits(void) const;
    /// Check whether it is safe or not to call GetHits method.
    bool CanGetHits(void) const;
    void ResetHits(void);
    const THits& GetHits(void) const;
    THits& SetHits(void);

    /// filenames or other ids of spectra searched
    /// optional
    /// typedef list< string > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// extra info: retention times, etc.
    /// optional
    /// typedef list< CRef< CNameValue > > TNamevalue
    ///  Check whether the Namevalue data member has been assigned a value.
    bool IsSetNamevalue(void) const;
    /// Check whether it is safe or not to call GetNamevalue method.
    bool CanGetNamevalue(void) const;
    void ResetNamevalue(void);
    const TNamevalue& GetNamevalue(void) const;
    TNamevalue& SetNamevalue(void);

    /// id of the search setting used
    /// optional
    /// typedef int TSettingid
    ///  Check whether the Settingid data member has been assigned a value.
    bool IsSetSettingid(void) const;
    /// Check whether it is safe or not to call GetSettingid method.
    bool CanGetSettingid(void) const;
    void ResetSettingid(void);
    TSettingid GetSettingid(void) const;
    void SetSettingid(TSettingid value);
    TSettingid& SetSettingid(void);

    /// allows users to flag certain
    /// optional
    /// typedef int TUserannotation
    ///  Check whether the Userannotation data member has been assigned a value.
    bool IsSetUserannotation(void) const;
    /// Check whether it is safe or not to call GetUserannotation method.
    bool CanGetUserannotation(void) const;
    void ResetUserannotation(void);
    TUserannotation GetUserannotation(void) const;
    void SetUserannotation(TUserannotation value);
    TUserannotation& SetUserannotation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSHitSet_Base(const CMSHitSet_Base&);
    CMSHitSet_Base& operator=(const CMSHitSet_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Number;
    int m_Error;
    vector< CRef< CMSHits > > m_Hits;
    list< string > m_Ids;
    list< CRef< CNameValue > > m_Namevalue;
    int m_Settingid;
    int m_Userannotation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSHitSet_Base::IsSetNumber(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSHitSet_Base::CanGetNumber(void) const
{
    return IsSetNumber();
}

inline
void CMSHitSet_Base::ResetNumber(void)
{
    m_Number = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSHitSet_Base::TNumber CMSHitSet_Base::GetNumber(void) const
{
    if (!CanGetNumber()) {
        ThrowUnassigned(0);
    }
    return m_Number;
}

inline
void CMSHitSet_Base::SetNumber(CMSHitSet_Base::TNumber value)
{
    m_Number = value;
    m_set_State[0] |= 0x3;
}

inline
CMSHitSet_Base::TNumber& CMSHitSet_Base::SetNumber(void)
{
#ifdef _DEBUG
    if (!IsSetNumber()) {
        memset(&m_Number,UnassignedByte(),sizeof(m_Number));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number;
}

inline
bool CMSHitSet_Base::IsSetError(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSHitSet_Base::CanGetError(void) const
{
    return IsSetError();
}

inline
void CMSHitSet_Base::ResetError(void)
{
    m_Error = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSHitSet_Base::TError CMSHitSet_Base::GetError(void) const
{
    if (!CanGetError()) {
        ThrowUnassigned(1);
    }
    return m_Error;
}

inline
void CMSHitSet_Base::SetError(CMSHitSet_Base::TError value)
{
    m_Error = value;
    m_set_State[0] |= 0xc;
}

inline
CMSHitSet_Base::TError& CMSHitSet_Base::SetError(void)
{
#ifdef _DEBUG
    if (!IsSetError()) {
        memset(&m_Error,UnassignedByte(),sizeof(m_Error));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Error;
}

inline
bool CMSHitSet_Base::IsSetHits(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSHitSet_Base::CanGetHits(void) const
{
    return true;
}

inline
const CMSHitSet_Base::THits& CMSHitSet_Base::GetHits(void) const
{
    return m_Hits;
}

inline
CMSHitSet_Base::THits& CMSHitSet_Base::SetHits(void)
{
    m_set_State[0] |= 0x10;
    return m_Hits;
}

inline
bool CMSHitSet_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSHitSet_Base::CanGetIds(void) const
{
    return true;
}

inline
const CMSHitSet_Base::TIds& CMSHitSet_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CMSHitSet_Base::TIds& CMSHitSet_Base::SetIds(void)
{
    m_set_State[0] |= 0x40;
    return m_Ids;
}

inline
bool CMSHitSet_Base::IsSetNamevalue(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSHitSet_Base::CanGetNamevalue(void) const
{
    return true;
}

inline
const CMSHitSet_Base::TNamevalue& CMSHitSet_Base::GetNamevalue(void) const
{
    return m_Namevalue;
}

inline
CMSHitSet_Base::TNamevalue& CMSHitSet_Base::SetNamevalue(void)
{
    m_set_State[0] |= 0x100;
    return m_Namevalue;
}

inline
bool CMSHitSet_Base::IsSetSettingid(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSHitSet_Base::CanGetSettingid(void) const
{
    return IsSetSettingid();
}

inline
void CMSHitSet_Base::ResetSettingid(void)
{
    m_Settingid = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMSHitSet_Base::TSettingid CMSHitSet_Base::GetSettingid(void) const
{
    if (!CanGetSettingid()) {
        ThrowUnassigned(5);
    }
    return m_Settingid;
}

inline
void CMSHitSet_Base::SetSettingid(CMSHitSet_Base::TSettingid value)
{
    m_Settingid = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSHitSet_Base::TSettingid& CMSHitSet_Base::SetSettingid(void)
{
#ifdef _DEBUG
    if (!IsSetSettingid()) {
        memset(&m_Settingid,UnassignedByte(),sizeof(m_Settingid));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Settingid;
}

inline
bool CMSHitSet_Base::IsSetUserannotation(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSHitSet_Base::CanGetUserannotation(void) const
{
    return IsSetUserannotation();
}

inline
void CMSHitSet_Base::ResetUserannotation(void)
{
    m_Userannotation = (int)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CMSHitSet_Base::TUserannotation CMSHitSet_Base::GetUserannotation(void) const
{
    if (!CanGetUserannotation()) {
        ThrowUnassigned(6);
    }
    return m_Userannotation;
}

inline
void CMSHitSet_Base::SetUserannotation(CMSHitSet_Base::TUserannotation value)
{
    m_Userannotation = value;
    m_set_State[0] |= 0x3000;
}

inline
CMSHitSet_Base::TUserannotation& CMSHitSet_Base::SetUserannotation(void)
{
#ifdef _DEBUG
    if (!IsSetUserannotation()) {
        memset(&m_Userannotation,UnassignedByte(),sizeof(m_Userannotation));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Userannotation;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSHITSET_BASE_HPP
