/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Region_similarity_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_REGION_SIMILARITY_BASE_HPP
#define OBJECTS_MMDB3_REGION_SIMILARITY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_id;
class CRegion_pntrs;
class CTransform;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A biostruc similarity describes spatial features which are similar between
/// two or more biostrucs.  Similarities are model dependent, and the model and
/// coordinate set ids of the biostrucs must be specified.  They do not 
/// necessarily map to a sequence alignment, as the regions referenced may
/// be pieces of a surface or grid, and thus not uniquely mapable to particular
/// chemical components.
class NCBI_MMDB3_EXPORT CRegion_similarity_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRegion_similarity_Base(void);
    // destructor
    virtual ~CRegion_similarity_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TDimension;
    typedef list< CRef< CBiostruc_id > > TBiostruc_ids;
    typedef list< CRef< CRegion_pntrs > > TSimilarity;
    typedef list< CRef< CTransform > > TTransform;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dimension,
        e_biostruc_ids,
        e_similarity,
        e_transform
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional with default 2
    /// typedef int TDimension
    ///  Check whether the Dimension data member has been assigned a value.
    bool IsSetDimension(void) const;
    /// Check whether it is safe or not to call GetDimension method.
    bool CanGetDimension(void) const;
    void ResetDimension(void);
    void SetDefaultDimension(void);
    TDimension GetDimension(void) const;
    void SetDimension(TDimension value);
    TDimension& SetDimension(void);

    /// mandatory
    /// typedef list< CRef< CBiostruc_id > > TBiostruc_ids
    ///  Check whether the Biostruc_ids data member has been assigned a value.
    bool IsSetBiostruc_ids(void) const;
    /// Check whether it is safe or not to call GetBiostruc_ids method.
    bool CanGetBiostruc_ids(void) const;
    void ResetBiostruc_ids(void);
    const TBiostruc_ids& GetBiostruc_ids(void) const;
    TBiostruc_ids& SetBiostruc_ids(void);

    /// mandatory
    /// typedef list< CRef< CRegion_pntrs > > TSimilarity
    ///  Check whether the Similarity data member has been assigned a value.
    bool IsSetSimilarity(void) const;
    /// Check whether it is safe or not to call GetSimilarity method.
    bool CanGetSimilarity(void) const;
    void ResetSimilarity(void);
    const TSimilarity& GetSimilarity(void) const;
    TSimilarity& SetSimilarity(void);

    /// mandatory
    /// typedef list< CRef< CTransform > > TTransform
    ///  Check whether the Transform data member has been assigned a value.
    bool IsSetTransform(void) const;
    /// Check whether it is safe or not to call GetTransform method.
    bool CanGetTransform(void) const;
    void ResetTransform(void);
    const TTransform& GetTransform(void) const;
    TTransform& SetTransform(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRegion_similarity_Base(const CRegion_similarity_Base&);
    CRegion_similarity_Base& operator=(const CRegion_similarity_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Dimension;
    list< CRef< CBiostruc_id > > m_Biostruc_ids;
    list< CRef< CRegion_pntrs > > m_Similarity;
    list< CRef< CTransform > > m_Transform;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRegion_similarity_Base::IsSetDimension(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRegion_similarity_Base::CanGetDimension(void) const
{
    return true;
}

inline
void CRegion_similarity_Base::ResetDimension(void)
{
    m_Dimension = 2;
    m_set_State[0] &= ~0x3;
}

inline
void CRegion_similarity_Base::SetDefaultDimension(void)
{
    ResetDimension();
}

inline
CRegion_similarity_Base::TDimension CRegion_similarity_Base::GetDimension(void) const
{
    return m_Dimension;
}

inline
void CRegion_similarity_Base::SetDimension(CRegion_similarity_Base::TDimension value)
{
    m_Dimension = value;
    m_set_State[0] |= 0x3;
}

inline
CRegion_similarity_Base::TDimension& CRegion_similarity_Base::SetDimension(void)
{
#ifdef _DEBUG
    if (!IsSetDimension()) {
        memset(&m_Dimension,UnassignedByte(),sizeof(m_Dimension));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Dimension;
}

inline
bool CRegion_similarity_Base::IsSetBiostruc_ids(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRegion_similarity_Base::CanGetBiostruc_ids(void) const
{
    return true;
}

inline
const CRegion_similarity_Base::TBiostruc_ids& CRegion_similarity_Base::GetBiostruc_ids(void) const
{
    return m_Biostruc_ids;
}

inline
CRegion_similarity_Base::TBiostruc_ids& CRegion_similarity_Base::SetBiostruc_ids(void)
{
    m_set_State[0] |= 0x4;
    return m_Biostruc_ids;
}

inline
bool CRegion_similarity_Base::IsSetSimilarity(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRegion_similarity_Base::CanGetSimilarity(void) const
{
    return true;
}

inline
const CRegion_similarity_Base::TSimilarity& CRegion_similarity_Base::GetSimilarity(void) const
{
    return m_Similarity;
}

inline
CRegion_similarity_Base::TSimilarity& CRegion_similarity_Base::SetSimilarity(void)
{
    m_set_State[0] |= 0x10;
    return m_Similarity;
}

inline
bool CRegion_similarity_Base::IsSetTransform(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRegion_similarity_Base::CanGetTransform(void) const
{
    return true;
}

inline
const CRegion_similarity_Base::TTransform& CRegion_similarity_Base::GetTransform(void) const
{
    return m_Transform;
}

inline
CRegion_similarity_Base::TTransform& CRegion_similarity_Base::SetTransform(void)
{
    m_set_State[0] |= 0x40;
    return m_Transform;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_REGION_SIMILARITY_BASE_HPP
