/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Color_prop_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_COLOR_PROP_BASE_HPP
#define OBJECTS_MMDB3_COLOR_PROP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CColor_prop_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CColor_prop_Base(void);
    // destructor
    virtual ~CColor_prop_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TR;
    typedef int TG;
    typedef int TB;
    typedef string TName;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_r,
        e_g,
        e_b,
        e_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TR
    ///  Check whether the R data member has been assigned a value.
    bool IsSetR(void) const;
    /// Check whether it is safe or not to call GetR method.
    bool CanGetR(void) const;
    void ResetR(void);
    TR GetR(void) const;
    void SetR(TR value);
    TR& SetR(void);

    /// optional
    /// typedef int TG
    ///  Check whether the G data member has been assigned a value.
    bool IsSetG(void) const;
    /// Check whether it is safe or not to call GetG method.
    bool CanGetG(void) const;
    void ResetG(void);
    TG GetG(void) const;
    void SetG(TG value);
    TG& SetG(void);

    /// optional
    /// typedef int TB
    ///  Check whether the B data member has been assigned a value.
    bool IsSetB(void) const;
    /// Check whether it is safe or not to call GetB method.
    bool CanGetB(void) const;
    void ResetB(void);
    TB GetB(void) const;
    void SetB(TB value);
    TB& SetB(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CColor_prop_Base(const CColor_prop_Base&);
    CColor_prop_Base& operator=(const CColor_prop_Base&);

    // data
    Uint4 m_set_State[1];
    int m_R;
    int m_G;
    int m_B;
    string m_Name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CColor_prop_Base::IsSetR(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CColor_prop_Base::CanGetR(void) const
{
    return IsSetR();
}

inline
void CColor_prop_Base::ResetR(void)
{
    m_R = 0;
    m_set_State[0] &= ~0x3;
}

inline
CColor_prop_Base::TR CColor_prop_Base::GetR(void) const
{
    if (!CanGetR()) {
        ThrowUnassigned(0);
    }
    return m_R;
}

inline
void CColor_prop_Base::SetR(CColor_prop_Base::TR value)
{
    m_R = value;
    m_set_State[0] |= 0x3;
}

inline
CColor_prop_Base::TR& CColor_prop_Base::SetR(void)
{
#ifdef _DEBUG
    if (!IsSetR()) {
        memset(&m_R,UnassignedByte(),sizeof(m_R));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_R;
}

inline
bool CColor_prop_Base::IsSetG(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CColor_prop_Base::CanGetG(void) const
{
    return IsSetG();
}

inline
void CColor_prop_Base::ResetG(void)
{
    m_G = 0;
    m_set_State[0] &= ~0xc;
}

inline
CColor_prop_Base::TG CColor_prop_Base::GetG(void) const
{
    if (!CanGetG()) {
        ThrowUnassigned(1);
    }
    return m_G;
}

inline
void CColor_prop_Base::SetG(CColor_prop_Base::TG value)
{
    m_G = value;
    m_set_State[0] |= 0xc;
}

inline
CColor_prop_Base::TG& CColor_prop_Base::SetG(void)
{
#ifdef _DEBUG
    if (!IsSetG()) {
        memset(&m_G,UnassignedByte(),sizeof(m_G));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_G;
}

inline
bool CColor_prop_Base::IsSetB(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CColor_prop_Base::CanGetB(void) const
{
    return IsSetB();
}

inline
void CColor_prop_Base::ResetB(void)
{
    m_B = 0;
    m_set_State[0] &= ~0x30;
}

inline
CColor_prop_Base::TB CColor_prop_Base::GetB(void) const
{
    if (!CanGetB()) {
        ThrowUnassigned(2);
    }
    return m_B;
}

inline
void CColor_prop_Base::SetB(CColor_prop_Base::TB value)
{
    m_B = value;
    m_set_State[0] |= 0x30;
}

inline
CColor_prop_Base::TB& CColor_prop_Base::SetB(void)
{
#ifdef _DEBUG
    if (!IsSetB()) {
        memset(&m_B,UnassignedByte(),sizeof(m_B));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_B;
}

inline
bool CColor_prop_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CColor_prop_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CColor_prop_Base::TName& CColor_prop_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(3);
    }
    return m_Name;
}

inline
void CColor_prop_Base::SetName(const CColor_prop_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc0;
}

inline
void CColor_prop_Base::SetName(CColor_prop_Base::TName&& value)
{
    m_Name = std::forward<CColor_prop_Base::TName>(value);
    m_set_State[0] |= 0xc0;
}

inline
CColor_prop_Base::TName& CColor_prop_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_COLOR_PROP_BASE_HPP
