/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Model_space_points_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_MODEL_SPACE_POINTS_BASE_HPP
#define OBJECTS_MMDB2_MODEL_SPACE_POINTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// The atoms whose location is described by each coordinate are identified
/// via a hierarchical pointer to the chemical graph of the biomolecular
/// assembly.  Coordinates may be matched with atoms in the chemical structure
/// by the values of the molecule, residue and atom id's given here,  which 
/// match exactly the items of the same type defined in Biostruc-graph.
/// Coordinates are given as integer values, with a scale factor to convert 
/// to real values for each x, y or z, in the units indicated in model-space.
/// Integer values must be divided by the the scale factor.  This use of integer
/// values reduces the ASN.1 stream size. The scale factors for temperature 
/// factors and occupancies are given separately, but must be used in the same 
/// fashion to produce properly scaled real values.
class NCBI_MMDB2_EXPORT CModel_space_points_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CModel_space_points_Base(void);
    // destructor
    virtual ~CModel_space_points_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef list< int > TX;
    typedef list< int > TY;
    typedef list< int > TZ;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_x,
        e_y,
        e_z
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef list< int > TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    const TX& GetX(void) const;
    TX& SetX(void);

    /// mandatory
    /// typedef list< int > TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    const TY& GetY(void) const;
    TY& SetY(void);

    /// mandatory
    /// typedef list< int > TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    const TZ& GetZ(void) const;
    TZ& SetZ(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CModel_space_points_Base(const CModel_space_points_Base&);
    CModel_space_points_Base& operator=(const CModel_space_points_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    list< int > m_X;
    list< int > m_Y;
    list< int > m_Z;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CModel_space_points_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CModel_space_points_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CModel_space_points_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x3;
}

inline
CModel_space_points_Base::TScale_factor CModel_space_points_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(0);
    }
    return m_Scale_factor;
}

inline
void CModel_space_points_Base::SetScale_factor(CModel_space_points_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CModel_space_points_Base::TScale_factor& CModel_space_points_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CModel_space_points_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CModel_space_points_Base::CanGetX(void) const
{
    return true;
}

inline
const CModel_space_points_Base::TX& CModel_space_points_Base::GetX(void) const
{
    return m_X;
}

inline
CModel_space_points_Base::TX& CModel_space_points_Base::SetX(void)
{
    m_set_State[0] |= 0x4;
    return m_X;
}

inline
bool CModel_space_points_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CModel_space_points_Base::CanGetY(void) const
{
    return true;
}

inline
const CModel_space_points_Base::TY& CModel_space_points_Base::GetY(void) const
{
    return m_Y;
}

inline
CModel_space_points_Base::TY& CModel_space_points_Base::SetY(void)
{
    m_set_State[0] |= 0x10;
    return m_Y;
}

inline
bool CModel_space_points_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CModel_space_points_Base::CanGetZ(void) const
{
    return true;
}

inline
const CModel_space_points_Base::TZ& CModel_space_points_Base::GetZ(void) const
{
    return m_Z;
}

inline
CModel_space_points_Base::TZ& CModel_space_points_Base::SetZ(void)
{
    m_set_State[0] |= 0x40;
    return m_Z;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_MODEL_SPACE_POINTS_BASE_HPP
