/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biomol_descr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_BIOMOL_DESCR_BASE_HPP
#define OBJECTS_MMDB1_BIOMOL_DESCR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioSource;
class CPub;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A biomolecule description refers to the chemical structure of a molecule or 
/// component substructures.  This descriptor type is used at the level of
/// assemblies, molecules and residues, and also for residue-graph dictionaries.
/// The BioSource object type is drawn from NCBI taxonomy data specifications,
/// and is not repeated here.
class NCBI_MMDB1_EXPORT CBiomol_descr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiomol_descr_Base(void);
    // destructor
    virtual ~CBiomol_descr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EAssembly_type {
        eAssembly_type_physiological_form    =   1,
        eAssembly_type_crystallographic_cell =   2,
        eAssembly_type_other                 = 255
    };
    
    /// Access to EAssembly_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAssembly_type)(void);
    
    enum EMolecule_type {
        eMolecule_type_dna              =   1,
        eMolecule_type_rna              =   2,
        eMolecule_type_protein          =   3,
        eMolecule_type_other_biopolymer =   4,
        eMolecule_type_solvent          =   5,
        eMolecule_type_other_nonpolymer =   6,
        eMolecule_type_other            = 255
    };
    
    /// Access to EMolecule_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMolecule_type)(void);
    

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,    ///< No variant selected
        e_Name,
        e_Pdb_class,
        e_Pdb_source,
        e_Pdb_comment,
        e_Other_comment,
        e_Organism,
        e_Attribution,
        e_Assembly_type,
        e_Molecule_type
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 10 ///< == e_Molecule_type+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TName;
    typedef string TPdb_class;
    typedef string TPdb_source;
    typedef string TPdb_comment;
    typedef string TOther_comment;
    typedef CBioSource TOrganism;
    typedef CPub TAttribution;
    typedef int TAssembly_type;
    typedef int TMolecule_type;

    // getters
    // setters

    // typedef string TName
    bool IsName(void) const;
    const TName& GetName(void) const;
    TName& SetName(void);
    void SetName(const TName& value);

    // typedef string TPdb_class
    bool IsPdb_class(void) const;
    const TPdb_class& GetPdb_class(void) const;
    TPdb_class& SetPdb_class(void);
    void SetPdb_class(const TPdb_class& value);

    // typedef string TPdb_source
    bool IsPdb_source(void) const;
    const TPdb_source& GetPdb_source(void) const;
    TPdb_source& SetPdb_source(void);
    void SetPdb_source(const TPdb_source& value);

    // typedef string TPdb_comment
    bool IsPdb_comment(void) const;
    const TPdb_comment& GetPdb_comment(void) const;
    TPdb_comment& SetPdb_comment(void);
    void SetPdb_comment(const TPdb_comment& value);

    // typedef string TOther_comment
    bool IsOther_comment(void) const;
    const TOther_comment& GetOther_comment(void) const;
    TOther_comment& SetOther_comment(void);
    void SetOther_comment(const TOther_comment& value);

    // typedef CBioSource TOrganism
    bool IsOrganism(void) const;
    const TOrganism& GetOrganism(void) const;
    TOrganism& SetOrganism(void);
    void SetOrganism(TOrganism& value);

    // typedef CPub TAttribution
    bool IsAttribution(void) const;
    const TAttribution& GetAttribution(void) const;
    TAttribution& SetAttribution(void);
    void SetAttribution(TAttribution& value);

    // typedef int TAssembly_type
    bool IsAssembly_type(void) const;
    TAssembly_type GetAssembly_type(void) const;
    TAssembly_type& SetAssembly_type(void);
    void SetAssembly_type(TAssembly_type value);

    // typedef int TMolecule_type
    bool IsMolecule_type(void) const;
    TMolecule_type GetMolecule_type(void) const;
    TMolecule_type& SetMolecule_type(void);
    void SetMolecule_type(TMolecule_type value);


private:
    // copy constructor and assignment operator
    CBiomol_descr_Base(const CBiomol_descr_Base& );
    CBiomol_descr_Base& operator=(const CBiomol_descr_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TAssembly_type m_Assembly_type;
        TMolecule_type m_Molecule_type;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBiomol_descr_Base::E_Choice CBiomol_descr_Base::Which(void) const
{
    return m_choice;
}

inline
void CBiomol_descr_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBiomol_descr_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBiomol_descr_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBiomol_descr_Base::IsName(void) const
{
    return m_choice == e_Name;
}

inline
const CBiomol_descr_Base::TName& CBiomol_descr_Base::GetName(void) const
{
    CheckSelected(e_Name);
    return *m_string;
}

inline
CBiomol_descr_Base::TName& CBiomol_descr_Base::SetName(void)
{
    Select(e_Name, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBiomol_descr_Base::IsPdb_class(void) const
{
    return m_choice == e_Pdb_class;
}

inline
const CBiomol_descr_Base::TPdb_class& CBiomol_descr_Base::GetPdb_class(void) const
{
    CheckSelected(e_Pdb_class);
    return *m_string;
}

inline
CBiomol_descr_Base::TPdb_class& CBiomol_descr_Base::SetPdb_class(void)
{
    Select(e_Pdb_class, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBiomol_descr_Base::IsPdb_source(void) const
{
    return m_choice == e_Pdb_source;
}

inline
const CBiomol_descr_Base::TPdb_source& CBiomol_descr_Base::GetPdb_source(void) const
{
    CheckSelected(e_Pdb_source);
    return *m_string;
}

inline
CBiomol_descr_Base::TPdb_source& CBiomol_descr_Base::SetPdb_source(void)
{
    Select(e_Pdb_source, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBiomol_descr_Base::IsPdb_comment(void) const
{
    return m_choice == e_Pdb_comment;
}

inline
const CBiomol_descr_Base::TPdb_comment& CBiomol_descr_Base::GetPdb_comment(void) const
{
    CheckSelected(e_Pdb_comment);
    return *m_string;
}

inline
CBiomol_descr_Base::TPdb_comment& CBiomol_descr_Base::SetPdb_comment(void)
{
    Select(e_Pdb_comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBiomol_descr_Base::IsOther_comment(void) const
{
    return m_choice == e_Other_comment;
}

inline
const CBiomol_descr_Base::TOther_comment& CBiomol_descr_Base::GetOther_comment(void) const
{
    CheckSelected(e_Other_comment);
    return *m_string;
}

inline
CBiomol_descr_Base::TOther_comment& CBiomol_descr_Base::SetOther_comment(void)
{
    Select(e_Other_comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBiomol_descr_Base::IsOrganism(void) const
{
    return m_choice == e_Organism;
}

inline
bool CBiomol_descr_Base::IsAttribution(void) const
{
    return m_choice == e_Attribution;
}

inline
bool CBiomol_descr_Base::IsAssembly_type(void) const
{
    return m_choice == e_Assembly_type;
}

inline
CBiomol_descr_Base::TAssembly_type CBiomol_descr_Base::GetAssembly_type(void) const
{
    CheckSelected(e_Assembly_type);
    return m_Assembly_type;
}

inline
CBiomol_descr_Base::TAssembly_type& CBiomol_descr_Base::SetAssembly_type(void)
{
    Select(e_Assembly_type, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Assembly_type;
}

inline
void CBiomol_descr_Base::SetAssembly_type(CBiomol_descr_Base::TAssembly_type value)
{
    Select(e_Assembly_type, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Assembly_type = value;
}

inline
bool CBiomol_descr_Base::IsMolecule_type(void) const
{
    return m_choice == e_Molecule_type;
}

inline
CBiomol_descr_Base::TMolecule_type CBiomol_descr_Base::GetMolecule_type(void) const
{
    CheckSelected(e_Molecule_type);
    return m_Molecule_type;
}

inline
CBiomol_descr_Base::TMolecule_type& CBiomol_descr_Base::SetMolecule_type(void)
{
    Select(e_Molecule_type, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Molecule_type;
}

inline
void CBiomol_descr_Base::SetMolecule_type(CBiomol_descr_Base::TMolecule_type value)
{
    Select(e_Molecule_type, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Molecule_type = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_BIOMOL_DESCR_BASE_HPP
