/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mla_back_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mla.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MLA_MLA_BACK_BASE_HPP
#define OBJECTS_MLA_MLA_BACK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/biblio/PubMedId.hpp>
#include <objects/mla/Error_val.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMedlars_entry;
class CMedline_entry;
class CPub;
class CPubmed_entry;
class CTitle_msg_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MLA_EXPORT CMla_back_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMla_back_Base(void);
    // destructor
    virtual ~CMla_back_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Init,         ///< DlInit
        e_Error,        ///< not found for getmle/getpub/citmatch
        e_Getmle,       ///< got Medline Entry
        e_Getpub,
        e_Gettitle,     ///< match titles
        e_Citmatch,     ///< citation lookup muid or 0
        e_Fini,         ///< DlFini
        e_Getuids,      ///< got a set of MUIDs
        e_Getpmids,     ///< got a set of PMIDs
        e_Outuid,       ///< result muid or 0 if not found
        e_Outpmid,      ///< result pmid or 0 if not found
        e_Getpme,       ///< got Pubmed Entry
        e_Getmlr        ///< got Medlars Entry
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 14 ///< == e_Getmlr+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef EError_val TError;
    typedef CMedline_entry TGetmle;
    typedef CPub TGetpub;
    typedef CTitle_msg_list TGettitle;
    typedef int TCitmatch;
    typedef list< int > TGetuids;
    typedef list< int > TGetpmids;
    typedef int TOutuid;
    typedef CPubMedId TOutpmid;
    typedef CPubmed_entry TGetpme;
    typedef CMedlars_entry TGetmlr;

    // getters
    // setters


    bool IsInit(void) const;
    void SetInit(void);

    // typedef EError_val TError
    bool IsError(void) const;
    TError GetError(void) const;
    TError& SetError(void);
    void SetError(TError value);

    // typedef CMedline_entry TGetmle
    bool IsGetmle(void) const;
    const TGetmle& GetGetmle(void) const;
    TGetmle& SetGetmle(void);
    void SetGetmle(TGetmle& value);

    // typedef CPub TGetpub
    bool IsGetpub(void) const;
    const TGetpub& GetGetpub(void) const;
    TGetpub& SetGetpub(void);
    void SetGetpub(TGetpub& value);

    // typedef CTitle_msg_list TGettitle
    bool IsGettitle(void) const;
    const TGettitle& GetGettitle(void) const;
    TGettitle& SetGettitle(void);
    void SetGettitle(TGettitle& value);

    // typedef int TCitmatch
    bool IsCitmatch(void) const;
    TCitmatch GetCitmatch(void) const;
    TCitmatch& SetCitmatch(void);
    void SetCitmatch(TCitmatch value);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef list< int > TGetuids
    bool IsGetuids(void) const;
    const TGetuids& GetGetuids(void) const;
    TGetuids& SetGetuids(void);

    // typedef list< int > TGetpmids
    bool IsGetpmids(void) const;
    const TGetpmids& GetGetpmids(void) const;
    TGetpmids& SetGetpmids(void);

    // typedef int TOutuid
    bool IsOutuid(void) const;
    TOutuid GetOutuid(void) const;
    TOutuid& SetOutuid(void);
    void SetOutuid(TOutuid value);

    // typedef CPubMedId TOutpmid
    bool IsOutpmid(void) const;
    const TOutpmid& GetOutpmid(void) const;
    TOutpmid& SetOutpmid(void);
    void SetOutpmid(const TOutpmid& value);

    // typedef CPubmed_entry TGetpme
    bool IsGetpme(void) const;
    const TGetpme& GetGetpme(void) const;
    TGetpme& SetGetpme(void);
    void SetGetpme(TGetpme& value);

    // typedef CMedlars_entry TGetmlr
    bool IsGetmlr(void) const;
    const TGetmlr& GetGetmlr(void) const;
    TGetmlr& SetGetmlr(void);
    void SetGetmlr(TGetmlr& value);


private:
    // copy constructor and assignment operator
    CMla_back_Base(const CMla_back_Base& );
    CMla_back_Base& operator=(const CMla_back_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TError m_Error;
        TCitmatch m_Citmatch;
        NCBI_NS_NCBI::CUnionBuffer<TGetuids> m_Getuids;
        NCBI_NS_NCBI::CUnionBuffer<TGetpmids> m_Getpmids;
        TOutuid m_Outuid;
        NCBI_NS_NCBI::CUnionBuffer<TOutpmid> m_Outpmid;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMla_back_Base::E_Choice CMla_back_Base::Which(void) const
{
    return m_choice;
}

inline
void CMla_back_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMla_back_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMla_back_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMla_back_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CMla_back_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMla_back_Base::IsError(void) const
{
    return m_choice == e_Error;
}

inline
CMla_back_Base::TError CMla_back_Base::GetError(void) const
{
    CheckSelected(e_Error);
    return m_Error;
}

inline
CMla_back_Base::TError& CMla_back_Base::SetError(void)
{
    Select(e_Error, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Error;
}

inline
void CMla_back_Base::SetError(CMla_back_Base::TError value)
{
    Select(e_Error, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Error = value;
}

inline
bool CMla_back_Base::IsGetmle(void) const
{
    return m_choice == e_Getmle;
}

inline
bool CMla_back_Base::IsGetpub(void) const
{
    return m_choice == e_Getpub;
}

inline
bool CMla_back_Base::IsGettitle(void) const
{
    return m_choice == e_Gettitle;
}

inline
bool CMla_back_Base::IsCitmatch(void) const
{
    return m_choice == e_Citmatch;
}

inline
CMla_back_Base::TCitmatch CMla_back_Base::GetCitmatch(void) const
{
    CheckSelected(e_Citmatch);
    return m_Citmatch;
}

inline
CMla_back_Base::TCitmatch& CMla_back_Base::SetCitmatch(void)
{
    Select(e_Citmatch, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Citmatch;
}

inline
void CMla_back_Base::SetCitmatch(CMla_back_Base::TCitmatch value)
{
    Select(e_Citmatch, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Citmatch = value;
}

inline
bool CMla_back_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CMla_back_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMla_back_Base::IsGetuids(void) const
{
    return m_choice == e_Getuids;
}

inline
const CMla_back_Base::TGetuids& CMla_back_Base::GetGetuids(void) const
{
    CheckSelected(e_Getuids);
    return *m_Getuids;
}

inline
CMla_back_Base::TGetuids& CMla_back_Base::SetGetuids(void)
{
    Select(e_Getuids, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getuids;
}

inline
bool CMla_back_Base::IsGetpmids(void) const
{
    return m_choice == e_Getpmids;
}

inline
const CMla_back_Base::TGetpmids& CMla_back_Base::GetGetpmids(void) const
{
    CheckSelected(e_Getpmids);
    return *m_Getpmids;
}

inline
CMla_back_Base::TGetpmids& CMla_back_Base::SetGetpmids(void)
{
    Select(e_Getpmids, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getpmids;
}

inline
bool CMla_back_Base::IsOutuid(void) const
{
    return m_choice == e_Outuid;
}

inline
CMla_back_Base::TOutuid CMla_back_Base::GetOutuid(void) const
{
    CheckSelected(e_Outuid);
    return m_Outuid;
}

inline
CMla_back_Base::TOutuid& CMla_back_Base::SetOutuid(void)
{
    Select(e_Outuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Outuid;
}

inline
void CMla_back_Base::SetOutuid(CMla_back_Base::TOutuid value)
{
    Select(e_Outuid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Outuid = value;
}

inline
bool CMla_back_Base::IsOutpmid(void) const
{
    return m_choice == e_Outpmid;
}

inline
const CMla_back_Base::TOutpmid& CMla_back_Base::GetOutpmid(void) const
{
    CheckSelected(e_Outpmid);
    return *m_Outpmid;
}

inline
CMla_back_Base::TOutpmid& CMla_back_Base::SetOutpmid(void)
{
    Select(e_Outpmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Outpmid;
}

inline
bool CMla_back_Base::IsGetpme(void) const
{
    return m_choice == e_Getpme;
}

inline
bool CMla_back_Base::IsGetmlr(void) const
{
    return m_choice == e_Getmlr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MLA_MLA_BACK_BASE_HPP
