/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Medline_entry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'medline.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MEDLINE_MEDLINE_ENTRY_BASE_HPP
#define OBJECTS_MEDLINE_MEDLINE_ENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCit_art;
class CDate;
class CMedline_field;
class CMedline_mesh;
class CMedline_rn;
class CMedline_si;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a MEDLINE or PubMed entry
/// regular medline record
class NCBI_MEDLINE_EXPORT CMedline_entry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMedline_entry_Base(void);
    // destructor
    virtual ~CMedline_entry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EStatus {
        eStatus_publisher  = 1,  ///< record as supplied by publisher
        eStatus_premedline = 2,  ///< premedline record
        eStatus_medline    = 3
    };
    
    /// Access to EStatus's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EStatus)(void);
    
    // types
    typedef NCBI_NS_NCBI::TEntrezId TUid;
    typedef CDate TEm;
    typedef CCit_art TCit;
    typedef string TAbstract;
    typedef list< CRef< CMedline_mesh > > TMesh;
    typedef list< CRef< CMedline_rn > > TSubstance;
    typedef list< CRef< CMedline_si > > TXref;
    typedef list< string > TIdnum;
    typedef list< string > TGene;
    typedef CPubMedId TPmid;
    typedef list< string > TPub_type;
    typedef list< CRef< CMedline_field > > TMlfield;
    typedef int TStatus;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_uid,
        e_em,
        e_cit,
        e_abstract,
        e_mesh,
        e_substance,
        e_xref,
        e_idnum,
        e_gene,
        e_pmid,
        e_pub_type,
        e_mlfield,
        e_status
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;

    // getters
    // setters

    /// MEDLINE UID, sometimes not yet available if from PubMed
    /// optional
    /// typedef NCBI_NS_NCBI::TEntrezId TUid
    ///  Check whether the Uid data member has been assigned a value.
    bool IsSetUid(void) const;
    /// Check whether it is safe or not to call GetUid method.
    bool CanGetUid(void) const;
    void ResetUid(void);
    TUid GetUid(void) const;
    void SetUid(TUid value);
    TUid& SetUid(void);

    /// Entry Month
    /// mandatory
    /// typedef CDate TEm
    ///  Check whether the Em data member has been assigned a value.
    bool IsSetEm(void) const;
    /// Check whether it is safe or not to call GetEm method.
    bool CanGetEm(void) const;
    void ResetEm(void);
    const TEm& GetEm(void) const;
    void SetEm(TEm& value);
    TEm& SetEm(void);

    /// article citation
    /// mandatory
    /// typedef CCit_art TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(TCit& value);
    TCit& SetCit(void);

    /// optional
    /// typedef string TAbstract
    ///  Check whether the Abstract data member has been assigned a value.
    bool IsSetAbstract(void) const;
    /// Check whether it is safe or not to call GetAbstract method.
    bool CanGetAbstract(void) const;
    void ResetAbstract(void);
    const TAbstract& GetAbstract(void) const;
    void SetAbstract(const TAbstract& value);
    void SetAbstract(TAbstract&& value);
    TAbstract& SetAbstract(void);

    /// optional
    /// typedef list< CRef< CMedline_mesh > > TMesh
    ///  Check whether the Mesh data member has been assigned a value.
    bool IsSetMesh(void) const;
    /// Check whether it is safe or not to call GetMesh method.
    bool CanGetMesh(void) const;
    void ResetMesh(void);
    const TMesh& GetMesh(void) const;
    TMesh& SetMesh(void);

    /// optional
    /// typedef list< CRef< CMedline_rn > > TSubstance
    ///  Check whether the Substance data member has been assigned a value.
    bool IsSetSubstance(void) const;
    /// Check whether it is safe or not to call GetSubstance method.
    bool CanGetSubstance(void) const;
    void ResetSubstance(void);
    const TSubstance& GetSubstance(void) const;
    TSubstance& SetSubstance(void);

    /// optional
    /// typedef list< CRef< CMedline_si > > TXref
    ///  Check whether the Xref data member has been assigned a value.
    bool IsSetXref(void) const;
    /// Check whether it is safe or not to call GetXref method.
    bool CanGetXref(void) const;
    void ResetXref(void);
    const TXref& GetXref(void) const;
    TXref& SetXref(void);

    /// ID Number (grants, contracts)
    /// optional
    /// typedef list< string > TIdnum
    ///  Check whether the Idnum data member has been assigned a value.
    bool IsSetIdnum(void) const;
    /// Check whether it is safe or not to call GetIdnum method.
    bool CanGetIdnum(void) const;
    void ResetIdnum(void);
    const TIdnum& GetIdnum(void) const;
    TIdnum& SetIdnum(void);

    /// optional
    /// typedef list< string > TGene
    ///  Check whether the Gene data member has been assigned a value.
    bool IsSetGene(void) const;
    /// Check whether it is safe or not to call GetGene method.
    bool CanGetGene(void) const;
    void ResetGene(void);
    const TGene& GetGene(void) const;
    TGene& SetGene(void);

    /// MEDLINE records may include the PubMedId
    /// optional
    /// typedef CPubMedId TPmid
    ///  Check whether the Pmid data member has been assigned a value.
    bool IsSetPmid(void) const;
    /// Check whether it is safe or not to call GetPmid method.
    bool CanGetPmid(void) const;
    void ResetPmid(void);
    const TPmid& GetPmid(void) const;
    void SetPmid(const TPmid& value);
    TPmid& SetPmid(void);

    /// may show publication types (review, etc)
    /// optional
    /// typedef list< string > TPub_type
    ///  Check whether the Pub_type data member has been assigned a value.
    bool IsSetPub_type(void) const;
    /// Check whether it is safe or not to call GetPub_type method.
    bool CanGetPub_type(void) const;
    void ResetPub_type(void);
    const TPub_type& GetPub_type(void) const;
    TPub_type& SetPub_type(void);

    /// additional Medline field types
    /// optional
    /// typedef list< CRef< CMedline_field > > TMlfield
    ///  Check whether the Mlfield data member has been assigned a value.
    bool IsSetMlfield(void) const;
    /// Check whether it is safe or not to call GetMlfield method.
    bool CanGetMlfield(void) const;
    void ResetMlfield(void);
    const TMlfield& GetMlfield(void) const;
    TMlfield& SetMlfield(void);

    /// optional with default eStatus_medline
    /// typedef int TStatus
    ///  Check whether the Status data member has been assigned a value.
    bool IsSetStatus(void) const;
    /// Check whether it is safe or not to call GetStatus method.
    bool CanGetStatus(void) const;
    void ResetStatus(void);
    void SetDefaultStatus(void);
    TStatus GetStatus(void) const;
    void SetStatus(TStatus value);
    TStatus& SetStatus(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedline_entry_Base(const CMedline_entry_Base&);
    CMedline_entry_Base& operator=(const CMedline_entry_Base&);

    // data
    Uint4 m_set_State[1];
    ncbi::TIntId m_Uid;
    CRef< TEm > m_Em;
    CRef< TCit > m_Cit;
    string m_Abstract;
    list< CRef< CMedline_mesh > > m_Mesh;
    list< CRef< CMedline_rn > > m_Substance;
    list< CRef< CMedline_si > > m_Xref;
    list< string > m_Idnum;
    list< string > m_Gene;
    CPubMedId m_Pmid;
    list< string > m_Pub_type;
    list< CRef< CMedline_field > > m_Mlfield;
    int m_Status;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedline_entry_Base::IsSetUid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMedline_entry_Base::CanGetUid(void) const
{
    return IsSetUid();
}

inline
void CMedline_entry_Base::ResetUid(void)
{
    m_Uid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMedline_entry_Base::TUid CMedline_entry_Base::GetUid(void) const
{
    if (!CanGetUid()) {
        ThrowUnassigned(0);
    }
    return reinterpret_cast<const TUid&>(m_Uid);
}

inline
void CMedline_entry_Base::SetUid(CMedline_entry_Base::TUid value)
{
    reinterpret_cast<TUid&>(m_Uid) = value;
    m_set_State[0] |= 0x3;
}

inline
CMedline_entry_Base::TUid& CMedline_entry_Base::SetUid(void)
{
#ifdef _DEBUG
    if (!IsSetUid()) {
        memset(&m_Uid,UnassignedByte(),sizeof(m_Uid));
    }
#endif
    m_set_State[0] |= 0x1;
    return reinterpret_cast<TUid&>(m_Uid);
}

inline
bool CMedline_entry_Base::IsSetEm(void) const
{
    return m_Em.NotEmpty();
}

inline
bool CMedline_entry_Base::CanGetEm(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TEm& CMedline_entry_Base::GetEm(void) const
{
    if ( !m_Em ) {
        const_cast<CMedline_entry_Base*>(this)->ResetEm();
    }
    return (*m_Em);
}

inline
CMedline_entry_Base::TEm& CMedline_entry_Base::SetEm(void)
{
    if ( !m_Em ) {
        ResetEm();
    }
    return (*m_Em);
}

inline
bool CMedline_entry_Base::IsSetCit(void) const
{
    return m_Cit.NotEmpty();
}

inline
bool CMedline_entry_Base::CanGetCit(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TCit& CMedline_entry_Base::GetCit(void) const
{
    if ( !m_Cit ) {
        const_cast<CMedline_entry_Base*>(this)->ResetCit();
    }
    return (*m_Cit);
}

inline
CMedline_entry_Base::TCit& CMedline_entry_Base::SetCit(void)
{
    if ( !m_Cit ) {
        ResetCit();
    }
    return (*m_Cit);
}

inline
bool CMedline_entry_Base::IsSetAbstract(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMedline_entry_Base::CanGetAbstract(void) const
{
    return IsSetAbstract();
}

inline
const CMedline_entry_Base::TAbstract& CMedline_entry_Base::GetAbstract(void) const
{
    if (!CanGetAbstract()) {
        ThrowUnassigned(3);
    }
    return m_Abstract;
}

inline
void CMedline_entry_Base::SetAbstract(const CMedline_entry_Base::TAbstract& value)
{
    m_Abstract = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMedline_entry_Base::SetAbstract(CMedline_entry_Base::TAbstract&& value)
{
    m_Abstract = std::forward<CMedline_entry_Base::TAbstract>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMedline_entry_Base::TAbstract& CMedline_entry_Base::SetAbstract(void)
{
#ifdef _DEBUG
    if (!IsSetAbstract()) {
        m_Abstract = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Abstract;
}

inline
bool CMedline_entry_Base::IsSetMesh(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMedline_entry_Base::CanGetMesh(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TMesh& CMedline_entry_Base::GetMesh(void) const
{
    return m_Mesh;
}

inline
CMedline_entry_Base::TMesh& CMedline_entry_Base::SetMesh(void)
{
    m_set_State[0] |= 0x100;
    return m_Mesh;
}

inline
bool CMedline_entry_Base::IsSetSubstance(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMedline_entry_Base::CanGetSubstance(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TSubstance& CMedline_entry_Base::GetSubstance(void) const
{
    return m_Substance;
}

inline
CMedline_entry_Base::TSubstance& CMedline_entry_Base::SetSubstance(void)
{
    m_set_State[0] |= 0x400;
    return m_Substance;
}

inline
bool CMedline_entry_Base::IsSetXref(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMedline_entry_Base::CanGetXref(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TXref& CMedline_entry_Base::GetXref(void) const
{
    return m_Xref;
}

inline
CMedline_entry_Base::TXref& CMedline_entry_Base::SetXref(void)
{
    m_set_State[0] |= 0x1000;
    return m_Xref;
}

inline
bool CMedline_entry_Base::IsSetIdnum(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMedline_entry_Base::CanGetIdnum(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TIdnum& CMedline_entry_Base::GetIdnum(void) const
{
    return m_Idnum;
}

inline
CMedline_entry_Base::TIdnum& CMedline_entry_Base::SetIdnum(void)
{
    m_set_State[0] |= 0x4000;
    return m_Idnum;
}

inline
bool CMedline_entry_Base::IsSetGene(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMedline_entry_Base::CanGetGene(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TGene& CMedline_entry_Base::GetGene(void) const
{
    return m_Gene;
}

inline
CMedline_entry_Base::TGene& CMedline_entry_Base::SetGene(void)
{
    m_set_State[0] |= 0x10000;
    return m_Gene;
}

inline
bool CMedline_entry_Base::IsSetPmid(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMedline_entry_Base::CanGetPmid(void) const
{
    return IsSetPmid();
}

inline
void CMedline_entry_Base::ResetPmid(void)
{
    m_Pmid = CPubMedId(0);
    m_set_State[0] &= ~0xc0000;
}

inline
const CMedline_entry_Base::TPmid& CMedline_entry_Base::GetPmid(void) const
{
    if (!CanGetPmid()) {
        ThrowUnassigned(9);
    }
    return m_Pmid;
}

inline
void CMedline_entry_Base::SetPmid(const CMedline_entry_Base::TPmid& value)
{
    m_Pmid = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMedline_entry_Base::TPmid& CMedline_entry_Base::SetPmid(void)
{
    m_set_State[0] |= 0x40000;
    return m_Pmid;
}

inline
bool CMedline_entry_Base::IsSetPub_type(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMedline_entry_Base::CanGetPub_type(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TPub_type& CMedline_entry_Base::GetPub_type(void) const
{
    return m_Pub_type;
}

inline
CMedline_entry_Base::TPub_type& CMedline_entry_Base::SetPub_type(void)
{
    m_set_State[0] |= 0x100000;
    return m_Pub_type;
}

inline
bool CMedline_entry_Base::IsSetMlfield(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMedline_entry_Base::CanGetMlfield(void) const
{
    return true;
}

inline
const CMedline_entry_Base::TMlfield& CMedline_entry_Base::GetMlfield(void) const
{
    return m_Mlfield;
}

inline
CMedline_entry_Base::TMlfield& CMedline_entry_Base::SetMlfield(void)
{
    m_set_State[0] |= 0x400000;
    return m_Mlfield;
}

inline
bool CMedline_entry_Base::IsSetStatus(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMedline_entry_Base::CanGetStatus(void) const
{
    return true;
}

inline
void CMedline_entry_Base::ResetStatus(void)
{
    m_Status = eStatus_medline;
    m_set_State[0] &= ~0x3000000;
}

inline
void CMedline_entry_Base::SetDefaultStatus(void)
{
    ResetStatus();
}

inline
CMedline_entry_Base::TStatus CMedline_entry_Base::GetStatus(void) const
{
    return m_Status;
}

inline
void CMedline_entry_Base::SetStatus(CMedline_entry_Base::TStatus value)
{
    m_Status = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMedline_entry_Base::TStatus& CMedline_entry_Base::SetStatus(void)
{
#ifdef _DEBUG
    if (!IsSetStatus()) {
        memset(&m_Status,UnassignedByte(),sizeof(m_Status));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Status;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MEDLINE_MEDLINE_ENTRY_BASE_HPP
