/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Medlars_entry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'medlars.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MEDLARS_MEDLARS_ENTRY_BASE_HPP
#define OBJECTS_MEDLARS_MEDLARS_ENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMedlars_record;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a MEDLARS entry
class NCBI_MEDLARS_EXPORT CMedlars_entry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMedlars_entry_Base(void);
    // destructor
    virtual ~CMedlars_entry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPubMedId TPmid;
    typedef int TMuid;
    typedef list< CRef< CMedlars_record > > TRecs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pmid,
        e_muid,
        e_recs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// All entries in PubMed must have it
    /// mandatory
    /// typedef CPubMedId TPmid
    ///  Check whether the Pmid data member has been assigned a value.
    bool IsSetPmid(void) const;
    /// Check whether it is safe or not to call GetPmid method.
    bool CanGetPmid(void) const;
    void ResetPmid(void);
    const TPmid& GetPmid(void) const;
    void SetPmid(const TPmid& value);
    TPmid& SetPmid(void);

    /// Medline(OCCS) id
    /// optional
    /// typedef int TMuid
    ///  Check whether the Muid data member has been assigned a value.
    bool IsSetMuid(void) const;
    /// Check whether it is safe or not to call GetMuid method.
    bool CanGetMuid(void) const;
    void ResetMuid(void);
    TMuid GetMuid(void) const;
    void SetMuid(TMuid value);
    TMuid& SetMuid(void);

    /// List of Medlars records
    /// mandatory
    /// typedef list< CRef< CMedlars_record > > TRecs
    ///  Check whether the Recs data member has been assigned a value.
    bool IsSetRecs(void) const;
    /// Check whether it is safe or not to call GetRecs method.
    bool CanGetRecs(void) const;
    void ResetRecs(void);
    const TRecs& GetRecs(void) const;
    TRecs& SetRecs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedlars_entry_Base(const CMedlars_entry_Base&);
    CMedlars_entry_Base& operator=(const CMedlars_entry_Base&);

    // data
    Uint4 m_set_State[1];
    CPubMedId m_Pmid;
    int m_Muid;
    list< CRef< CMedlars_record > > m_Recs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedlars_entry_Base::IsSetPmid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMedlars_entry_Base::CanGetPmid(void) const
{
    return IsSetPmid();
}

inline
void CMedlars_entry_Base::ResetPmid(void)
{
    m_Pmid = CPubMedId(0);
    m_set_State[0] &= ~0x3;
}

inline
const CMedlars_entry_Base::TPmid& CMedlars_entry_Base::GetPmid(void) const
{
    if (!CanGetPmid()) {
        ThrowUnassigned(0);
    }
    return m_Pmid;
}

inline
void CMedlars_entry_Base::SetPmid(const CMedlars_entry_Base::TPmid& value)
{
    m_Pmid = value;
    m_set_State[0] |= 0x3;
}

inline
CMedlars_entry_Base::TPmid& CMedlars_entry_Base::SetPmid(void)
{
    m_set_State[0] |= 0x1;
    return m_Pmid;
}

inline
bool CMedlars_entry_Base::IsSetMuid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMedlars_entry_Base::CanGetMuid(void) const
{
    return IsSetMuid();
}

inline
void CMedlars_entry_Base::ResetMuid(void)
{
    m_Muid = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMedlars_entry_Base::TMuid CMedlars_entry_Base::GetMuid(void) const
{
    if (!CanGetMuid()) {
        ThrowUnassigned(1);
    }
    return m_Muid;
}

inline
void CMedlars_entry_Base::SetMuid(CMedlars_entry_Base::TMuid value)
{
    m_Muid = value;
    m_set_State[0] |= 0xc;
}

inline
CMedlars_entry_Base::TMuid& CMedlars_entry_Base::SetMuid(void)
{
#ifdef _DEBUG
    if (!IsSetMuid()) {
        memset(&m_Muid,UnassignedByte(),sizeof(m_Muid));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Muid;
}

inline
bool CMedlars_entry_Base::IsSetRecs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMedlars_entry_Base::CanGetRecs(void) const
{
    return true;
}

inline
const CMedlars_entry_Base::TRecs& CMedlars_entry_Base::GetRecs(void) const
{
    return m_Recs;
}

inline
CMedlars_entry_Base::TRecs& CMedlars_entry_Base::SetRecs(void)
{
    m_set_State[0] |= 0x10;
    return m_Recs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MEDLARS_MEDLARS_ENTRY_BASE_HPP
