/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Translation_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_TRANSLATION_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_TRANSLATION_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Match_type_constraint.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CQuantity_constraint;
class CString_constraint_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CTranslation_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTranslation_constraint_Base(void);
    // destructor
    virtual ~CTranslation_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CString_constraint_set TActual_strings;
    typedef CString_constraint_set TTransl_strings;
    typedef EMatch_type_constraint TInternal_stops;
    typedef CQuantity_constraint TNum_mismatches;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_actual_strings,
        e_transl_strings,
        e_internal_stops,
        e_num_mismatches
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CString_constraint_set TActual_strings
    ///  Check whether the Actual_strings data member has been assigned a value.
    bool IsSetActual_strings(void) const;
    /// Check whether it is safe or not to call GetActual_strings method.
    bool CanGetActual_strings(void) const;
    void ResetActual_strings(void);
    const TActual_strings& GetActual_strings(void) const;
    void SetActual_strings(TActual_strings& value);
    TActual_strings& SetActual_strings(void);

    /// mandatory
    /// typedef CString_constraint_set TTransl_strings
    ///  Check whether the Transl_strings data member has been assigned a value.
    bool IsSetTransl_strings(void) const;
    /// Check whether it is safe or not to call GetTransl_strings method.
    bool CanGetTransl_strings(void) const;
    void ResetTransl_strings(void);
    const TTransl_strings& GetTransl_strings(void) const;
    void SetTransl_strings(TTransl_strings& value);
    TTransl_strings& SetTransl_strings(void);

    /// optional with default eMatch_type_constraint_dont_care
    /// typedef EMatch_type_constraint TInternal_stops
    ///  Check whether the Internal_stops data member has been assigned a value.
    bool IsSetInternal_stops(void) const;
    /// Check whether it is safe or not to call GetInternal_stops method.
    bool CanGetInternal_stops(void) const;
    void ResetInternal_stops(void);
    void SetDefaultInternal_stops(void);
    TInternal_stops GetInternal_stops(void) const;
    void SetInternal_stops(TInternal_stops value);
    TInternal_stops& SetInternal_stops(void);

    /// optional
    /// typedef CQuantity_constraint TNum_mismatches
    ///  Check whether the Num_mismatches data member has been assigned a value.
    bool IsSetNum_mismatches(void) const;
    /// Check whether it is safe or not to call GetNum_mismatches method.
    bool CanGetNum_mismatches(void) const;
    void ResetNum_mismatches(void);
    const TNum_mismatches& GetNum_mismatches(void) const;
    void SetNum_mismatches(TNum_mismatches& value);
    TNum_mismatches& SetNum_mismatches(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTranslation_constraint_Base(const CTranslation_constraint_Base&);
    CTranslation_constraint_Base& operator=(const CTranslation_constraint_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TActual_strings > m_Actual_strings;
    CRef< TTransl_strings > m_Transl_strings;
    EMatch_type_constraint m_Internal_stops;
    CRef< TNum_mismatches > m_Num_mismatches;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTranslation_constraint_Base::IsSetActual_strings(void) const
{
    return m_Actual_strings.NotEmpty();
}

inline
bool CTranslation_constraint_Base::CanGetActual_strings(void) const
{
    return true;
}

inline
const CTranslation_constraint_Base::TActual_strings& CTranslation_constraint_Base::GetActual_strings(void) const
{
    if ( !m_Actual_strings ) {
        const_cast<CTranslation_constraint_Base*>(this)->ResetActual_strings();
    }
    return (*m_Actual_strings);
}

inline
CTranslation_constraint_Base::TActual_strings& CTranslation_constraint_Base::SetActual_strings(void)
{
    if ( !m_Actual_strings ) {
        ResetActual_strings();
    }
    return (*m_Actual_strings);
}

inline
bool CTranslation_constraint_Base::IsSetTransl_strings(void) const
{
    return m_Transl_strings.NotEmpty();
}

inline
bool CTranslation_constraint_Base::CanGetTransl_strings(void) const
{
    return true;
}

inline
const CTranslation_constraint_Base::TTransl_strings& CTranslation_constraint_Base::GetTransl_strings(void) const
{
    if ( !m_Transl_strings ) {
        const_cast<CTranslation_constraint_Base*>(this)->ResetTransl_strings();
    }
    return (*m_Transl_strings);
}

inline
CTranslation_constraint_Base::TTransl_strings& CTranslation_constraint_Base::SetTransl_strings(void)
{
    if ( !m_Transl_strings ) {
        ResetTransl_strings();
    }
    return (*m_Transl_strings);
}

inline
bool CTranslation_constraint_Base::IsSetInternal_stops(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTranslation_constraint_Base::CanGetInternal_stops(void) const
{
    return true;
}

inline
void CTranslation_constraint_Base::ResetInternal_stops(void)
{
    m_Internal_stops = eMatch_type_constraint_dont_care;
    m_set_State[0] &= ~0x30;
}

inline
void CTranslation_constraint_Base::SetDefaultInternal_stops(void)
{
    ResetInternal_stops();
}

inline
CTranslation_constraint_Base::TInternal_stops CTranslation_constraint_Base::GetInternal_stops(void) const
{
    return m_Internal_stops;
}

inline
void CTranslation_constraint_Base::SetInternal_stops(CTranslation_constraint_Base::TInternal_stops value)
{
    m_Internal_stops = value;
    m_set_State[0] |= 0x30;
}

inline
CTranslation_constraint_Base::TInternal_stops& CTranslation_constraint_Base::SetInternal_stops(void)
{
#ifdef _DEBUG
    if (!IsSetInternal_stops()) {
        memset(&m_Internal_stops,UnassignedByte(),sizeof(m_Internal_stops));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Internal_stops;
}

inline
bool CTranslation_constraint_Base::IsSetNum_mismatches(void) const
{
    return m_Num_mismatches.NotEmpty();
}

inline
bool CTranslation_constraint_Base::CanGetNum_mismatches(void) const
{
    return IsSetNum_mismatches();
}

inline
const CTranslation_constraint_Base::TNum_mismatches& CTranslation_constraint_Base::GetNum_mismatches(void) const
{
    if (!CanGetNum_mismatches()) {
        ThrowUnassigned(3);
    }
    return (*m_Num_mismatches);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_TRANSLATION_CONSTRAINT_BASE_HPP
