/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Suspect_rule_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_SUSPECT_RULE_BASE_HPP
#define OBJECTS_MACRO_SUSPECT_RULE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/Fix_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;
class CReplace_rule;
class CSearch_func;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSuspect_rule_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSuspect_rule_Base(void);
    // destructor
    virtual ~CSuspect_rule_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSearch_func TFind;
    typedef CSearch_func TExcept;
    typedef CConstraint_choice_set TFeat_constraint;
    typedef EFix_type TRule_type;
    typedef CReplace_rule TReplace;
    typedef string TDescription;
    typedef bool TFatal;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_find,
        e_except,
        e_feat_constraint,
        e_rule_type,
        e_replace,
        e_description,
        e_fatal
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSearch_func TFind
    ///  Check whether the Find data member has been assigned a value.
    bool IsSetFind(void) const;
    /// Check whether it is safe or not to call GetFind method.
    bool CanGetFind(void) const;
    void ResetFind(void);
    const TFind& GetFind(void) const;
    void SetFind(TFind& value);
    TFind& SetFind(void);

    /// optional
    /// typedef CSearch_func TExcept
    ///  Check whether the Except data member has been assigned a value.
    bool IsSetExcept(void) const;
    /// Check whether it is safe or not to call GetExcept method.
    bool CanGetExcept(void) const;
    void ResetExcept(void);
    const TExcept& GetExcept(void) const;
    void SetExcept(TExcept& value);
    TExcept& SetExcept(void);

    /// optional
    /// typedef CConstraint_choice_set TFeat_constraint
    ///  Check whether the Feat_constraint data member has been assigned a value.
    bool IsSetFeat_constraint(void) const;
    /// Check whether it is safe or not to call GetFeat_constraint method.
    bool CanGetFeat_constraint(void) const;
    void ResetFeat_constraint(void);
    const TFeat_constraint& GetFeat_constraint(void) const;
    void SetFeat_constraint(TFeat_constraint& value);
    TFeat_constraint& SetFeat_constraint(void);

    /// optional with default eFix_type_none
    /// typedef EFix_type TRule_type
    ///  Check whether the Rule_type data member has been assigned a value.
    bool IsSetRule_type(void) const;
    /// Check whether it is safe or not to call GetRule_type method.
    bool CanGetRule_type(void) const;
    void ResetRule_type(void);
    void SetDefaultRule_type(void);
    TRule_type GetRule_type(void) const;
    void SetRule_type(TRule_type value);
    TRule_type& SetRule_type(void);

    /// optional
    /// typedef CReplace_rule TReplace
    ///  Check whether the Replace data member has been assigned a value.
    bool IsSetReplace(void) const;
    /// Check whether it is safe or not to call GetReplace method.
    bool CanGetReplace(void) const;
    void ResetReplace(void);
    const TReplace& GetReplace(void) const;
    void SetReplace(TReplace& value);
    TReplace& SetReplace(void);

    /// optional
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// optional with default false
    /// typedef bool TFatal
    ///  Check whether the Fatal data member has been assigned a value.
    bool IsSetFatal(void) const;
    /// Check whether it is safe or not to call GetFatal method.
    bool CanGetFatal(void) const;
    void ResetFatal(void);
    void SetDefaultFatal(void);
    TFatal GetFatal(void) const;
    void SetFatal(TFatal value);
    TFatal& SetFatal(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSuspect_rule_Base(const CSuspect_rule_Base&);
    CSuspect_rule_Base& operator=(const CSuspect_rule_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TFind > m_Find;
    CRef< TExcept > m_Except;
    CRef< TFeat_constraint > m_Feat_constraint;
    EFix_type m_Rule_type;
    CRef< TReplace > m_Replace;
    string m_Description;
    bool m_Fatal;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSuspect_rule_Base::IsSetFind(void) const
{
    return m_Find.NotEmpty();
}

inline
bool CSuspect_rule_Base::CanGetFind(void) const
{
    return true;
}

inline
const CSuspect_rule_Base::TFind& CSuspect_rule_Base::GetFind(void) const
{
    if ( !m_Find ) {
        const_cast<CSuspect_rule_Base*>(this)->ResetFind();
    }
    return (*m_Find);
}

inline
CSuspect_rule_Base::TFind& CSuspect_rule_Base::SetFind(void)
{
    if ( !m_Find ) {
        ResetFind();
    }
    return (*m_Find);
}

inline
bool CSuspect_rule_Base::IsSetExcept(void) const
{
    return m_Except.NotEmpty();
}

inline
bool CSuspect_rule_Base::CanGetExcept(void) const
{
    return IsSetExcept();
}

inline
const CSuspect_rule_Base::TExcept& CSuspect_rule_Base::GetExcept(void) const
{
    if (!CanGetExcept()) {
        ThrowUnassigned(1);
    }
    return (*m_Except);
}

inline
bool CSuspect_rule_Base::IsSetFeat_constraint(void) const
{
    return m_Feat_constraint.NotEmpty();
}

inline
bool CSuspect_rule_Base::CanGetFeat_constraint(void) const
{
    return IsSetFeat_constraint();
}

inline
const CSuspect_rule_Base::TFeat_constraint& CSuspect_rule_Base::GetFeat_constraint(void) const
{
    if (!CanGetFeat_constraint()) {
        ThrowUnassigned(2);
    }
    return (*m_Feat_constraint);
}

inline
bool CSuspect_rule_Base::IsSetRule_type(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSuspect_rule_Base::CanGetRule_type(void) const
{
    return true;
}

inline
void CSuspect_rule_Base::ResetRule_type(void)
{
    m_Rule_type = eFix_type_none;
    m_set_State[0] &= ~0xc0;
}

inline
void CSuspect_rule_Base::SetDefaultRule_type(void)
{
    ResetRule_type();
}

inline
CSuspect_rule_Base::TRule_type CSuspect_rule_Base::GetRule_type(void) const
{
    return m_Rule_type;
}

inline
void CSuspect_rule_Base::SetRule_type(CSuspect_rule_Base::TRule_type value)
{
    m_Rule_type = value;
    m_set_State[0] |= 0xc0;
}

inline
CSuspect_rule_Base::TRule_type& CSuspect_rule_Base::SetRule_type(void)
{
#ifdef _DEBUG
    if (!IsSetRule_type()) {
        memset(&m_Rule_type,UnassignedByte(),sizeof(m_Rule_type));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Rule_type;
}

inline
bool CSuspect_rule_Base::IsSetReplace(void) const
{
    return m_Replace.NotEmpty();
}

inline
bool CSuspect_rule_Base::CanGetReplace(void) const
{
    return IsSetReplace();
}

inline
const CSuspect_rule_Base::TReplace& CSuspect_rule_Base::GetReplace(void) const
{
    if (!CanGetReplace()) {
        ThrowUnassigned(4);
    }
    return (*m_Replace);
}

inline
bool CSuspect_rule_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSuspect_rule_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CSuspect_rule_Base::TDescription& CSuspect_rule_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(5);
    }
    return m_Description;
}

inline
void CSuspect_rule_Base::SetDescription(const CSuspect_rule_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0xc00;
}

inline
void CSuspect_rule_Base::SetDescription(CSuspect_rule_Base::TDescription&& value)
{
    m_Description = std::forward<CSuspect_rule_Base::TDescription>(value);
    m_set_State[0] |= 0xc00;
}

inline
CSuspect_rule_Base::TDescription& CSuspect_rule_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Description;
}

inline
bool CSuspect_rule_Base::IsSetFatal(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSuspect_rule_Base::CanGetFatal(void) const
{
    return true;
}

inline
void CSuspect_rule_Base::ResetFatal(void)
{
    m_Fatal = false;
    m_set_State[0] &= ~0x3000;
}

inline
void CSuspect_rule_Base::SetDefaultFatal(void)
{
    ResetFatal();
}

inline
CSuspect_rule_Base::TFatal CSuspect_rule_Base::GetFatal(void) const
{
    return m_Fatal;
}

inline
void CSuspect_rule_Base::SetFatal(CSuspect_rule_Base::TFatal value)
{
    m_Fatal = value;
    m_set_State[0] |= 0x3000;
}

inline
CSuspect_rule_Base::TFatal& CSuspect_rule_Base::SetFatal(void)
{
#ifdef _DEBUG
    if (!IsSetFatal()) {
        memset(&m_Fatal,UnassignedByte(),sizeof(m_Fatal));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Fatal;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_SUSPECT_RULE_BASE_HPP
