/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Rna_feat_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_RNA_FEAT_TYPE_BASE_HPP
#define OBJECTS_MACRO_RNA_FEAT_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRna_feat_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRna_feat_type_Base(void);
    // destructor
    virtual ~CRna_feat_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Any,
        e_PreRNA,
        e_MRNA,
        e_TRNA,
        e_RRNA,
        e_NcRNA,
        e_TmRNA,
        e_MiscRNA
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 9 ///< == e_MiscRNA+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TNcRNA;

    // getters
    // setters


    bool IsAny(void) const;
    void SetAny(void);


    bool IsPreRNA(void) const;
    void SetPreRNA(void);


    bool IsMRNA(void) const;
    void SetMRNA(void);


    bool IsTRNA(void) const;
    void SetTRNA(void);


    bool IsRRNA(void) const;
    void SetRRNA(void);

    // typedef string TNcRNA
    bool IsNcRNA(void) const;
    const TNcRNA& GetNcRNA(void) const;
    TNcRNA& SetNcRNA(void);
    void SetNcRNA(const TNcRNA& value);


    bool IsTmRNA(void) const;
    void SetTmRNA(void);


    bool IsMiscRNA(void) const;
    void SetMiscRNA(void);


private:
    // copy constructor and assignment operator
    CRna_feat_type_Base(const CRna_feat_type_Base& );
    CRna_feat_type_Base& operator=(const CRna_feat_type_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CRna_feat_type_Base::E_Choice CRna_feat_type_Base::Which(void) const
{
    return m_choice;
}

inline
void CRna_feat_type_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CRna_feat_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CRna_feat_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CRna_feat_type_Base::IsAny(void) const
{
    return m_choice == e_Any;
}

inline
void CRna_feat_type_Base::SetAny(void)
{
    Select(e_Any, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsPreRNA(void) const
{
    return m_choice == e_PreRNA;
}

inline
void CRna_feat_type_Base::SetPreRNA(void)
{
    Select(e_PreRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsMRNA(void) const
{
    return m_choice == e_MRNA;
}

inline
void CRna_feat_type_Base::SetMRNA(void)
{
    Select(e_MRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsTRNA(void) const
{
    return m_choice == e_TRNA;
}

inline
void CRna_feat_type_Base::SetTRNA(void)
{
    Select(e_TRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsRRNA(void) const
{
    return m_choice == e_RRNA;
}

inline
void CRna_feat_type_Base::SetRRNA(void)
{
    Select(e_RRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsNcRNA(void) const
{
    return m_choice == e_NcRNA;
}

inline
const CRna_feat_type_Base::TNcRNA& CRna_feat_type_Base::GetNcRNA(void) const
{
    CheckSelected(e_NcRNA);
    return *m_string;
}

inline
CRna_feat_type_Base::TNcRNA& CRna_feat_type_Base::SetNcRNA(void)
{
    Select(e_NcRNA, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CRna_feat_type_Base::IsTmRNA(void) const
{
    return m_choice == e_TmRNA;
}

inline
void CRna_feat_type_Base::SetTmRNA(void)
{
    Select(e_TmRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CRna_feat_type_Base::IsMiscRNA(void) const
{
    return m_choice == e_MiscRNA;
}

inline
void CRna_feat_type_Base::SetMiscRNA(void)
{
    Select(e_MiscRNA, NCBI_NS_NCBI::eDoNotResetVariant);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_RNA_FEAT_TYPE_BASE_HPP
