/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Replace_rule_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_REPLACE_RULE_BASE_HPP
#define OBJECTS_MACRO_REPLACE_RULE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CReplace_func;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CReplace_rule_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CReplace_rule_Base(void);
    // destructor
    virtual ~CReplace_rule_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CReplace_func TReplace_func;
    typedef bool TMove_to_note;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_replace_func,
        e_move_to_note
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CReplace_func TReplace_func
    ///  Check whether the Replace_func data member has been assigned a value.
    bool IsSetReplace_func(void) const;
    /// Check whether it is safe or not to call GetReplace_func method.
    bool CanGetReplace_func(void) const;
    void ResetReplace_func(void);
    const TReplace_func& GetReplace_func(void) const;
    void SetReplace_func(TReplace_func& value);
    TReplace_func& SetReplace_func(void);

    /// optional with default false
    /// typedef bool TMove_to_note
    ///  Check whether the Move_to_note data member has been assigned a value.
    bool IsSetMove_to_note(void) const;
    /// Check whether it is safe or not to call GetMove_to_note method.
    bool CanGetMove_to_note(void) const;
    void ResetMove_to_note(void);
    void SetDefaultMove_to_note(void);
    TMove_to_note GetMove_to_note(void) const;
    void SetMove_to_note(TMove_to_note value);
    TMove_to_note& SetMove_to_note(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CReplace_rule_Base(const CReplace_rule_Base&);
    CReplace_rule_Base& operator=(const CReplace_rule_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TReplace_func > m_Replace_func;
    bool m_Move_to_note;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CReplace_rule_Base::IsSetReplace_func(void) const
{
    return m_Replace_func.NotEmpty();
}

inline
bool CReplace_rule_Base::CanGetReplace_func(void) const
{
    return true;
}

inline
const CReplace_rule_Base::TReplace_func& CReplace_rule_Base::GetReplace_func(void) const
{
    if ( !m_Replace_func ) {
        const_cast<CReplace_rule_Base*>(this)->ResetReplace_func();
    }
    return (*m_Replace_func);
}

inline
CReplace_rule_Base::TReplace_func& CReplace_rule_Base::SetReplace_func(void)
{
    if ( !m_Replace_func ) {
        ResetReplace_func();
    }
    return (*m_Replace_func);
}

inline
bool CReplace_rule_Base::IsSetMove_to_note(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CReplace_rule_Base::CanGetMove_to_note(void) const
{
    return true;
}

inline
void CReplace_rule_Base::ResetMove_to_note(void)
{
    m_Move_to_note = false;
    m_set_State[0] &= ~0xc;
}

inline
void CReplace_rule_Base::SetDefaultMove_to_note(void)
{
    ResetMove_to_note();
}

inline
CReplace_rule_Base::TMove_to_note CReplace_rule_Base::GetMove_to_note(void) const
{
    return m_Move_to_note;
}

inline
void CReplace_rule_Base::SetMove_to_note(CReplace_rule_Base::TMove_to_note value)
{
    m_Move_to_note = value;
    m_set_State[0] |= 0xc;
}

inline
CReplace_rule_Base::TMove_to_note& CReplace_rule_Base::SetMove_to_note(void)
{
#ifdef _DEBUG
    if (!IsSetMove_to_note()) {
        memset(&m_Move_to_note,UnassignedByte(),sizeof(m_Move_to_note));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Move_to_note;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_REPLACE_RULE_BASE_HPP
