/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Parse_src_org_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_PARSE_SRC_ORG_BASE_HPP
#define OBJECTS_MACRO_PARSE_SRC_ORG_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Object_type_constraint.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CParse_src_org_choice;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CParse_src_org_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CParse_src_org_Base(void);
    // destructor
    virtual ~CParse_src_org_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CParse_src_org_choice TField;
    typedef EObject_type_constraint TType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field,
        e_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CParse_src_org_choice TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(TField& value);
    TField& SetField(void);

    /// optional with default eObject_type_constraint_any
    /// typedef EObject_type_constraint TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    void SetDefaultType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CParse_src_org_Base(const CParse_src_org_Base&);
    CParse_src_org_Base& operator=(const CParse_src_org_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TField > m_Field;
    EObject_type_constraint m_Type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CParse_src_org_Base::IsSetField(void) const
{
    return m_Field.NotEmpty();
}

inline
bool CParse_src_org_Base::CanGetField(void) const
{
    return true;
}

inline
const CParse_src_org_Base::TField& CParse_src_org_Base::GetField(void) const
{
    if ( !m_Field ) {
        const_cast<CParse_src_org_Base*>(this)->ResetField();
    }
    return (*m_Field);
}

inline
CParse_src_org_Base::TField& CParse_src_org_Base::SetField(void)
{
    if ( !m_Field ) {
        ResetField();
    }
    return (*m_Field);
}

inline
bool CParse_src_org_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CParse_src_org_Base::CanGetType(void) const
{
    return true;
}

inline
void CParse_src_org_Base::ResetType(void)
{
    m_Type = eObject_type_constraint_any;
    m_set_State[0] &= ~0xc;
}

inline
void CParse_src_org_Base::SetDefaultType(void)
{
    ResetType();
}

inline
CParse_src_org_Base::TType CParse_src_org_Base::GetType(void) const
{
    return m_Type;
}

inline
void CParse_src_org_Base::SetType(CParse_src_org_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CParse_src_org_Base::TType& CParse_src_org_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_PARSE_SRC_ORG_BASE_HPP
