/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Parse_src_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_PARSE_SRC_BASE_HPP
#define OBJECTS_MACRO_PARSE_SRC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CParse_src_general_id;
class CParse_src_org;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CParse_src_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CParse_src_Base(void);
    // destructor
    virtual ~CParse_src_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,         ///< No variant selected
        e_Defline,
        e_Flatfile,
        e_Local_id,
        e_Org,
        e_Comment,
        e_Bankit_comment,
        e_Structured_comment,
        e_File_id,
        e_General_id
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 10 ///< == e_General_id+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CParse_src_org TOrg;
    typedef string TStructured_comment;
    typedef CParse_src_general_id TGeneral_id;

    // getters
    // setters


    bool IsDefline(void) const;
    void SetDefline(void);


    bool IsFlatfile(void) const;
    void SetFlatfile(void);


    bool IsLocal_id(void) const;
    void SetLocal_id(void);

    // typedef CParse_src_org TOrg
    bool IsOrg(void) const;
    const TOrg& GetOrg(void) const;
    TOrg& SetOrg(void);
    void SetOrg(TOrg& value);


    bool IsComment(void) const;
    void SetComment(void);


    bool IsBankit_comment(void) const;
    void SetBankit_comment(void);

    // typedef string TStructured_comment
    bool IsStructured_comment(void) const;
    const TStructured_comment& GetStructured_comment(void) const;
    TStructured_comment& SetStructured_comment(void);
    void SetStructured_comment(const TStructured_comment& value);


    bool IsFile_id(void) const;
    void SetFile_id(void);

    // typedef CParse_src_general_id TGeneral_id
    bool IsGeneral_id(void) const;
    const TGeneral_id& GetGeneral_id(void) const;
    TGeneral_id& SetGeneral_id(void);
    void SetGeneral_id(TGeneral_id& value);


private:
    // copy constructor and assignment operator
    CParse_src_Base(const CParse_src_Base& );
    CParse_src_Base& operator=(const CParse_src_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CParse_src_Base::E_Choice CParse_src_Base::Which(void) const
{
    return m_choice;
}

inline
void CParse_src_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CParse_src_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CParse_src_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CParse_src_Base::IsDefline(void) const
{
    return m_choice == e_Defline;
}

inline
void CParse_src_Base::SetDefline(void)
{
    Select(e_Defline, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsFlatfile(void) const
{
    return m_choice == e_Flatfile;
}

inline
void CParse_src_Base::SetFlatfile(void)
{
    Select(e_Flatfile, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsLocal_id(void) const
{
    return m_choice == e_Local_id;
}

inline
void CParse_src_Base::SetLocal_id(void)
{
    Select(e_Local_id, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsOrg(void) const
{
    return m_choice == e_Org;
}

inline
bool CParse_src_Base::IsComment(void) const
{
    return m_choice == e_Comment;
}

inline
void CParse_src_Base::SetComment(void)
{
    Select(e_Comment, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsBankit_comment(void) const
{
    return m_choice == e_Bankit_comment;
}

inline
void CParse_src_Base::SetBankit_comment(void)
{
    Select(e_Bankit_comment, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsStructured_comment(void) const
{
    return m_choice == e_Structured_comment;
}

inline
const CParse_src_Base::TStructured_comment& CParse_src_Base::GetStructured_comment(void) const
{
    CheckSelected(e_Structured_comment);
    return *m_string;
}

inline
CParse_src_Base::TStructured_comment& CParse_src_Base::SetStructured_comment(void)
{
    Select(e_Structured_comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CParse_src_Base::IsFile_id(void) const
{
    return m_choice == e_File_id;
}

inline
void CParse_src_Base::SetFile_id(void)
{
    Select(e_File_id, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CParse_src_Base::IsGeneral_id(void) const
{
    return m_choice == e_General_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_PARSE_SRC_BASE_HPP
