/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Molinfo_field_pair_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MOLINFO_FIELD_PAIR_BASE_HPP
#define OBJECTS_MACRO_MOLINFO_FIELD_PAIR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMolinfo_completedness_pair;
class CMolinfo_mol_class_pair;
class CMolinfo_molecule_pair;
class CMolinfo_strand_pair;
class CMolinfo_technique_pair;
class CMolinfo_topology_pair;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMolinfo_field_pair_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolinfo_field_pair_Base(void);
    // destructor
    virtual ~CMolinfo_field_pair_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,    ///< No variant selected
        e_Molecule,
        e_Technique,
        e_Completedness,
        e_Mol_class,
        e_Topology,
        e_Strand
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 7 ///< == e_Strand+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CMolinfo_molecule_pair TMolecule;
    typedef CMolinfo_technique_pair TTechnique;
    typedef CMolinfo_completedness_pair TCompletedness;
    typedef CMolinfo_mol_class_pair TMol_class;
    typedef CMolinfo_topology_pair TTopology;
    typedef CMolinfo_strand_pair TStrand;

    // getters
    // setters

    // typedef CMolinfo_molecule_pair TMolecule
    bool IsMolecule(void) const;
    const TMolecule& GetMolecule(void) const;
    TMolecule& SetMolecule(void);
    void SetMolecule(TMolecule& value);

    // typedef CMolinfo_technique_pair TTechnique
    bool IsTechnique(void) const;
    const TTechnique& GetTechnique(void) const;
    TTechnique& SetTechnique(void);
    void SetTechnique(TTechnique& value);

    // typedef CMolinfo_completedness_pair TCompletedness
    bool IsCompletedness(void) const;
    const TCompletedness& GetCompletedness(void) const;
    TCompletedness& SetCompletedness(void);
    void SetCompletedness(TCompletedness& value);

    // typedef CMolinfo_mol_class_pair TMol_class
    bool IsMol_class(void) const;
    const TMol_class& GetMol_class(void) const;
    TMol_class& SetMol_class(void);
    void SetMol_class(TMol_class& value);

    // typedef CMolinfo_topology_pair TTopology
    bool IsTopology(void) const;
    const TTopology& GetTopology(void) const;
    TTopology& SetTopology(void);
    void SetTopology(TTopology& value);

    // typedef CMolinfo_strand_pair TStrand
    bool IsStrand(void) const;
    const TStrand& GetStrand(void) const;
    TStrand& SetStrand(void);
    void SetStrand(TStrand& value);


private:
    // copy constructor and assignment operator
    CMolinfo_field_pair_Base(const CMolinfo_field_pair_Base& );
    CMolinfo_field_pair_Base& operator=(const CMolinfo_field_pair_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMolinfo_field_pair_Base::E_Choice CMolinfo_field_pair_Base::Which(void) const
{
    return m_choice;
}

inline
void CMolinfo_field_pair_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMolinfo_field_pair_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMolinfo_field_pair_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMolinfo_field_pair_Base::IsMolecule(void) const
{
    return m_choice == e_Molecule;
}

inline
bool CMolinfo_field_pair_Base::IsTechnique(void) const
{
    return m_choice == e_Technique;
}

inline
bool CMolinfo_field_pair_Base::IsCompletedness(void) const
{
    return m_choice == e_Completedness;
}

inline
bool CMolinfo_field_pair_Base::IsMol_class(void) const
{
    return m_choice == e_Mol_class;
}

inline
bool CMolinfo_field_pair_Base::IsTopology(void) const
{
    return m_choice == e_Topology;
}

inline
bool CMolinfo_field_pair_Base::IsStrand(void) const
{
    return m_choice == e_Strand;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MOLINFO_FIELD_PAIR_BASE_HPP
