/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Macro_action_choice_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MACRO_ACTION_CHOICE_BASE_HPP
#define OBJECTS_MACRO_MACRO_ACTION_CHOICE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAECR_action;
class CAdd_descriptor_list_action;
class CAdjust_features_for_gaps_action;
class CApply_feature_action;
class CApply_table_action;
class CAuthor_fix_action;
class CAutodef_action;
class CAutofix_action;
class CConvert_feature_action;
class CCreate_TSA_ids_action;
class CEdit_feature_location_action;
class CFix_caps_action;
class CFix_format_action;
class CFix_pub_caps_action;
class CFix_sets_action;
class CMake_gene_xref_action;
class CMolinfo_block;
class CParse_action;
class CRemove_descriptor_action;
class CRemove_duplicate_feature_action;
class CRemove_feature_action;
class CRemove_sequences_action;
class CRemove_xrefs_action;
class CRetranslate_cds_action;
class CSort_fields_action;
class CUpdate_replaced_ec_numbers_action;
class CUpdate_sequences_action;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMacro_action_choice_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMacro_action_choice_Base(void);
    // destructor
    virtual ~CMacro_action_choice_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,                           ///< No variant selected
        e_Aecr,
        e_Parse,
        e_Add_feature,
        e_Remove_feature,
        e_Convert_feature,
        e_Edit_location,
        e_Remove_descriptor,
        e_Autodef,
        e_Removesets,
        e_Trim_junk_from_primer_seq,
        e_Trim_stop_from_complete_cds,
        e_Fix_usa_and_states,
        e_Synchronize_cds_partials,
        e_Adjust_for_consensus_splice,
        e_Fix_pub_caps,
        e_Remove_seg_gaps,
        e_Sort_fields,
        e_Apply_molinfo_block,
        e_Fix_caps,
        e_Fix_format,
        e_Fix_spell,
        e_Remove_duplicate_features,
        e_Remove_lineage_notes,
        e_Remove_xrefs,
        e_Make_gene_xrefs,
        e_Make_bold_xrefs,
        e_Fix_author,
        e_Update_sequences,
        e_Add_trans_splicing,
        e_Remove_invalid_ecnumbers,
        e_Create_tsa_ids,
        e_Perform_autofix,
        e_Fix_sets,
        e_Apply_table,
        e_Remove_sequences,
        e_Propagate_sequence_technology,
        e_Add_file_descriptors,
        e_Propagate_missing_old_name,
        e_Autoapply_structured_comments,
        e_Reorder_structured_comments,
        e_Remove_duplicate_structured_comments,
        e_Lookup_taxonomy,
        e_Lookup_pubs,
        e_Trim_terminal_ns,
        e_Update_replaced_ecnumbers,
        e_Instantiate_protein_titles,
        e_Retranslate_cds,
        e_Add_selenocysteine_except,
        e_Join_short_trnas,
        e_Adjust_features_for_gaps
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 51 ///< == e_Adjust_features_for_gaps+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CAECR_action TAecr;
    typedef CParse_action TParse;
    typedef CApply_feature_action TAdd_feature;
    typedef CRemove_feature_action TRemove_feature;
    typedef CConvert_feature_action TConvert_feature;
    typedef CEdit_feature_location_action TEdit_location;
    typedef CRemove_descriptor_action TRemove_descriptor;
    typedef CAutodef_action TAutodef;
    typedef CFix_pub_caps_action TFix_pub_caps;
    typedef CSort_fields_action TSort_fields;
    typedef CMolinfo_block TApply_molinfo_block;
    typedef CFix_caps_action TFix_caps;
    typedef CFix_format_action TFix_format;
    typedef CRemove_duplicate_feature_action TRemove_duplicate_features;
    typedef CRemove_xrefs_action TRemove_xrefs;
    typedef CMake_gene_xref_action TMake_gene_xrefs;
    typedef CAuthor_fix_action TFix_author;
    typedef CUpdate_sequences_action TUpdate_sequences;
    typedef CCreate_TSA_ids_action TCreate_tsa_ids;
    typedef CAutofix_action TPerform_autofix;
    typedef CFix_sets_action TFix_sets;
    typedef CApply_table_action TApply_table;
    typedef CRemove_sequences_action TRemove_sequences;
    typedef CAdd_descriptor_list_action TAdd_file_descriptors;
    typedef CUpdate_replaced_ec_numbers_action TUpdate_replaced_ecnumbers;
    typedef CRetranslate_cds_action TRetranslate_cds;
    typedef CAdjust_features_for_gaps_action TAdjust_features_for_gaps;

    // getters
    // setters

    // typedef CAECR_action TAecr
    bool IsAecr(void) const;
    const TAecr& GetAecr(void) const;
    TAecr& SetAecr(void);
    void SetAecr(TAecr& value);

    // typedef CParse_action TParse
    bool IsParse(void) const;
    const TParse& GetParse(void) const;
    TParse& SetParse(void);
    void SetParse(TParse& value);

    // typedef CApply_feature_action TAdd_feature
    bool IsAdd_feature(void) const;
    const TAdd_feature& GetAdd_feature(void) const;
    TAdd_feature& SetAdd_feature(void);
    void SetAdd_feature(TAdd_feature& value);

    // typedef CRemove_feature_action TRemove_feature
    bool IsRemove_feature(void) const;
    const TRemove_feature& GetRemove_feature(void) const;
    TRemove_feature& SetRemove_feature(void);
    void SetRemove_feature(TRemove_feature& value);

    // typedef CConvert_feature_action TConvert_feature
    bool IsConvert_feature(void) const;
    const TConvert_feature& GetConvert_feature(void) const;
    TConvert_feature& SetConvert_feature(void);
    void SetConvert_feature(TConvert_feature& value);

    // typedef CEdit_feature_location_action TEdit_location
    bool IsEdit_location(void) const;
    const TEdit_location& GetEdit_location(void) const;
    TEdit_location& SetEdit_location(void);
    void SetEdit_location(TEdit_location& value);

    // typedef CRemove_descriptor_action TRemove_descriptor
    bool IsRemove_descriptor(void) const;
    const TRemove_descriptor& GetRemove_descriptor(void) const;
    TRemove_descriptor& SetRemove_descriptor(void);
    void SetRemove_descriptor(TRemove_descriptor& value);

    // typedef CAutodef_action TAutodef
    bool IsAutodef(void) const;
    const TAutodef& GetAutodef(void) const;
    TAutodef& SetAutodef(void);
    void SetAutodef(TAutodef& value);


    bool IsRemovesets(void) const;
    void SetRemovesets(void);


    bool IsTrim_junk_from_primer_seq(void) const;
    void SetTrim_junk_from_primer_seq(void);


    bool IsTrim_stop_from_complete_cds(void) const;
    void SetTrim_stop_from_complete_cds(void);


    bool IsFix_usa_and_states(void) const;
    void SetFix_usa_and_states(void);


    bool IsSynchronize_cds_partials(void) const;
    void SetSynchronize_cds_partials(void);


    bool IsAdjust_for_consensus_splice(void) const;
    void SetAdjust_for_consensus_splice(void);

    // typedef CFix_pub_caps_action TFix_pub_caps
    bool IsFix_pub_caps(void) const;
    const TFix_pub_caps& GetFix_pub_caps(void) const;
    TFix_pub_caps& SetFix_pub_caps(void);
    void SetFix_pub_caps(TFix_pub_caps& value);


    bool IsRemove_seg_gaps(void) const;
    void SetRemove_seg_gaps(void);

    // typedef CSort_fields_action TSort_fields
    bool IsSort_fields(void) const;
    const TSort_fields& GetSort_fields(void) const;
    TSort_fields& SetSort_fields(void);
    void SetSort_fields(TSort_fields& value);

    // typedef CMolinfo_block TApply_molinfo_block
    bool IsApply_molinfo_block(void) const;
    const TApply_molinfo_block& GetApply_molinfo_block(void) const;
    TApply_molinfo_block& SetApply_molinfo_block(void);
    void SetApply_molinfo_block(TApply_molinfo_block& value);

    // typedef CFix_caps_action TFix_caps
    bool IsFix_caps(void) const;
    const TFix_caps& GetFix_caps(void) const;
    TFix_caps& SetFix_caps(void);
    void SetFix_caps(TFix_caps& value);

    // typedef CFix_format_action TFix_format
    bool IsFix_format(void) const;
    const TFix_format& GetFix_format(void) const;
    TFix_format& SetFix_format(void);
    void SetFix_format(TFix_format& value);


    bool IsFix_spell(void) const;
    void SetFix_spell(void);

    // typedef CRemove_duplicate_feature_action TRemove_duplicate_features
    bool IsRemove_duplicate_features(void) const;
    const TRemove_duplicate_features& GetRemove_duplicate_features(void) const;
    TRemove_duplicate_features& SetRemove_duplicate_features(void);
    void SetRemove_duplicate_features(TRemove_duplicate_features& value);


    bool IsRemove_lineage_notes(void) const;
    void SetRemove_lineage_notes(void);

    // typedef CRemove_xrefs_action TRemove_xrefs
    bool IsRemove_xrefs(void) const;
    const TRemove_xrefs& GetRemove_xrefs(void) const;
    TRemove_xrefs& SetRemove_xrefs(void);
    void SetRemove_xrefs(TRemove_xrefs& value);

    // typedef CMake_gene_xref_action TMake_gene_xrefs
    bool IsMake_gene_xrefs(void) const;
    const TMake_gene_xrefs& GetMake_gene_xrefs(void) const;
    TMake_gene_xrefs& SetMake_gene_xrefs(void);
    void SetMake_gene_xrefs(TMake_gene_xrefs& value);


    bool IsMake_bold_xrefs(void) const;
    void SetMake_bold_xrefs(void);

    // typedef CAuthor_fix_action TFix_author
    bool IsFix_author(void) const;
    const TFix_author& GetFix_author(void) const;
    TFix_author& SetFix_author(void);
    void SetFix_author(TFix_author& value);

    // typedef CUpdate_sequences_action TUpdate_sequences
    bool IsUpdate_sequences(void) const;
    const TUpdate_sequences& GetUpdate_sequences(void) const;
    TUpdate_sequences& SetUpdate_sequences(void);
    void SetUpdate_sequences(TUpdate_sequences& value);


    bool IsAdd_trans_splicing(void) const;
    void SetAdd_trans_splicing(void);


    bool IsRemove_invalid_ecnumbers(void) const;
    void SetRemove_invalid_ecnumbers(void);

    // typedef CCreate_TSA_ids_action TCreate_tsa_ids
    bool IsCreate_tsa_ids(void) const;
    const TCreate_tsa_ids& GetCreate_tsa_ids(void) const;
    TCreate_tsa_ids& SetCreate_tsa_ids(void);
    void SetCreate_tsa_ids(TCreate_tsa_ids& value);

    // typedef CAutofix_action TPerform_autofix
    bool IsPerform_autofix(void) const;
    const TPerform_autofix& GetPerform_autofix(void) const;
    TPerform_autofix& SetPerform_autofix(void);
    void SetPerform_autofix(TPerform_autofix& value);

    // typedef CFix_sets_action TFix_sets
    bool IsFix_sets(void) const;
    const TFix_sets& GetFix_sets(void) const;
    TFix_sets& SetFix_sets(void);
    void SetFix_sets(TFix_sets& value);

    // typedef CApply_table_action TApply_table
    bool IsApply_table(void) const;
    const TApply_table& GetApply_table(void) const;
    TApply_table& SetApply_table(void);
    void SetApply_table(TApply_table& value);

    // typedef CRemove_sequences_action TRemove_sequences
    bool IsRemove_sequences(void) const;
    const TRemove_sequences& GetRemove_sequences(void) const;
    TRemove_sequences& SetRemove_sequences(void);
    void SetRemove_sequences(TRemove_sequences& value);


    bool IsPropagate_sequence_technology(void) const;
    void SetPropagate_sequence_technology(void);

    // typedef CAdd_descriptor_list_action TAdd_file_descriptors
    bool IsAdd_file_descriptors(void) const;
    const TAdd_file_descriptors& GetAdd_file_descriptors(void) const;
    TAdd_file_descriptors& SetAdd_file_descriptors(void);
    void SetAdd_file_descriptors(TAdd_file_descriptors& value);


    bool IsPropagate_missing_old_name(void) const;
    void SetPropagate_missing_old_name(void);


    bool IsAutoapply_structured_comments(void) const;
    void SetAutoapply_structured_comments(void);


    bool IsReorder_structured_comments(void) const;
    void SetReorder_structured_comments(void);


    bool IsRemove_duplicate_structured_comments(void) const;
    void SetRemove_duplicate_structured_comments(void);


    bool IsLookup_taxonomy(void) const;
    void SetLookup_taxonomy(void);


    bool IsLookup_pubs(void) const;
    void SetLookup_pubs(void);


    bool IsTrim_terminal_ns(void) const;
    void SetTrim_terminal_ns(void);

    // typedef CUpdate_replaced_ec_numbers_action TUpdate_replaced_ecnumbers
    bool IsUpdate_replaced_ecnumbers(void) const;
    const TUpdate_replaced_ecnumbers& GetUpdate_replaced_ecnumbers(void) const;
    TUpdate_replaced_ecnumbers& SetUpdate_replaced_ecnumbers(void);
    void SetUpdate_replaced_ecnumbers(TUpdate_replaced_ecnumbers& value);


    bool IsInstantiate_protein_titles(void) const;
    void SetInstantiate_protein_titles(void);

    // typedef CRetranslate_cds_action TRetranslate_cds
    bool IsRetranslate_cds(void) const;
    const TRetranslate_cds& GetRetranslate_cds(void) const;
    TRetranslate_cds& SetRetranslate_cds(void);
    void SetRetranslate_cds(TRetranslate_cds& value);


    bool IsAdd_selenocysteine_except(void) const;
    void SetAdd_selenocysteine_except(void);


    bool IsJoin_short_trnas(void) const;
    void SetJoin_short_trnas(void);

    // typedef CAdjust_features_for_gaps_action TAdjust_features_for_gaps
    bool IsAdjust_features_for_gaps(void) const;
    const TAdjust_features_for_gaps& GetAdjust_features_for_gaps(void) const;
    TAdjust_features_for_gaps& SetAdjust_features_for_gaps(void);
    void SetAdjust_features_for_gaps(TAdjust_features_for_gaps& value);


private:
    // copy constructor and assignment operator
    CMacro_action_choice_Base(const CMacro_action_choice_Base& );
    CMacro_action_choice_Base& operator=(const CMacro_action_choice_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMacro_action_choice_Base::E_Choice CMacro_action_choice_Base::Which(void) const
{
    return m_choice;
}

inline
void CMacro_action_choice_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMacro_action_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMacro_action_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMacro_action_choice_Base::IsAecr(void) const
{
    return m_choice == e_Aecr;
}

inline
bool CMacro_action_choice_Base::IsParse(void) const
{
    return m_choice == e_Parse;
}

inline
bool CMacro_action_choice_Base::IsAdd_feature(void) const
{
    return m_choice == e_Add_feature;
}

inline
bool CMacro_action_choice_Base::IsRemove_feature(void) const
{
    return m_choice == e_Remove_feature;
}

inline
bool CMacro_action_choice_Base::IsConvert_feature(void) const
{
    return m_choice == e_Convert_feature;
}

inline
bool CMacro_action_choice_Base::IsEdit_location(void) const
{
    return m_choice == e_Edit_location;
}

inline
bool CMacro_action_choice_Base::IsRemove_descriptor(void) const
{
    return m_choice == e_Remove_descriptor;
}

inline
bool CMacro_action_choice_Base::IsAutodef(void) const
{
    return m_choice == e_Autodef;
}

inline
bool CMacro_action_choice_Base::IsRemovesets(void) const
{
    return m_choice == e_Removesets;
}

inline
void CMacro_action_choice_Base::SetRemovesets(void)
{
    Select(e_Removesets, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsTrim_junk_from_primer_seq(void) const
{
    return m_choice == e_Trim_junk_from_primer_seq;
}

inline
void CMacro_action_choice_Base::SetTrim_junk_from_primer_seq(void)
{
    Select(e_Trim_junk_from_primer_seq, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsTrim_stop_from_complete_cds(void) const
{
    return m_choice == e_Trim_stop_from_complete_cds;
}

inline
void CMacro_action_choice_Base::SetTrim_stop_from_complete_cds(void)
{
    Select(e_Trim_stop_from_complete_cds, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsFix_usa_and_states(void) const
{
    return m_choice == e_Fix_usa_and_states;
}

inline
void CMacro_action_choice_Base::SetFix_usa_and_states(void)
{
    Select(e_Fix_usa_and_states, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsSynchronize_cds_partials(void) const
{
    return m_choice == e_Synchronize_cds_partials;
}

inline
void CMacro_action_choice_Base::SetSynchronize_cds_partials(void)
{
    Select(e_Synchronize_cds_partials, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsAdjust_for_consensus_splice(void) const
{
    return m_choice == e_Adjust_for_consensus_splice;
}

inline
void CMacro_action_choice_Base::SetAdjust_for_consensus_splice(void)
{
    Select(e_Adjust_for_consensus_splice, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsFix_pub_caps(void) const
{
    return m_choice == e_Fix_pub_caps;
}

inline
bool CMacro_action_choice_Base::IsRemove_seg_gaps(void) const
{
    return m_choice == e_Remove_seg_gaps;
}

inline
void CMacro_action_choice_Base::SetRemove_seg_gaps(void)
{
    Select(e_Remove_seg_gaps, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsSort_fields(void) const
{
    return m_choice == e_Sort_fields;
}

inline
bool CMacro_action_choice_Base::IsApply_molinfo_block(void) const
{
    return m_choice == e_Apply_molinfo_block;
}

inline
bool CMacro_action_choice_Base::IsFix_caps(void) const
{
    return m_choice == e_Fix_caps;
}

inline
bool CMacro_action_choice_Base::IsFix_format(void) const
{
    return m_choice == e_Fix_format;
}

inline
bool CMacro_action_choice_Base::IsFix_spell(void) const
{
    return m_choice == e_Fix_spell;
}

inline
void CMacro_action_choice_Base::SetFix_spell(void)
{
    Select(e_Fix_spell, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsRemove_duplicate_features(void) const
{
    return m_choice == e_Remove_duplicate_features;
}

inline
bool CMacro_action_choice_Base::IsRemove_lineage_notes(void) const
{
    return m_choice == e_Remove_lineage_notes;
}

inline
void CMacro_action_choice_Base::SetRemove_lineage_notes(void)
{
    Select(e_Remove_lineage_notes, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsRemove_xrefs(void) const
{
    return m_choice == e_Remove_xrefs;
}

inline
bool CMacro_action_choice_Base::IsMake_gene_xrefs(void) const
{
    return m_choice == e_Make_gene_xrefs;
}

inline
bool CMacro_action_choice_Base::IsMake_bold_xrefs(void) const
{
    return m_choice == e_Make_bold_xrefs;
}

inline
void CMacro_action_choice_Base::SetMake_bold_xrefs(void)
{
    Select(e_Make_bold_xrefs, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsFix_author(void) const
{
    return m_choice == e_Fix_author;
}

inline
bool CMacro_action_choice_Base::IsUpdate_sequences(void) const
{
    return m_choice == e_Update_sequences;
}

inline
bool CMacro_action_choice_Base::IsAdd_trans_splicing(void) const
{
    return m_choice == e_Add_trans_splicing;
}

inline
void CMacro_action_choice_Base::SetAdd_trans_splicing(void)
{
    Select(e_Add_trans_splicing, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsRemove_invalid_ecnumbers(void) const
{
    return m_choice == e_Remove_invalid_ecnumbers;
}

inline
void CMacro_action_choice_Base::SetRemove_invalid_ecnumbers(void)
{
    Select(e_Remove_invalid_ecnumbers, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsCreate_tsa_ids(void) const
{
    return m_choice == e_Create_tsa_ids;
}

inline
bool CMacro_action_choice_Base::IsPerform_autofix(void) const
{
    return m_choice == e_Perform_autofix;
}

inline
bool CMacro_action_choice_Base::IsFix_sets(void) const
{
    return m_choice == e_Fix_sets;
}

inline
bool CMacro_action_choice_Base::IsApply_table(void) const
{
    return m_choice == e_Apply_table;
}

inline
bool CMacro_action_choice_Base::IsRemove_sequences(void) const
{
    return m_choice == e_Remove_sequences;
}

inline
bool CMacro_action_choice_Base::IsPropagate_sequence_technology(void) const
{
    return m_choice == e_Propagate_sequence_technology;
}

inline
void CMacro_action_choice_Base::SetPropagate_sequence_technology(void)
{
    Select(e_Propagate_sequence_technology, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsAdd_file_descriptors(void) const
{
    return m_choice == e_Add_file_descriptors;
}

inline
bool CMacro_action_choice_Base::IsPropagate_missing_old_name(void) const
{
    return m_choice == e_Propagate_missing_old_name;
}

inline
void CMacro_action_choice_Base::SetPropagate_missing_old_name(void)
{
    Select(e_Propagate_missing_old_name, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsAutoapply_structured_comments(void) const
{
    return m_choice == e_Autoapply_structured_comments;
}

inline
void CMacro_action_choice_Base::SetAutoapply_structured_comments(void)
{
    Select(e_Autoapply_structured_comments, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsReorder_structured_comments(void) const
{
    return m_choice == e_Reorder_structured_comments;
}

inline
void CMacro_action_choice_Base::SetReorder_structured_comments(void)
{
    Select(e_Reorder_structured_comments, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsRemove_duplicate_structured_comments(void) const
{
    return m_choice == e_Remove_duplicate_structured_comments;
}

inline
void CMacro_action_choice_Base::SetRemove_duplicate_structured_comments(void)
{
    Select(e_Remove_duplicate_structured_comments, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsLookup_taxonomy(void) const
{
    return m_choice == e_Lookup_taxonomy;
}

inline
void CMacro_action_choice_Base::SetLookup_taxonomy(void)
{
    Select(e_Lookup_taxonomy, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsLookup_pubs(void) const
{
    return m_choice == e_Lookup_pubs;
}

inline
void CMacro_action_choice_Base::SetLookup_pubs(void)
{
    Select(e_Lookup_pubs, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsTrim_terminal_ns(void) const
{
    return m_choice == e_Trim_terminal_ns;
}

inline
void CMacro_action_choice_Base::SetTrim_terminal_ns(void)
{
    Select(e_Trim_terminal_ns, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsUpdate_replaced_ecnumbers(void) const
{
    return m_choice == e_Update_replaced_ecnumbers;
}

inline
bool CMacro_action_choice_Base::IsInstantiate_protein_titles(void) const
{
    return m_choice == e_Instantiate_protein_titles;
}

inline
void CMacro_action_choice_Base::SetInstantiate_protein_titles(void)
{
    Select(e_Instantiate_protein_titles, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsRetranslate_cds(void) const
{
    return m_choice == e_Retranslate_cds;
}

inline
bool CMacro_action_choice_Base::IsAdd_selenocysteine_except(void) const
{
    return m_choice == e_Add_selenocysteine_except;
}

inline
void CMacro_action_choice_Base::SetAdd_selenocysteine_except(void)
{
    Select(e_Add_selenocysteine_except, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsJoin_short_trnas(void) const
{
    return m_choice == e_Join_short_trnas;
}

inline
void CMacro_action_choice_Base::SetJoin_short_trnas(void)
{
    Select(e_Join_short_trnas, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMacro_action_choice_Base::IsAdjust_features_for_gaps(void) const
{
    return m_choice == e_Adjust_features_for_gaps;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MACRO_ACTION_CHOICE_BASE_HPP
