/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Location_pos_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_LOCATION_POS_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_LOCATION_POS_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CLocation_pos_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLocation_pos_constraint_Base(void);
    // destructor
    virtual ~CLocation_pos_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,        ///< No variant selected
        e_Dist_from_end,
        e_Max_dist_from_end,
        e_Min_dist_from_end
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Min_dist_from_end+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef int TDist_from_end;
    typedef int TMax_dist_from_end;
    typedef int TMin_dist_from_end;

    // getters
    // setters

    // typedef int TDist_from_end
    bool IsDist_from_end(void) const;
    TDist_from_end GetDist_from_end(void) const;
    TDist_from_end& SetDist_from_end(void);
    void SetDist_from_end(TDist_from_end value);

    // typedef int TMax_dist_from_end
    bool IsMax_dist_from_end(void) const;
    TMax_dist_from_end GetMax_dist_from_end(void) const;
    TMax_dist_from_end& SetMax_dist_from_end(void);
    void SetMax_dist_from_end(TMax_dist_from_end value);

    // typedef int TMin_dist_from_end
    bool IsMin_dist_from_end(void) const;
    TMin_dist_from_end GetMin_dist_from_end(void) const;
    TMin_dist_from_end& SetMin_dist_from_end(void);
    void SetMin_dist_from_end(TMin_dist_from_end value);


private:
    // copy constructor and assignment operator
    CLocation_pos_constraint_Base(const CLocation_pos_constraint_Base& );
    CLocation_pos_constraint_Base& operator=(const CLocation_pos_constraint_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TDist_from_end m_Dist_from_end;
        TMax_dist_from_end m_Max_dist_from_end;
        TMin_dist_from_end m_Min_dist_from_end;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CLocation_pos_constraint_Base::E_Choice CLocation_pos_constraint_Base::Which(void) const
{
    return m_choice;
}

inline
void CLocation_pos_constraint_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLocation_pos_constraint_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLocation_pos_constraint_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLocation_pos_constraint_Base::IsDist_from_end(void) const
{
    return m_choice == e_Dist_from_end;
}

inline
CLocation_pos_constraint_Base::TDist_from_end CLocation_pos_constraint_Base::GetDist_from_end(void) const
{
    CheckSelected(e_Dist_from_end);
    return m_Dist_from_end;
}

inline
CLocation_pos_constraint_Base::TDist_from_end& CLocation_pos_constraint_Base::SetDist_from_end(void)
{
    Select(e_Dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Dist_from_end;
}

inline
void CLocation_pos_constraint_Base::SetDist_from_end(CLocation_pos_constraint_Base::TDist_from_end value)
{
    Select(e_Dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Dist_from_end = value;
}

inline
bool CLocation_pos_constraint_Base::IsMax_dist_from_end(void) const
{
    return m_choice == e_Max_dist_from_end;
}

inline
CLocation_pos_constraint_Base::TMax_dist_from_end CLocation_pos_constraint_Base::GetMax_dist_from_end(void) const
{
    CheckSelected(e_Max_dist_from_end);
    return m_Max_dist_from_end;
}

inline
CLocation_pos_constraint_Base::TMax_dist_from_end& CLocation_pos_constraint_Base::SetMax_dist_from_end(void)
{
    Select(e_Max_dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Max_dist_from_end;
}

inline
void CLocation_pos_constraint_Base::SetMax_dist_from_end(CLocation_pos_constraint_Base::TMax_dist_from_end value)
{
    Select(e_Max_dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Max_dist_from_end = value;
}

inline
bool CLocation_pos_constraint_Base::IsMin_dist_from_end(void) const
{
    return m_choice == e_Min_dist_from_end;
}

inline
CLocation_pos_constraint_Base::TMin_dist_from_end CLocation_pos_constraint_Base::GetMin_dist_from_end(void) const
{
    CheckSelected(e_Min_dist_from_end);
    return m_Min_dist_from_end;
}

inline
CLocation_pos_constraint_Base::TMin_dist_from_end& CLocation_pos_constraint_Base::SetMin_dist_from_end(void)
{
    Select(e_Min_dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Min_dist_from_end;
}

inline
void CLocation_pos_constraint_Base::SetMin_dist_from_end(CLocation_pos_constraint_Base::TMin_dist_from_end value)
{
    Select(e_Min_dist_from_end, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Min_dist_from_end = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_LOCATION_POS_CONSTRAINT_BASE_HPP
