/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Location_edit_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_LOCATION_EDIT_TYPE_BASE_HPP
#define OBJECTS_MACRO_LOCATION_EDIT_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Convert_location_type.hpp>
#include <objects/macro/Partial_3_clear_constraint.hpp>
#include <objects/macro/Partial_5_clear_constraint.hpp>
#include <objects/macro/Partial_both_clear_constra.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CEdit_location_strand;
class CExtend_to_feature;
class CPartial_3_set_action;
class CPartial_5_set_action;
class CPartial_both_set_action;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CLocation_edit_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLocation_edit_type_Base(void);
    // destructor
    virtual ~CLocation_edit_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,         ///< No variant selected
        e_Strand,
        e_Set_5_partial,
        e_Clear_5_partial,
        e_Set_3_partial,
        e_Clear_3_partial,
        e_Set_both_partial,
        e_Clear_both_partial,
        e_Convert,
        e_Extend_5,
        e_Extend_3,
        e_Extend_5_to_feat,
        e_Extend_3_to_feat
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 13 ///< == e_Extend_3_to_feat+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CEdit_location_strand TStrand;
    typedef CPartial_5_set_action TSet_5_partial;
    typedef EPartial_5_clear_constraint TClear_5_partial;
    typedef CPartial_3_set_action TSet_3_partial;
    typedef EPartial_3_clear_constraint TClear_3_partial;
    typedef CPartial_both_set_action TSet_both_partial;
    typedef EPartial_both_clear_constraint TClear_both_partial;
    typedef EConvert_location_type TConvert;
    typedef CExtend_to_feature TExtend_5_to_feat;
    typedef CExtend_to_feature TExtend_3_to_feat;

    // getters
    // setters

    // typedef CEdit_location_strand TStrand
    bool IsStrand(void) const;
    const TStrand& GetStrand(void) const;
    TStrand& SetStrand(void);
    void SetStrand(TStrand& value);

    // typedef CPartial_5_set_action TSet_5_partial
    bool IsSet_5_partial(void) const;
    const TSet_5_partial& GetSet_5_partial(void) const;
    TSet_5_partial& SetSet_5_partial(void);
    void SetSet_5_partial(TSet_5_partial& value);

    // typedef EPartial_5_clear_constraint TClear_5_partial
    bool IsClear_5_partial(void) const;
    TClear_5_partial GetClear_5_partial(void) const;
    TClear_5_partial& SetClear_5_partial(void);
    void SetClear_5_partial(TClear_5_partial value);

    // typedef CPartial_3_set_action TSet_3_partial
    bool IsSet_3_partial(void) const;
    const TSet_3_partial& GetSet_3_partial(void) const;
    TSet_3_partial& SetSet_3_partial(void);
    void SetSet_3_partial(TSet_3_partial& value);

    // typedef EPartial_3_clear_constraint TClear_3_partial
    bool IsClear_3_partial(void) const;
    TClear_3_partial GetClear_3_partial(void) const;
    TClear_3_partial& SetClear_3_partial(void);
    void SetClear_3_partial(TClear_3_partial value);

    // typedef CPartial_both_set_action TSet_both_partial
    bool IsSet_both_partial(void) const;
    const TSet_both_partial& GetSet_both_partial(void) const;
    TSet_both_partial& SetSet_both_partial(void);
    void SetSet_both_partial(TSet_both_partial& value);

    // typedef EPartial_both_clear_constraint TClear_both_partial
    bool IsClear_both_partial(void) const;
    TClear_both_partial GetClear_both_partial(void) const;
    TClear_both_partial& SetClear_both_partial(void);
    void SetClear_both_partial(TClear_both_partial value);

    // typedef EConvert_location_type TConvert
    bool IsConvert(void) const;
    TConvert GetConvert(void) const;
    TConvert& SetConvert(void);
    void SetConvert(TConvert value);


    bool IsExtend_5(void) const;
    void SetExtend_5(void);


    bool IsExtend_3(void) const;
    void SetExtend_3(void);

    // typedef CExtend_to_feature TExtend_5_to_feat
    bool IsExtend_5_to_feat(void) const;
    const TExtend_5_to_feat& GetExtend_5_to_feat(void) const;
    TExtend_5_to_feat& SetExtend_5_to_feat(void);
    void SetExtend_5_to_feat(TExtend_5_to_feat& value);

    // typedef CExtend_to_feature TExtend_3_to_feat
    bool IsExtend_3_to_feat(void) const;
    const TExtend_3_to_feat& GetExtend_3_to_feat(void) const;
    TExtend_3_to_feat& SetExtend_3_to_feat(void);
    void SetExtend_3_to_feat(TExtend_3_to_feat& value);


private:
    // copy constructor and assignment operator
    CLocation_edit_type_Base(const CLocation_edit_type_Base& );
    CLocation_edit_type_Base& operator=(const CLocation_edit_type_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TClear_5_partial m_Clear_5_partial;
        TClear_3_partial m_Clear_3_partial;
        TClear_both_partial m_Clear_both_partial;
        TConvert m_Convert;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CLocation_edit_type_Base::E_Choice CLocation_edit_type_Base::Which(void) const
{
    return m_choice;
}

inline
void CLocation_edit_type_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLocation_edit_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLocation_edit_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLocation_edit_type_Base::IsStrand(void) const
{
    return m_choice == e_Strand;
}

inline
bool CLocation_edit_type_Base::IsSet_5_partial(void) const
{
    return m_choice == e_Set_5_partial;
}

inline
bool CLocation_edit_type_Base::IsClear_5_partial(void) const
{
    return m_choice == e_Clear_5_partial;
}

inline
CLocation_edit_type_Base::TClear_5_partial CLocation_edit_type_Base::GetClear_5_partial(void) const
{
    CheckSelected(e_Clear_5_partial);
    return m_Clear_5_partial;
}

inline
CLocation_edit_type_Base::TClear_5_partial& CLocation_edit_type_Base::SetClear_5_partial(void)
{
    Select(e_Clear_5_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Clear_5_partial;
}

inline
void CLocation_edit_type_Base::SetClear_5_partial(CLocation_edit_type_Base::TClear_5_partial value)
{
    Select(e_Clear_5_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Clear_5_partial = value;
}

inline
bool CLocation_edit_type_Base::IsSet_3_partial(void) const
{
    return m_choice == e_Set_3_partial;
}

inline
bool CLocation_edit_type_Base::IsClear_3_partial(void) const
{
    return m_choice == e_Clear_3_partial;
}

inline
CLocation_edit_type_Base::TClear_3_partial CLocation_edit_type_Base::GetClear_3_partial(void) const
{
    CheckSelected(e_Clear_3_partial);
    return m_Clear_3_partial;
}

inline
CLocation_edit_type_Base::TClear_3_partial& CLocation_edit_type_Base::SetClear_3_partial(void)
{
    Select(e_Clear_3_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Clear_3_partial;
}

inline
void CLocation_edit_type_Base::SetClear_3_partial(CLocation_edit_type_Base::TClear_3_partial value)
{
    Select(e_Clear_3_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Clear_3_partial = value;
}

inline
bool CLocation_edit_type_Base::IsSet_both_partial(void) const
{
    return m_choice == e_Set_both_partial;
}

inline
bool CLocation_edit_type_Base::IsClear_both_partial(void) const
{
    return m_choice == e_Clear_both_partial;
}

inline
CLocation_edit_type_Base::TClear_both_partial CLocation_edit_type_Base::GetClear_both_partial(void) const
{
    CheckSelected(e_Clear_both_partial);
    return m_Clear_both_partial;
}

inline
CLocation_edit_type_Base::TClear_both_partial& CLocation_edit_type_Base::SetClear_both_partial(void)
{
    Select(e_Clear_both_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Clear_both_partial;
}

inline
void CLocation_edit_type_Base::SetClear_both_partial(CLocation_edit_type_Base::TClear_both_partial value)
{
    Select(e_Clear_both_partial, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Clear_both_partial = value;
}

inline
bool CLocation_edit_type_Base::IsConvert(void) const
{
    return m_choice == e_Convert;
}

inline
CLocation_edit_type_Base::TConvert CLocation_edit_type_Base::GetConvert(void) const
{
    CheckSelected(e_Convert);
    return m_Convert;
}

inline
CLocation_edit_type_Base::TConvert& CLocation_edit_type_Base::SetConvert(void)
{
    Select(e_Convert, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Convert;
}

inline
void CLocation_edit_type_Base::SetConvert(CLocation_edit_type_Base::TConvert value)
{
    Select(e_Convert, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Convert = value;
}

inline
bool CLocation_edit_type_Base::IsExtend_5(void) const
{
    return m_choice == e_Extend_5;
}

inline
void CLocation_edit_type_Base::SetExtend_5(void)
{
    Select(e_Extend_5, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CLocation_edit_type_Base::IsExtend_3(void) const
{
    return m_choice == e_Extend_3;
}

inline
void CLocation_edit_type_Base::SetExtend_3(void)
{
    Select(e_Extend_3, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CLocation_edit_type_Base::IsExtend_5_to_feat(void) const
{
    return m_choice == e_Extend_5_to_feat;
}

inline
bool CLocation_edit_type_Base::IsExtend_3_to_feat(void) const
{
    return m_choice == e_Extend_3_to_feat;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_LOCATION_EDIT_TYPE_BASE_HPP
