/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Fix_author_caps_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_FIX_AUTHOR_CAPS_BASE_HPP
#define OBJECTS_MACRO_FIX_AUTHOR_CAPS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CFix_author_caps_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFix_author_caps_Base(void);
    // destructor
    virtual ~CFix_author_caps_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TLast_name_only;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_last_name_only
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef bool TLast_name_only
    ///  Check whether the Last_name_only data member has been assigned a value.
    bool IsSetLast_name_only(void) const;
    /// Check whether it is safe or not to call GetLast_name_only method.
    bool CanGetLast_name_only(void) const;
    void ResetLast_name_only(void);
    TLast_name_only GetLast_name_only(void) const;
    void SetLast_name_only(TLast_name_only value);
    TLast_name_only& SetLast_name_only(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFix_author_caps_Base(const CFix_author_caps_Base&);
    CFix_author_caps_Base& operator=(const CFix_author_caps_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Last_name_only;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFix_author_caps_Base::IsSetLast_name_only(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFix_author_caps_Base::CanGetLast_name_only(void) const
{
    return IsSetLast_name_only();
}

inline
void CFix_author_caps_Base::ResetLast_name_only(void)
{
    m_Last_name_only = 0;
    m_set_State[0] &= ~0x3;
}

inline
CFix_author_caps_Base::TLast_name_only CFix_author_caps_Base::GetLast_name_only(void) const
{
    if (!CanGetLast_name_only()) {
        ThrowUnassigned(0);
    }
    return m_Last_name_only;
}

inline
void CFix_author_caps_Base::SetLast_name_only(CFix_author_caps_Base::TLast_name_only value)
{
    m_Last_name_only = value;
    m_set_State[0] |= 0x3;
}

inline
CFix_author_caps_Base::TLast_name_only& CFix_author_caps_Base::SetLast_name_only(void)
{
#ifdef _DEBUG
    if (!IsSetLast_name_only()) {
        memset(&m_Last_name_only,UnassignedByte(),sizeof(m_Last_name_only));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Last_name_only;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_FIX_AUTHOR_CAPS_BASE_HPP
