/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Field_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_FIELD_TYPE_BASE_HPP
#define OBJECTS_MACRO_FIELD_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/CDSGeneProt_field.hpp>
#include <objects/macro/DBLink_field_type.hpp>
#include <objects/macro/Misc_field.hpp>
#include <objects/macro/Publication_field.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeature_field;
class CMolinfo_field;
class CRna_qual;
class CSource_qual_choice;
class CStructured_comment_field;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CField_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CField_type_Base(void);
    // destructor
    virtual ~CField_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,          ///< No variant selected
        e_Source_qual,
        e_Feature_field,
        e_Rna_field,
        e_Cds_gene_prot,
        e_Molinfo_field,
        e_Pub,
        e_Struc_comment_field,
        e_Misc,
        e_Dblink
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 10 ///< == e_Dblink+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CSource_qual_choice TSource_qual;
    typedef CFeature_field TFeature_field;
    typedef CRna_qual TRna_field;
    typedef ECDSGeneProt_field TCds_gene_prot;
    typedef CMolinfo_field TMolinfo_field;
    typedef EPublication_field TPub;
    typedef CStructured_comment_field TStruc_comment_field;
    typedef EMisc_field TMisc;
    typedef EDBLink_field_type TDblink;

    // getters
    // setters

    // typedef CSource_qual_choice TSource_qual
    bool IsSource_qual(void) const;
    const TSource_qual& GetSource_qual(void) const;
    TSource_qual& SetSource_qual(void);
    void SetSource_qual(TSource_qual& value);

    // typedef CFeature_field TFeature_field
    bool IsFeature_field(void) const;
    const TFeature_field& GetFeature_field(void) const;
    TFeature_field& SetFeature_field(void);
    void SetFeature_field(TFeature_field& value);

    // typedef CRna_qual TRna_field
    bool IsRna_field(void) const;
    const TRna_field& GetRna_field(void) const;
    TRna_field& SetRna_field(void);
    void SetRna_field(TRna_field& value);

    // typedef ECDSGeneProt_field TCds_gene_prot
    bool IsCds_gene_prot(void) const;
    TCds_gene_prot GetCds_gene_prot(void) const;
    TCds_gene_prot& SetCds_gene_prot(void);
    void SetCds_gene_prot(TCds_gene_prot value);

    // typedef CMolinfo_field TMolinfo_field
    bool IsMolinfo_field(void) const;
    const TMolinfo_field& GetMolinfo_field(void) const;
    TMolinfo_field& SetMolinfo_field(void);
    void SetMolinfo_field(TMolinfo_field& value);

    // typedef EPublication_field TPub
    bool IsPub(void) const;
    TPub GetPub(void) const;
    TPub& SetPub(void);
    void SetPub(TPub value);

    // typedef CStructured_comment_field TStruc_comment_field
    bool IsStruc_comment_field(void) const;
    const TStruc_comment_field& GetStruc_comment_field(void) const;
    TStruc_comment_field& SetStruc_comment_field(void);
    void SetStruc_comment_field(TStruc_comment_field& value);

    // typedef EMisc_field TMisc
    bool IsMisc(void) const;
    TMisc GetMisc(void) const;
    TMisc& SetMisc(void);
    void SetMisc(TMisc value);

    // typedef EDBLink_field_type TDblink
    bool IsDblink(void) const;
    TDblink GetDblink(void) const;
    TDblink& SetDblink(void);
    void SetDblink(TDblink value);


private:
    // copy constructor and assignment operator
    CField_type_Base(const CField_type_Base& );
    CField_type_Base& operator=(const CField_type_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TCds_gene_prot m_Cds_gene_prot;
        TPub m_Pub;
        TMisc m_Misc;
        TDblink m_Dblink;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CField_type_Base::E_Choice CField_type_Base::Which(void) const
{
    return m_choice;
}

inline
void CField_type_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CField_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CField_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CField_type_Base::IsSource_qual(void) const
{
    return m_choice == e_Source_qual;
}

inline
bool CField_type_Base::IsFeature_field(void) const
{
    return m_choice == e_Feature_field;
}

inline
bool CField_type_Base::IsRna_field(void) const
{
    return m_choice == e_Rna_field;
}

inline
bool CField_type_Base::IsCds_gene_prot(void) const
{
    return m_choice == e_Cds_gene_prot;
}

inline
CField_type_Base::TCds_gene_prot CField_type_Base::GetCds_gene_prot(void) const
{
    CheckSelected(e_Cds_gene_prot);
    return m_Cds_gene_prot;
}

inline
CField_type_Base::TCds_gene_prot& CField_type_Base::SetCds_gene_prot(void)
{
    Select(e_Cds_gene_prot, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Cds_gene_prot;
}

inline
void CField_type_Base::SetCds_gene_prot(CField_type_Base::TCds_gene_prot value)
{
    Select(e_Cds_gene_prot, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Cds_gene_prot = value;
}

inline
bool CField_type_Base::IsMolinfo_field(void) const
{
    return m_choice == e_Molinfo_field;
}

inline
bool CField_type_Base::IsPub(void) const
{
    return m_choice == e_Pub;
}

inline
CField_type_Base::TPub CField_type_Base::GetPub(void) const
{
    CheckSelected(e_Pub);
    return m_Pub;
}

inline
CField_type_Base::TPub& CField_type_Base::SetPub(void)
{
    Select(e_Pub, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Pub;
}

inline
void CField_type_Base::SetPub(CField_type_Base::TPub value)
{
    Select(e_Pub, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Pub = value;
}

inline
bool CField_type_Base::IsStruc_comment_field(void) const
{
    return m_choice == e_Struc_comment_field;
}

inline
bool CField_type_Base::IsMisc(void) const
{
    return m_choice == e_Misc;
}

inline
CField_type_Base::TMisc CField_type_Base::GetMisc(void) const
{
    CheckSelected(e_Misc);
    return m_Misc;
}

inline
CField_type_Base::TMisc& CField_type_Base::SetMisc(void)
{
    Select(e_Misc, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Misc;
}

inline
void CField_type_Base::SetMisc(CField_type_Base::TMisc value)
{
    Select(e_Misc, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Misc = value;
}

inline
bool CField_type_Base::IsDblink(void) const
{
    return m_choice == e_Dblink;
}

inline
CField_type_Base::TDblink CField_type_Base::GetDblink(void) const
{
    CheckSelected(e_Dblink);
    return m_Dblink;
}

inline
CField_type_Base::TDblink& CField_type_Base::SetDblink(void)
{
    Select(e_Dblink, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Dblink;
}

inline
void CField_type_Base::SetDblink(CField_type_Base::TDblink value)
{
    Select(e_Dblink, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Dblink = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_FIELD_TYPE_BASE_HPP
