/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file id2_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_CLIENT_BASE_HPP
#define OBJECTS_ID2_ID2_CLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/id2/ID2_Reply.hpp>
#include <objects/id2/ID2_Request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2Client_Base : public CRPCClient<CID2_Request, CID2_Reply>
{
    typedef CRPCClient<CID2_Request, CID2_Reply> Tparent;
public:
    // constructor
    CID2Client_Base(void);
    // destructor
    virtual ~CID2Client_Base(void);

    typedef CID2_Request TRequest;
    typedef CID2_Reply TReply;
    typedef CID2_Request::C_Request TRequestChoice;
    typedef CID2_Reply::C_Reply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);


    virtual const TRequest& GetDefaultRequest(void) const;
    virtual TRequest&       SetDefaultRequest(void);
    virtual void            SetDefaultRequest(const TRequest& request);

    virtual void Ask(const TRequestChoice& req, TReply& reply);
    virtual void Ask(const TRequestChoice& req, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual void AskInit
        (TReply* reply = 0);

    virtual CRef<CID2_Reply_Get_Package> AskGet_packages
        (const CID2_Request_Get_Packages& req, TReply* reply = 0);

    virtual CRef<CID2_Reply_Get_Seq_id> AskGet_seq_id
        (const CID2_Request_Get_Seq_id& req, TReply* reply = 0);

    virtual CRef<CID2_Reply_Get_Blob_Id> AskGet_blob_id
        (const CID2_Request_Get_Blob_Id& req, TReply* reply = 0);

    virtual CRef<CID2_Reply_Get_Blob> AskGet_blob_info
        (const CID2_Request_Get_Blob_Info& req, TReply* reply = 0);

    virtual CRef<CID2_Reply_ReGet_Blob> AskReget_blob
        (const CID2_Request_ReGet_Blob& req, TReply* reply = 0);

    virtual CRef<CID2S_Reply_Get_Chunk> AskGet_chunks
        (const CID2S_Request_Get_Chunks& req, TReply* reply = 0);


protected:
    void x_Connect(void);

private:
    CRef<TRequest> m_DefaultRequest;

    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID2Client_Base::TReplyChoice& CID2Client_Base::x_Choice(CID2Client_Base::TReply& reply)
{
    return reply.SetReply();
}

inline
void CID2Client_Base::Ask(const CID2Client_Base::TRequest& request, CID2Client_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


inline
const CID2Client_Base::TRequest& CID2Client_Base::GetDefaultRequest(void) const
{
    return *m_DefaultRequest;
}

inline
CID2Client_Base::TRequest& CID2Client_Base::SetDefaultRequest(void)
{
    return *m_DefaultRequest;
}

inline
void CID2Client_Base::SetDefaultRequest(const CID2Client_Base::TRequest& request)
{
    m_DefaultRequest->Assign(request);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_CLIENT_BASE_HPP
