/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Request_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REQUEST_BASE_HPP
#define OBJECTS_ID2_ID2_REQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Request_Get_Chunks;
class CID2_Params;
class CID2_Request_Get_Blob_Id;
class CID2_Request_Get_Blob_Info;
class CID2_Request_Get_Packages;
class CID2_Request_Get_Seq_id;
class CID2_Request_ReGet_Blob;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2_Request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Request_Base(void);
    // destructor
    virtual ~CID2_Request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_ID2_EXPORT C_Request : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Request(void);
        // destructor
        ~C_Request(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,    ///< No variant selected
            e_Init,
            e_Get_packages,
            e_Get_seq_id,
            e_Get_blob_id,
            e_Get_blob_info,
            e_Reget_blob,
            e_Get_chunks
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 8 ///< == e_Get_chunks+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CID2_Request_Get_Packages TGet_packages;
        typedef CID2_Request_Get_Seq_id TGet_seq_id;
        typedef CID2_Request_Get_Blob_Id TGet_blob_id;
        typedef CID2_Request_Get_Blob_Info TGet_blob_info;
        typedef CID2_Request_ReGet_Blob TReget_blob;
        typedef CID2S_Request_Get_Chunks TGet_chunks;
    
        // getters
        // setters
    
    
        bool IsInit(void) const;
        void SetInit(void);
    
        // typedef CID2_Request_Get_Packages TGet_packages
        bool IsGet_packages(void) const;
        const TGet_packages& GetGet_packages(void) const;
        TGet_packages& SetGet_packages(void);
        void SetGet_packages(TGet_packages& value);
    
        // typedef CID2_Request_Get_Seq_id TGet_seq_id
        bool IsGet_seq_id(void) const;
        const TGet_seq_id& GetGet_seq_id(void) const;
        TGet_seq_id& SetGet_seq_id(void);
        void SetGet_seq_id(TGet_seq_id& value);
    
        // typedef CID2_Request_Get_Blob_Id TGet_blob_id
        bool IsGet_blob_id(void) const;
        const TGet_blob_id& GetGet_blob_id(void) const;
        TGet_blob_id& SetGet_blob_id(void);
        void SetGet_blob_id(TGet_blob_id& value);
    
        // typedef CID2_Request_Get_Blob_Info TGet_blob_info
        bool IsGet_blob_info(void) const;
        const TGet_blob_info& GetGet_blob_info(void) const;
        TGet_blob_info& SetGet_blob_info(void);
        void SetGet_blob_info(TGet_blob_info& value);
    
        // typedef CID2_Request_ReGet_Blob TReget_blob
        bool IsReget_blob(void) const;
        const TReget_blob& GetReget_blob(void) const;
        TReget_blob& SetReget_blob(void);
        void SetReget_blob(TReget_blob& value);
    
        // typedef CID2S_Request_Get_Chunks TGet_chunks
        bool IsGet_chunks(void) const;
        const TGet_chunks& GetGet_chunks(void) const;
        TGet_chunks& SetGet_chunks(void);
        void SetGet_chunks(TGet_chunks& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Request(const C_Request& );
        C_Request& operator=(const C_Request& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef int TSerial_number;
    typedef CID2_Params TParams;
    typedef C_Request TRequest;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_serial_number,
        e_params,
        e_request
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// request's serial number, can be used in asynchronic clients
    /// server should copy it to corresponding field in reply
    /// optional
    /// typedef int TSerial_number
    ///  Check whether the Serial_number data member has been assigned a value.
    bool IsSetSerial_number(void) const;
    /// Check whether it is safe or not to call GetSerial_number method.
    bool CanGetSerial_number(void) const;
    void ResetSerial_number(void);
    TSerial_number GetSerial_number(void) const;
    void SetSerial_number(TSerial_number value);
    TSerial_number& SetSerial_number(void);

    /// optional
    /// typedef CID2_Params TParams
    ///  Check whether the Params data member has been assigned a value.
    bool IsSetParams(void) const;
    /// Check whether it is safe or not to call GetParams method.
    bool CanGetParams(void) const;
    void ResetParams(void);
    const TParams& GetParams(void) const;
    void SetParams(TParams& value);
    TParams& SetParams(void);

    /// mandatory
    /// typedef C_Request TRequest
    ///  Check whether the Request data member has been assigned a value.
    bool IsSetRequest(void) const;
    /// Check whether it is safe or not to call GetRequest method.
    bool CanGetRequest(void) const;
    void ResetRequest(void);
    const TRequest& GetRequest(void) const;
    void SetRequest(TRequest& value);
    TRequest& SetRequest(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Request_Base(const CID2_Request_Base&);
    CID2_Request_Base& operator=(const CID2_Request_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Serial_number;
    CRef< TParams > m_Params;
    CRef< TRequest > m_Request;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID2_Request_Base::C_Request::E_Choice CID2_Request_Base::C_Request::Which(void) const
{
    return m_choice;
}

inline
void CID2_Request_Base::C_Request::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID2_Request_Base::C_Request::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID2_Request_Base::C_Request::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID2_Request_Base::C_Request::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CID2_Request_Base::C_Request::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CID2_Request_Base::C_Request::IsGet_packages(void) const
{
    return m_choice == e_Get_packages;
}

inline
bool CID2_Request_Base::C_Request::IsGet_seq_id(void) const
{
    return m_choice == e_Get_seq_id;
}

inline
bool CID2_Request_Base::C_Request::IsGet_blob_id(void) const
{
    return m_choice == e_Get_blob_id;
}

inline
bool CID2_Request_Base::C_Request::IsGet_blob_info(void) const
{
    return m_choice == e_Get_blob_info;
}

inline
bool CID2_Request_Base::C_Request::IsReget_blob(void) const
{
    return m_choice == e_Reget_blob;
}

inline
bool CID2_Request_Base::C_Request::IsGet_chunks(void) const
{
    return m_choice == e_Get_chunks;
}

inline
bool CID2_Request_Base::IsSetSerial_number(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2_Request_Base::CanGetSerial_number(void) const
{
    return IsSetSerial_number();
}

inline
void CID2_Request_Base::ResetSerial_number(void)
{
    m_Serial_number = 0;
    m_set_State[0] &= ~0x3;
}

inline
CID2_Request_Base::TSerial_number CID2_Request_Base::GetSerial_number(void) const
{
    if (!CanGetSerial_number()) {
        ThrowUnassigned(0);
    }
    return m_Serial_number;
}

inline
void CID2_Request_Base::SetSerial_number(CID2_Request_Base::TSerial_number value)
{
    m_Serial_number = value;
    m_set_State[0] |= 0x3;
}

inline
CID2_Request_Base::TSerial_number& CID2_Request_Base::SetSerial_number(void)
{
#ifdef _DEBUG
    if (!IsSetSerial_number()) {
        memset(&m_Serial_number,UnassignedByte(),sizeof(m_Serial_number));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Serial_number;
}

inline
bool CID2_Request_Base::IsSetParams(void) const
{
    return m_Params.NotEmpty();
}

inline
bool CID2_Request_Base::CanGetParams(void) const
{
    return IsSetParams();
}

inline
const CID2_Request_Base::TParams& CID2_Request_Base::GetParams(void) const
{
    if (!CanGetParams()) {
        ThrowUnassigned(1);
    }
    return (*m_Params);
}

inline
bool CID2_Request_Base::IsSetRequest(void) const
{
    return m_Request.NotEmpty();
}

inline
bool CID2_Request_Base::CanGetRequest(void) const
{
    return true;
}

inline
const CID2_Request_Base::TRequest& CID2_Request_Base::GetRequest(void) const
{
    if ( !m_Request ) {
        const_cast<CID2_Request_Base*>(this)->ResetRequest();
    }
    return (*m_Request);
}

inline
CID2_Request_Base::TRequest& CID2_Request_Base::SetRequest(void)
{
    if ( !m_Request ) {
        ResetRequest();
    }
    return (*m_Request);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REQUEST_BASE_HPP
