/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Reply_Get_Seq_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REPLY_GET_SEQ_ID_BASE_HPP
#define OBJECTS_ID2_ID2_REPLY_GET_SEQ_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2_Request_Get_Seq_id;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Reply to ID2-Request-Get-Seq-id.
class NCBI_ID2_EXPORT CID2_Reply_Get_Seq_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Reply_Get_Seq_id_Base(void);
    // destructor
    virtual ~CID2_Reply_Get_Seq_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2_Request_Get_Seq_id TRequest;
    typedef list< CRef< CSeq_id > > TSeq_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_request,
        e_seq_id,
        e_end_of_reply
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// copy of request
    /// mandatory
    /// typedef CID2_Request_Get_Seq_id TRequest
    ///  Check whether the Request data member has been assigned a value.
    bool IsSetRequest(void) const;
    /// Check whether it is safe or not to call GetRequest method.
    bool CanGetRequest(void) const;
    void ResetRequest(void);
    const TRequest& GetRequest(void) const;
    void SetRequest(TRequest& value);
    TRequest& SetRequest(void);

    /// resolved Seq-id
    /// not set if error occurred
    /// optional
    /// typedef list< CRef< CSeq_id > > TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    TSeq_id& SetSeq_id(void);

    /// this Seq-id is the last one in the request
    /// optional
    ///  Check whether the End_of_reply data member has been assigned a value.
    bool IsSetEnd_of_reply(void) const;
    /// Check whether it is safe or not to call GetEnd_of_reply method.
    bool CanGetEnd_of_reply(void) const;
    void ResetEnd_of_reply(void);
    void SetEnd_of_reply(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Reply_Get_Seq_id_Base(const CID2_Reply_Get_Seq_id_Base&);
    CID2_Reply_Get_Seq_id_Base& operator=(const CID2_Reply_Get_Seq_id_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TRequest > m_Request;
    list< CRef< CSeq_id > > m_Seq_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Reply_Get_Seq_id_Base::IsSetRequest(void) const
{
    return m_Request.NotEmpty();
}

inline
bool CID2_Reply_Get_Seq_id_Base::CanGetRequest(void) const
{
    return true;
}

inline
const CID2_Reply_Get_Seq_id_Base::TRequest& CID2_Reply_Get_Seq_id_Base::GetRequest(void) const
{
    if ( !m_Request ) {
        const_cast<CID2_Reply_Get_Seq_id_Base*>(this)->ResetRequest();
    }
    return (*m_Request);
}

inline
CID2_Reply_Get_Seq_id_Base::TRequest& CID2_Reply_Get_Seq_id_Base::SetRequest(void)
{
    if ( !m_Request ) {
        ResetRequest();
    }
    return (*m_Request);
}

inline
bool CID2_Reply_Get_Seq_id_Base::IsSetSeq_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Reply_Get_Seq_id_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CID2_Reply_Get_Seq_id_Base::TSeq_id& CID2_Reply_Get_Seq_id_Base::GetSeq_id(void) const
{
    return m_Seq_id;
}

inline
CID2_Reply_Get_Seq_id_Base::TSeq_id& CID2_Reply_Get_Seq_id_Base::SetSeq_id(void)
{
    m_set_State[0] |= 0x4;
    return m_Seq_id;
}

inline
bool CID2_Reply_Get_Seq_id_Base::IsSetEnd_of_reply(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2_Reply_Get_Seq_id_Base::CanGetEnd_of_reply(void) const
{
    return false;
}

inline
void CID2_Reply_Get_Seq_id_Base::ResetEnd_of_reply(void)
{
    m_set_State[0] &= ~0x30;
}

inline
void CID2_Reply_Get_Seq_id_Base::SetEnd_of_reply(void)
{
    m_set_State[0] |= 0x30;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REPLY_GET_SEQ_ID_BASE_HPP
