/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Reply_Get_Blob_Id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REPLY_GET_BLOB_ID_BASE_HPP
#define OBJECTS_ID2_ID2_REPLY_GET_BLOB_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Seq_annot_Info;
class CID2_Blob_Id;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Reply to ID2-Request-Get-Blob-Id.
class NCBI_ID2_EXPORT CID2_Reply_Get_Blob_Id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Reply_Get_Blob_Id_Base(void);
    // destructor
    virtual ~CID2_Reply_Get_Blob_Id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TSeq_id;
    typedef CID2_Blob_Id TBlob_id;
    typedef int TSplit_version;
    typedef list< CRef< CID2S_Seq_annot_Info > > TAnnot_info;
    typedef int TBlob_state;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_blob_id,
        e_split_version,
        e_annot_info,
        e_end_of_reply,
        e_blob_state
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// requested Seq-id
    /// mandatory
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// result
    /// optional
    /// typedef CID2_Blob_Id TBlob_id
    ///  Check whether the Blob_id data member has been assigned a value.
    bool IsSetBlob_id(void) const;
    /// Check whether it is safe or not to call GetBlob_id method.
    bool CanGetBlob_id(void) const;
    void ResetBlob_id(void);
    const TBlob_id& GetBlob_id(void) const;
    void SetBlob_id(TBlob_id& value);
    TBlob_id& SetBlob_id(void);

    /// version of split data
    /// (0 for non split)
    /// optional with default 0
    /// typedef int TSplit_version
    ///  Check whether the Split_version data member has been assigned a value.
    bool IsSetSplit_version(void) const;
    /// Check whether it is safe or not to call GetSplit_version method.
    bool CanGetSplit_version(void) const;
    void ResetSplit_version(void);
    void SetDefaultSplit_version(void);
    TSplit_version GetSplit_version(void) const;
    void SetSplit_version(TSplit_version value);
    TSplit_version& SetSplit_version(void);

    /// annotation types in this blob
    /// annotation are unknown if this field is omitted
    /// optional
    /// typedef list< CRef< CID2S_Seq_annot_Info > > TAnnot_info
    ///  Check whether the Annot_info data member has been assigned a value.
    bool IsSetAnnot_info(void) const;
    /// Check whether it is safe or not to call GetAnnot_info method.
    bool CanGetAnnot_info(void) const;
    void ResetAnnot_info(void);
    const TAnnot_info& GetAnnot_info(void) const;
    TAnnot_info& SetAnnot_info(void);

    /// this Blob-id is the last one in the request
    /// optional
    ///  Check whether the End_of_reply data member has been assigned a value.
    bool IsSetEnd_of_reply(void) const;
    /// Check whether it is safe or not to call GetEnd_of_reply method.
    bool CanGetEnd_of_reply(void) const;
    void ResetEnd_of_reply(void);
    void SetEnd_of_reply(void);

    /// state bits of the blob, 0 or missing means regular live data
    /// optional
    /// typedef int TBlob_state
    ///  Check whether the Blob_state data member has been assigned a value.
    bool IsSetBlob_state(void) const;
    /// Check whether it is safe or not to call GetBlob_state method.
    bool CanGetBlob_state(void) const;
    void ResetBlob_state(void);
    TBlob_state GetBlob_state(void) const;
    void SetBlob_state(TBlob_state value);
    TBlob_state& SetBlob_state(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Reply_Get_Blob_Id_Base(const CID2_Reply_Get_Blob_Id_Base&);
    CID2_Reply_Get_Blob_Id_Base& operator=(const CID2_Reply_Get_Blob_Id_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    CRef< TBlob_id > m_Blob_id;
    int m_Split_version;
    list< CRef< CID2S_Seq_annot_Info > > m_Annot_info;
    int m_Blob_state;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CID2_Reply_Get_Blob_Id_Base::TSeq_id& CID2_Reply_Get_Blob_Id_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CID2_Reply_Get_Blob_Id_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CID2_Reply_Get_Blob_Id_Base::TSeq_id& CID2_Reply_Get_Blob_Id_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetBlob_id(void) const
{
    return m_Blob_id.NotEmpty();
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetBlob_id(void) const
{
    return IsSetBlob_id();
}

inline
const CID2_Reply_Get_Blob_Id_Base::TBlob_id& CID2_Reply_Get_Blob_Id_Base::GetBlob_id(void) const
{
    if (!CanGetBlob_id()) {
        ThrowUnassigned(1);
    }
    return (*m_Blob_id);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetSplit_version(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetSplit_version(void) const
{
    return true;
}

inline
void CID2_Reply_Get_Blob_Id_Base::ResetSplit_version(void)
{
    m_Split_version = 0;
    m_set_State[0] &= ~0x30;
}

inline
void CID2_Reply_Get_Blob_Id_Base::SetDefaultSplit_version(void)
{
    ResetSplit_version();
}

inline
CID2_Reply_Get_Blob_Id_Base::TSplit_version CID2_Reply_Get_Blob_Id_Base::GetSplit_version(void) const
{
    return m_Split_version;
}

inline
void CID2_Reply_Get_Blob_Id_Base::SetSplit_version(CID2_Reply_Get_Blob_Id_Base::TSplit_version value)
{
    m_Split_version = value;
    m_set_State[0] |= 0x30;
}

inline
CID2_Reply_Get_Blob_Id_Base::TSplit_version& CID2_Reply_Get_Blob_Id_Base::SetSplit_version(void)
{
#ifdef _DEBUG
    if (!IsSetSplit_version()) {
        memset(&m_Split_version,UnassignedByte(),sizeof(m_Split_version));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Split_version;
}

inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetAnnot_info(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetAnnot_info(void) const
{
    return true;
}

inline
const CID2_Reply_Get_Blob_Id_Base::TAnnot_info& CID2_Reply_Get_Blob_Id_Base::GetAnnot_info(void) const
{
    return m_Annot_info;
}

inline
CID2_Reply_Get_Blob_Id_Base::TAnnot_info& CID2_Reply_Get_Blob_Id_Base::SetAnnot_info(void)
{
    m_set_State[0] |= 0x40;
    return m_Annot_info;
}

inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetEnd_of_reply(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetEnd_of_reply(void) const
{
    return false;
}

inline
void CID2_Reply_Get_Blob_Id_Base::ResetEnd_of_reply(void)
{
    m_set_State[0] &= ~0x300;
}

inline
void CID2_Reply_Get_Blob_Id_Base::SetEnd_of_reply(void)
{
    m_set_State[0] |= 0x300;
}

inline
bool CID2_Reply_Get_Blob_Id_Base::IsSetBlob_state(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CID2_Reply_Get_Blob_Id_Base::CanGetBlob_state(void) const
{
    return IsSetBlob_state();
}

inline
void CID2_Reply_Get_Blob_Id_Base::ResetBlob_state(void)
{
    m_Blob_state = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CID2_Reply_Get_Blob_Id_Base::TBlob_state CID2_Reply_Get_Blob_Id_Base::GetBlob_state(void) const
{
    if (!CanGetBlob_state()) {
        ThrowUnassigned(5);
    }
    return m_Blob_state;
}

inline
void CID2_Reply_Get_Blob_Id_Base::SetBlob_state(CID2_Reply_Get_Blob_Id_Base::TBlob_state value)
{
    m_Blob_state = value;
    m_set_State[0] |= 0xc00;
}

inline
CID2_Reply_Get_Blob_Id_Base::TBlob_state& CID2_Reply_Get_Blob_Id_Base::SetBlob_state(void)
{
#ifdef _DEBUG
    if (!IsSetBlob_state()) {
        memset(&m_Blob_state,UnassignedByte(),sizeof(m_Blob_state));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Blob_state;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REPLY_GET_BLOB_ID_BASE_HPP
