/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file id1_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1_CLIENT_BASE_HPP
#define OBJECTS_ID1_ID1_CLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/id1/ID1server_back.hpp>
#include <objects/id1/ID1server_request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID1Seq_hist;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID1_EXPORT CID1Client_Base : public CRPCClient<CID1server_request, CID1server_back>
{
    typedef CRPCClient<CID1server_request, CID1server_back> Tparent;
public:
    // constructor
    CID1Client_Base(void);
    // destructor
    virtual ~CID1Client_Base(void);

    typedef CID1server_request TRequest;
    typedef CID1server_back TReply;
    typedef TRequest TRequestChoice;
    typedef TReply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual void AskInit
        (TReply* reply = 0);

    virtual NCBI_NS_NCBI::TGi AskGetgi
        (const CSeq_id& req, TReply* reply = 0);

    virtual CRef<CSeq_entry> AskGetsefromgi
        (const CID1server_maxcomplex& req, TReply* reply = 0);

    virtual void AskFini
        (TReply* reply = 0);

    virtual list< CRef< CSeq_id > > AskGetseqidsfromgi
        (const NCBI_NS_NCBI::TGi& req, TReply* reply = 0);

    virtual list< CRef< CID1Seq_hist > > AskGetgihist
        (const NCBI_NS_NCBI::TGi& req, TReply* reply = 0);

    virtual list< CRef< CID1Seq_hist > > AskGetgirev
        (const NCBI_NS_NCBI::TGi& req, TReply* reply = 0);

    virtual int AskGetgistate
        (const NCBI_NS_NCBI::TGi& req, TReply* reply = 0);

    virtual CRef<CID1SeqEntry_info> AskGetsewithinfo
        (const CID1server_maxcomplex& req, TReply* reply = 0);

    virtual CRef<CID1blob_info> AskGetblobinfo
        (const CID1server_maxcomplex& req, TReply* reply = 0);


protected:
    void x_Connect(void);

    /// Disconnect as cleanly as possible.
    ///
    /// @note Derived classes that override this method
    /// should copy the destructor logic that calls it (via
    /// Disconnect, which avoids duplicate calls).
    void x_Disconnect(void);

private:
    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID1Client_Base::TReplyChoice& CID1Client_Base::x_Choice(CID1Client_Base::TReply& reply)
{
    return reply;
}

inline
void CID1Client_Base::Ask(const CID1Client_Base::TRequest& request, CID1Client_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1_CLIENT_BASE_HPP
