/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Commentary_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_COMMENTARY_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_COMMENTARY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CHG_Commentary;
class CHG_Link;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Commentary_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Commentary_Base(void);
    // destructor
    virtual ~CHG_Commentary_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CHG_Link TLink;
    typedef string TDescription;
    typedef string TCaption;
    typedef string TProvider;
    typedef list< CRef< CHG_Link > > TOther_links;
    typedef list< CRef< CHG_Commentary > > TOther_commentaries;
    typedef int TTaxid;
    typedef int TGeneid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_link,
        e_description,
        e_caption,
        e_provider,
        e_other_links,
        e_other_commentaries,
        e_taxid,
        e_geneid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CHG_Link TLink
    ///  Check whether the Link data member has been assigned a value.
    bool IsSetLink(void) const;
    /// Check whether it is safe or not to call GetLink method.
    bool CanGetLink(void) const;
    void ResetLink(void);
    const TLink& GetLink(void) const;
    void SetLink(TLink& value);
    TLink& SetLink(void);

    /// main description
    /// optional
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// extra text
    /// optional
    /// typedef string TCaption
    ///  Check whether the Caption data member has been assigned a value.
    bool IsSetCaption(void) const;
    /// Check whether it is safe or not to call GetCaption method.
    bool CanGetCaption(void) const;
    void ResetCaption(void);
    const TCaption& GetCaption(void) const;
    void SetCaption(const TCaption& value);
    void SetCaption(TCaption&& value);
    TCaption& SetCaption(void);

    /// optional
    /// typedef string TProvider
    ///  Check whether the Provider data member has been assigned a value.
    bool IsSetProvider(void) const;
    /// Check whether it is safe or not to call GetProvider method.
    bool CanGetProvider(void) const;
    void ResetProvider(void);
    const TProvider& GetProvider(void) const;
    void SetProvider(const TProvider& value);
    void SetProvider(TProvider&& value);
    TProvider& SetProvider(void);

    /// optional
    /// typedef list< CRef< CHG_Link > > TOther_links
    ///  Check whether the Other_links data member has been assigned a value.
    bool IsSetOther_links(void) const;
    /// Check whether it is safe or not to call GetOther_links method.
    bool CanGetOther_links(void) const;
    void ResetOther_links(void);
    const TOther_links& GetOther_links(void) const;
    TOther_links& SetOther_links(void);

    /// optional
    /// typedef list< CRef< CHG_Commentary > > TOther_commentaries
    ///  Check whether the Other_commentaries data member has been assigned a value.
    bool IsSetOther_commentaries(void) const;
    /// Check whether it is safe or not to call GetOther_commentaries method.
    bool CanGetOther_commentaries(void) const;
    void ResetOther_commentaries(void);
    const TOther_commentaries& GetOther_commentaries(void) const;
    TOther_commentaries& SetOther_commentaries(void);

    /// optional
    /// typedef int TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// optional
    /// typedef int TGeneid
    ///  Check whether the Geneid data member has been assigned a value.
    bool IsSetGeneid(void) const;
    /// Check whether it is safe or not to call GetGeneid method.
    bool CanGetGeneid(void) const;
    void ResetGeneid(void);
    TGeneid GetGeneid(void) const;
    void SetGeneid(TGeneid value);
    TGeneid& SetGeneid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Commentary_Base(const CHG_Commentary_Base&);
    CHG_Commentary_Base& operator=(const CHG_Commentary_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLink > m_Link;
    string m_Description;
    string m_Caption;
    string m_Provider;
    list< CRef< CHG_Link > > m_Other_links;
    list< CRef< CHG_Commentary > > m_Other_commentaries;
    int m_Taxid;
    int m_Geneid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Commentary_Base::IsSetLink(void) const
{
    return m_Link.NotEmpty();
}

inline
bool CHG_Commentary_Base::CanGetLink(void) const
{
    return true;
}

inline
const CHG_Commentary_Base::TLink& CHG_Commentary_Base::GetLink(void) const
{
    if ( !m_Link ) {
        const_cast<CHG_Commentary_Base*>(this)->ResetLink();
    }
    return (*m_Link);
}

inline
CHG_Commentary_Base::TLink& CHG_Commentary_Base::SetLink(void)
{
    if ( !m_Link ) {
        ResetLink();
    }
    return (*m_Link);
}

inline
bool CHG_Commentary_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Commentary_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CHG_Commentary_Base::TDescription& CHG_Commentary_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(1);
    }
    return m_Description;
}

inline
void CHG_Commentary_Base::SetDescription(const CHG_Commentary_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0xc;
}

inline
void CHG_Commentary_Base::SetDescription(CHG_Commentary_Base::TDescription&& value)
{
    m_Description = std::forward<CHG_Commentary_Base::TDescription>(value);
    m_set_State[0] |= 0xc;
}

inline
CHG_Commentary_Base::TDescription& CHG_Commentary_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Description;
}

inline
bool CHG_Commentary_Base::IsSetCaption(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHG_Commentary_Base::CanGetCaption(void) const
{
    return IsSetCaption();
}

inline
const CHG_Commentary_Base::TCaption& CHG_Commentary_Base::GetCaption(void) const
{
    if (!CanGetCaption()) {
        ThrowUnassigned(2);
    }
    return m_Caption;
}

inline
void CHG_Commentary_Base::SetCaption(const CHG_Commentary_Base::TCaption& value)
{
    m_Caption = value;
    m_set_State[0] |= 0x30;
}

inline
void CHG_Commentary_Base::SetCaption(CHG_Commentary_Base::TCaption&& value)
{
    m_Caption = std::forward<CHG_Commentary_Base::TCaption>(value);
    m_set_State[0] |= 0x30;
}

inline
CHG_Commentary_Base::TCaption& CHG_Commentary_Base::SetCaption(void)
{
#ifdef _DEBUG
    if (!IsSetCaption()) {
        m_Caption = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Caption;
}

inline
bool CHG_Commentary_Base::IsSetProvider(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHG_Commentary_Base::CanGetProvider(void) const
{
    return IsSetProvider();
}

inline
const CHG_Commentary_Base::TProvider& CHG_Commentary_Base::GetProvider(void) const
{
    if (!CanGetProvider()) {
        ThrowUnassigned(3);
    }
    return m_Provider;
}

inline
void CHG_Commentary_Base::SetProvider(const CHG_Commentary_Base::TProvider& value)
{
    m_Provider = value;
    m_set_State[0] |= 0xc0;
}

inline
void CHG_Commentary_Base::SetProvider(CHG_Commentary_Base::TProvider&& value)
{
    m_Provider = std::forward<CHG_Commentary_Base::TProvider>(value);
    m_set_State[0] |= 0xc0;
}

inline
CHG_Commentary_Base::TProvider& CHG_Commentary_Base::SetProvider(void)
{
#ifdef _DEBUG
    if (!IsSetProvider()) {
        m_Provider = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Provider;
}

inline
bool CHG_Commentary_Base::IsSetOther_links(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHG_Commentary_Base::CanGetOther_links(void) const
{
    return true;
}

inline
const CHG_Commentary_Base::TOther_links& CHG_Commentary_Base::GetOther_links(void) const
{
    return m_Other_links;
}

inline
CHG_Commentary_Base::TOther_links& CHG_Commentary_Base::SetOther_links(void)
{
    m_set_State[0] |= 0x100;
    return m_Other_links;
}

inline
bool CHG_Commentary_Base::IsSetOther_commentaries(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CHG_Commentary_Base::CanGetOther_commentaries(void) const
{
    return true;
}

inline
const CHG_Commentary_Base::TOther_commentaries& CHG_Commentary_Base::GetOther_commentaries(void) const
{
    return m_Other_commentaries;
}

inline
CHG_Commentary_Base::TOther_commentaries& CHG_Commentary_Base::SetOther_commentaries(void)
{
    m_set_State[0] |= 0x400;
    return m_Other_commentaries;
}

inline
bool CHG_Commentary_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CHG_Commentary_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CHG_Commentary_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CHG_Commentary_Base::TTaxid CHG_Commentary_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(6);
    }
    return m_Taxid;
}

inline
void CHG_Commentary_Base::SetTaxid(CHG_Commentary_Base::TTaxid value)
{
    m_Taxid = value;
    m_set_State[0] |= 0x3000;
}

inline
CHG_Commentary_Base::TTaxid& CHG_Commentary_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Taxid;
}

inline
bool CHG_Commentary_Base::IsSetGeneid(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CHG_Commentary_Base::CanGetGeneid(void) const
{
    return IsSetGeneid();
}

inline
void CHG_Commentary_Base::ResetGeneid(void)
{
    m_Geneid = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CHG_Commentary_Base::TGeneid CHG_Commentary_Base::GetGeneid(void) const
{
    if (!CanGetGeneid()) {
        ThrowUnassigned(7);
    }
    return m_Geneid;
}

inline
void CHG_Commentary_Base::SetGeneid(CHG_Commentary_Base::TGeneid value)
{
    m_Geneid = value;
    m_set_State[0] |= 0xc000;
}

inline
CHG_Commentary_Base::TGeneid& CHG_Commentary_Base::SetGeneid(void)
{
#ifdef _DEBUG
    if (!IsSetGeneid()) {
        memset(&m_Geneid,UnassignedByte(),sizeof(m_Geneid));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Geneid;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_COMMENTARY_BASE_HPP
