/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_DbTagAlias_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_DBTAGALIAS_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_DBTAGALIAS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///- GC-DbTagAlias reports relationships between assembly-releases
///
class NCBI_GENOME_COLLECTION_EXPORT CGC_DbTagAlias_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_DbTagAlias_Base(void);
    // destructor
    virtual ~CGC_DbTagAlias_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Similarity: relationship between 2 assemblies represented by DbTags
    /// Can be expanded to multiple level of identicality
    /// can use bitmap to flag ambiguity between different identicality levels
    enum ESimilarity {
        eSimilarity_unknown   =   0,
        eSimilarity_identical =   1,
        eSimilarity_different = 255
    };
    
    /// Access to ESimilarity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESimilarity)(void);
    
    // types
    typedef CDbtag TRefseq;
    typedef CDbtag TGenbank;
    typedef int TSimilarity;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_refseq,
        e_genbank,
        e_similarity
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// the refseq assembly release-id
    /// optional
    /// typedef CDbtag TRefseq
    ///  Check whether the Refseq data member has been assigned a value.
    bool IsSetRefseq(void) const;
    /// Check whether it is safe or not to call GetRefseq method.
    bool CanGetRefseq(void) const;
    void ResetRefseq(void);
    const TRefseq& GetRefseq(void) const;
    void SetRefseq(TRefseq& value);
    TRefseq& SetRefseq(void);

    /// the genbank assembly release-id
    /// optional
    /// typedef CDbtag TGenbank
    ///  Check whether the Genbank data member has been assigned a value.
    bool IsSetGenbank(void) const;
    /// Check whether it is safe or not to call GetGenbank method.
    bool CanGetGenbank(void) const;
    void ResetGenbank(void);
    const TGenbank& GetGenbank(void) const;
    void SetGenbank(TGenbank& value);
    TGenbank& SetGenbank(void);

    /// mandatory
    /// typedef int TSimilarity
    ///  Check whether the Similarity data member has been assigned a value.
    bool IsSetSimilarity(void) const;
    /// Check whether it is safe or not to call GetSimilarity method.
    bool CanGetSimilarity(void) const;
    void ResetSimilarity(void);
    TSimilarity GetSimilarity(void) const;
    void SetSimilarity(TSimilarity value);
    TSimilarity& SetSimilarity(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_DbTagAlias_Base(const CGC_DbTagAlias_Base&);
    CGC_DbTagAlias_Base& operator=(const CGC_DbTagAlias_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TRefseq > m_Refseq;
    CRef< TGenbank > m_Genbank;
    int m_Similarity;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_DbTagAlias_Base::IsSetRefseq(void) const
{
    return m_Refseq.NotEmpty();
}

inline
bool CGC_DbTagAlias_Base::CanGetRefseq(void) const
{
    return IsSetRefseq();
}

inline
const CGC_DbTagAlias_Base::TRefseq& CGC_DbTagAlias_Base::GetRefseq(void) const
{
    if (!CanGetRefseq()) {
        ThrowUnassigned(0);
    }
    return (*m_Refseq);
}

inline
bool CGC_DbTagAlias_Base::IsSetGenbank(void) const
{
    return m_Genbank.NotEmpty();
}

inline
bool CGC_DbTagAlias_Base::CanGetGenbank(void) const
{
    return IsSetGenbank();
}

inline
const CGC_DbTagAlias_Base::TGenbank& CGC_DbTagAlias_Base::GetGenbank(void) const
{
    if (!CanGetGenbank()) {
        ThrowUnassigned(1);
    }
    return (*m_Genbank);
}

inline
bool CGC_DbTagAlias_Base::IsSetSimilarity(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGC_DbTagAlias_Base::CanGetSimilarity(void) const
{
    return IsSetSimilarity();
}

inline
void CGC_DbTagAlias_Base::ResetSimilarity(void)
{
    m_Similarity = (ESimilarity)(0);
    m_set_State[0] &= ~0x30;
}

inline
CGC_DbTagAlias_Base::TSimilarity CGC_DbTagAlias_Base::GetSimilarity(void) const
{
    if (!CanGetSimilarity()) {
        ThrowUnassigned(2);
    }
    return m_Similarity;
}

inline
void CGC_DbTagAlias_Base::SetSimilarity(CGC_DbTagAlias_Base::TSimilarity value)
{
    m_Similarity = value;
    m_set_State[0] |= 0x30;
}

inline
CGC_DbTagAlias_Base::TSimilarity& CGC_DbTagAlias_Base::SetSimilarity(void)
{
#ifdef _DEBUG
    if (!IsSetSimilarity()) {
        memset(&m_Similarity,UnassignedByte(),sizeof(m_Similarity));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Similarity;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_DBTAGALIAS_BASE_HPP
