/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_AssemblySet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_ASSEMBLYSET_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_ASSEMBLYSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CGC_Assembly;
class CGC_AssemblyDesc;
class CGC_SequenceStats;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_AssemblySet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_AssemblySet_Base(void);
    // destructor
    virtual ~CGC_AssemblySet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// set type: Assembly-Sets can be of 2 categories
    enum ESet_type {
        eSet_type_full_assembly =   0,  ///< full-assembly: set of asm-units
        eSet_type_assembly_set  = 100,  ///<set of full-assemblies  stopper
        eSet_type_other         = 255
    };
    
    /// Access to ESet_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESet_type)(void);
    
    /// 'class' defines the semantics of how to interpret this item
    enum EClass {
        eClass_full_assembly             =   0,  ///< general type of full-assembly (not expected to be used)
        eClass_haploid                   =   1,  ///< this assembly represents a single haploid assembly in its entirety
        eClass_haploid_with_alt_loci     =   2,  ///< this assembly has exactly one unit and at least one alt-loci
        eClass_diploid                   =   3,  ///< assembly represents a diploid assembly; we expect at least two  haploid-unit assemblies contained herein
        eClass_unresolved_diploid        =   4,  ///< unresolved-diploid: single unit which includes the diploid sequences
        eClass_alternate_haplotype       =   5,  ///< second part of diploid; linked to another haploid full-assembly  this one is alt-loci or second full-haploid
        eClass_alternate_pseudohaplotype =   6,
        eClass_annotation_target_set     = 101,  ///< assembly is a collection for annotation
        eClass_analysis_set              = 102,  ///< analysis set used for sequencing by alignments
        eClass_other                     = 255  ///< stopper
    };
    
    /// Access to EClass's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EClass)(void);
    
    // types
    typedef list< CRef< CDbtag > > TId;
    typedef int TSet_type;
    typedef int TClass;
    typedef CGC_AssemblyDesc TDesc;
    typedef CGC_Assembly TPrimary_assembly;
    typedef list< CRef< CGC_Assembly > > TMore_assemblies;
    typedef CGC_SequenceStats TStats;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_set_type,
        e_class,
        e_desc,
        e_primary_assembly,
        e_more_assemblies,
        e_stats
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// The identifier of this assembly
    /// examples: GC internal id, Assembly-accession.version
    /// Types of DbTags used:
    /// db "GenColl", tag id <assembly-release-id>
    /// db "GenColl", tag str <assembly-accession.version>
    /// db "AGP", tag id <agp-sumbission-id>
    /// db "GenColl_Chain", tag id <assembly-chain-id>
    /// db "UCSC_name", tag str <UCSC identifier for assembly>
    /// db "Ensembl_name",tag str <Ensembl identifier for assembly>
    /// mandatory
    /// typedef list< CRef< CDbtag > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// mandatory
    /// typedef int TSet_type
    ///  Check whether the Set_type data member has been assigned a value.
    bool IsSetSet_type(void) const;
    /// Check whether it is safe or not to call GetSet_type method.
    bool CanGetSet_type(void) const;
    void ResetSet_type(void);
    TSet_type GetSet_type(void) const;
    void SetSet_type(TSet_type value);
    TSet_type& SetSet_type(void);

    /// mandatory
    /// typedef int TClass
    ///  Check whether the Class data member has been assigned a value.
    bool IsSetClass(void) const;
    /// Check whether it is safe or not to call GetClass method.
    bool CanGetClass(void) const;
    void ResetClass(void);
    TClass GetClass(void) const;
    void SetClass(TClass value);
    TClass& SetClass(void);

    /// descriptors live in a shared data block
    /// mandatory
    /// typedef CGC_AssemblyDesc TDesc
    ///  Check whether the Desc data member has been assigned a value.
    bool IsSetDesc(void) const;
    /// Check whether it is safe or not to call GetDesc method.
    bool CanGetDesc(void) const;
    void ResetDesc(void);
    const TDesc& GetDesc(void) const;
    void SetDesc(TDesc& value);
    TDesc& SetDesc(void);

    /// we contain hierarchically a set of assemblies
    /// mandatory
    /// typedef CGC_Assembly TPrimary_assembly
    ///  Check whether the Primary_assembly data member has been assigned a value.
    bool IsSetPrimary_assembly(void) const;
    /// Check whether it is safe or not to call GetPrimary_assembly method.
    bool CanGetPrimary_assembly(void) const;
    void ResetPrimary_assembly(void);
    const TPrimary_assembly& GetPrimary_assembly(void) const;
    void SetPrimary_assembly(TPrimary_assembly& value);
    TPrimary_assembly& SetPrimary_assembly(void);

    /// optional
    /// typedef list< CRef< CGC_Assembly > > TMore_assemblies
    ///  Check whether the More_assemblies data member has been assigned a value.
    bool IsSetMore_assemblies(void) const;
    /// Check whether it is safe or not to call GetMore_assemblies method.
    bool CanGetMore_assemblies(void) const;
    void ResetMore_assemblies(void);
    const TMore_assemblies& GetMore_assemblies(void) const;
    TMore_assemblies& SetMore_assemblies(void);

    /// statistics
    /// "stats" field holds stats for all chromosomes combined:
    /// optional
    /// typedef CGC_SequenceStats TStats
    ///  Check whether the Stats data member has been assigned a value.
    bool IsSetStats(void) const;
    /// Check whether it is safe or not to call GetStats method.
    bool CanGetStats(void) const;
    void ResetStats(void);
    const TStats& GetStats(void) const;
    void SetStats(TStats& value);
    TStats& SetStats(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_AssemblySet_Base(const CGC_AssemblySet_Base&);
    CGC_AssemblySet_Base& operator=(const CGC_AssemblySet_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CDbtag > > m_Id;
    int m_Set_type;
    int m_Class;
    CRef< TDesc > m_Desc;
    CRef< TPrimary_assembly > m_Primary_assembly;
    list< CRef< CGC_Assembly > > m_More_assemblies;
    CRef< TStats > m_Stats;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_AssemblySet_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_AssemblySet_Base::CanGetId(void) const
{
    return true;
}

inline
const CGC_AssemblySet_Base::TId& CGC_AssemblySet_Base::GetId(void) const
{
    return m_Id;
}

inline
CGC_AssemblySet_Base::TId& CGC_AssemblySet_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CGC_AssemblySet_Base::IsSetSet_type(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_AssemblySet_Base::CanGetSet_type(void) const
{
    return IsSetSet_type();
}

inline
void CGC_AssemblySet_Base::ResetSet_type(void)
{
    m_Set_type = (ESet_type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CGC_AssemblySet_Base::TSet_type CGC_AssemblySet_Base::GetSet_type(void) const
{
    if (!CanGetSet_type()) {
        ThrowUnassigned(1);
    }
    return m_Set_type;
}

inline
void CGC_AssemblySet_Base::SetSet_type(CGC_AssemblySet_Base::TSet_type value)
{
    m_Set_type = value;
    m_set_State[0] |= 0xc;
}

inline
CGC_AssemblySet_Base::TSet_type& CGC_AssemblySet_Base::SetSet_type(void)
{
#ifdef _DEBUG
    if (!IsSetSet_type()) {
        memset(&m_Set_type,UnassignedByte(),sizeof(m_Set_type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Set_type;
}

inline
bool CGC_AssemblySet_Base::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGC_AssemblySet_Base::CanGetClass(void) const
{
    return IsSetClass();
}

inline
void CGC_AssemblySet_Base::ResetClass(void)
{
    m_Class = (EClass)(0);
    m_set_State[0] &= ~0x30;
}

inline
CGC_AssemblySet_Base::TClass CGC_AssemblySet_Base::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CGC_AssemblySet_Base::SetClass(CGC_AssemblySet_Base::TClass value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
CGC_AssemblySet_Base::TClass& CGC_AssemblySet_Base::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        memset(&m_Class,UnassignedByte(),sizeof(m_Class));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CGC_AssemblySet_Base::IsSetDesc(void) const
{
    return m_Desc.NotEmpty();
}

inline
bool CGC_AssemblySet_Base::CanGetDesc(void) const
{
    return true;
}

inline
const CGC_AssemblySet_Base::TDesc& CGC_AssemblySet_Base::GetDesc(void) const
{
    if ( !m_Desc ) {
        const_cast<CGC_AssemblySet_Base*>(this)->ResetDesc();
    }
    return (*m_Desc);
}

inline
CGC_AssemblySet_Base::TDesc& CGC_AssemblySet_Base::SetDesc(void)
{
    if ( !m_Desc ) {
        ResetDesc();
    }
    return (*m_Desc);
}

inline
bool CGC_AssemblySet_Base::IsSetPrimary_assembly(void) const
{
    return m_Primary_assembly.NotEmpty();
}

inline
bool CGC_AssemblySet_Base::CanGetPrimary_assembly(void) const
{
    return true;
}

inline
const CGC_AssemblySet_Base::TPrimary_assembly& CGC_AssemblySet_Base::GetPrimary_assembly(void) const
{
    if ( !m_Primary_assembly ) {
        const_cast<CGC_AssemblySet_Base*>(this)->ResetPrimary_assembly();
    }
    return (*m_Primary_assembly);
}

inline
CGC_AssemblySet_Base::TPrimary_assembly& CGC_AssemblySet_Base::SetPrimary_assembly(void)
{
    if ( !m_Primary_assembly ) {
        ResetPrimary_assembly();
    }
    return (*m_Primary_assembly);
}

inline
bool CGC_AssemblySet_Base::IsSetMore_assemblies(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGC_AssemblySet_Base::CanGetMore_assemblies(void) const
{
    return true;
}

inline
const CGC_AssemblySet_Base::TMore_assemblies& CGC_AssemblySet_Base::GetMore_assemblies(void) const
{
    return m_More_assemblies;
}

inline
CGC_AssemblySet_Base::TMore_assemblies& CGC_AssemblySet_Base::SetMore_assemblies(void)
{
    m_set_State[0] |= 0x400;
    return m_More_assemblies;
}

inline
bool CGC_AssemblySet_Base::IsSetStats(void) const
{
    return m_Stats.NotEmpty();
}

inline
bool CGC_AssemblySet_Base::CanGetStats(void) const
{
    return IsSetStats();
}

inline
const CGC_AssemblySet_Base::TStats& CGC_AssemblySet_Base::GetStats(void) const
{
    if (!CanGetStats()) {
        ThrowUnassigned(6);
    }
    return (*m_Stats);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_ASSEMBLYSET_BASE_HPP
