/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Assemblies_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_ASSEMBLIES_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_ASSEMBLIES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGC_Assembly;
class CGC_Query;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_Assemblies_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_Assemblies_Base(void);
    // destructor
    virtual ~CGC_Assemblies_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CGC_Query > > TQuery;
    typedef list< CRef< CGC_Assembly > > TAssemblies;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_query,
        e_assemblies
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CGC_Query > > TQuery
    ///  Check whether the Query data member has been assigned a value.
    bool IsSetQuery(void) const;
    /// Check whether it is safe or not to call GetQuery method.
    bool CanGetQuery(void) const;
    void ResetQuery(void);
    const TQuery& GetQuery(void) const;
    TQuery& SetQuery(void);

    /// mandatory
    /// typedef list< CRef< CGC_Assembly > > TAssemblies
    ///  Check whether the Assemblies data member has been assigned a value.
    bool IsSetAssemblies(void) const;
    /// Check whether it is safe or not to call GetAssemblies method.
    bool CanGetAssemblies(void) const;
    void ResetAssemblies(void);
    const TAssemblies& GetAssemblies(void) const;
    TAssemblies& SetAssemblies(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_Assemblies_Base(const CGC_Assemblies_Base&);
    CGC_Assemblies_Base& operator=(const CGC_Assemblies_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CGC_Query > > m_Query;
    list< CRef< CGC_Assembly > > m_Assemblies;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_Assemblies_Base::IsSetQuery(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_Assemblies_Base::CanGetQuery(void) const
{
    return true;
}

inline
const CGC_Assemblies_Base::TQuery& CGC_Assemblies_Base::GetQuery(void) const
{
    return m_Query;
}

inline
CGC_Assemblies_Base::TQuery& CGC_Assemblies_Base::SetQuery(void)
{
    m_set_State[0] |= 0x1;
    return m_Query;
}

inline
bool CGC_Assemblies_Base::IsSetAssemblies(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_Assemblies_Base::CanGetAssemblies(void) const
{
    return true;
}

inline
const CGC_Assemblies_Base::TAssemblies& CGC_Assemblies_Base::GetAssemblies(void) const
{
    return m_Assemblies;
}

inline
CGC_Assemblies_Base::TAssemblies& CGC_Assemblies_Base::SetAssemblies(void)
{
    m_set_State[0] |= 0x4;
    return m_Assemblies;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_ASSEMBLIES_BASE_HPP
