/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_GetAssemblyBySequ_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBYSEQU_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBYSEQU_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/genomecoll/GCClient_GetAssemblyBySequ.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_GetAssemblyBySequenceRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_GetAssemblyBySequenceRequest_Base(void);
    // destructor
    virtual ~CGCClient_GetAssemblyBySequenceRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESort {
        eSort_default = 0,
        eSort_latest  = 1,
        eSort_major   = 2
    };
    
    /// Access to ESort's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESort)(void);
    
    // types
    typedef list< string > TSequence_acc;
    typedef int TFilter;
    typedef int TSort;
    typedef int TTop_assembly_only;
    typedef bool TAdd_sequence_roles;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sequence_acc,
        e_filter,
        e_sort,
        e_top_assembly_only,
        e_add_sequence_roles
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< string > TSequence_acc
    ///  Check whether the Sequence_acc data member has been assigned a value.
    bool IsSetSequence_acc(void) const;
    /// Check whether it is safe or not to call GetSequence_acc method.
    bool CanGetSequence_acc(void) const;
    void ResetSequence_acc(void);
    const TSequence_acc& GetSequence_acc(void) const;
    TSequence_acc& SetSequence_acc(void);

    /// optional with default eGCClient_GetAssemblyBySequenceFilter_all
    /// typedef int TFilter
    ///  Check whether the Filter data member has been assigned a value.
    bool IsSetFilter(void) const;
    /// Check whether it is safe or not to call GetFilter method.
    bool CanGetFilter(void) const;
    void ResetFilter(void);
    void SetDefaultFilter(void);
    TFilter GetFilter(void) const;
    void SetFilter(TFilter value);
    TFilter& SetFilter(void);

    /// optional with default eSort_default
    /// typedef int TSort
    ///  Check whether the Sort data member has been assigned a value.
    bool IsSetSort(void) const;
    /// Check whether it is safe or not to call GetSort method.
    bool CanGetSort(void) const;
    void ResetSort(void);
    void SetDefaultSort(void);
    TSort GetSort(void) const;
    void SetSort(TSort value);
    TSort& SetSort(void);

    /// optional with default 0
    /// typedef int TTop_assembly_only
    ///  Check whether the Top_assembly_only data member has been assigned a value.
    bool IsSetTop_assembly_only(void) const;
    /// Check whether it is safe or not to call GetTop_assembly_only method.
    bool CanGetTop_assembly_only(void) const;
    void ResetTop_assembly_only(void);
    void SetDefaultTop_assembly_only(void);
    TTop_assembly_only GetTop_assembly_only(void) const;
    void SetTop_assembly_only(TTop_assembly_only value);
    TTop_assembly_only& SetTop_assembly_only(void);

    /// optional
    /// typedef bool TAdd_sequence_roles
    ///  Check whether the Add_sequence_roles data member has been assigned a value.
    bool IsSetAdd_sequence_roles(void) const;
    /// Check whether it is safe or not to call GetAdd_sequence_roles method.
    bool CanGetAdd_sequence_roles(void) const;
    void ResetAdd_sequence_roles(void);
    TAdd_sequence_roles GetAdd_sequence_roles(void) const;
    void SetAdd_sequence_roles(TAdd_sequence_roles value);
    TAdd_sequence_roles& SetAdd_sequence_roles(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_GetAssemblyBySequenceRequest_Base(const CGCClient_GetAssemblyBySequenceRequest_Base&);
    CGCClient_GetAssemblyBySequenceRequest_Base& operator=(const CGCClient_GetAssemblyBySequenceRequest_Base&);

    // data
    Uint4 m_set_State[1];
    list< string > m_Sequence_acc;
    int m_Filter;
    int m_Sort;
    int m_Top_assembly_only;
    bool m_Add_sequence_roles;
};
/// This is a bitfield.  All values are powers of two.
enum EGCClient_GetAssemblyBySequenceFilter {
    eGCClient_GetAssemblyBySequenceFilter_all     = 0,
    eGCClient_GetAssemblyBySequenceFilter_latest  = 1,
    eGCClient_GetAssemblyBySequenceFilter_major   = 2,
    eGCClient_GetAssemblyBySequenceFilter_genbank = 4,
    eGCClient_GetAssemblyBySequenceFilter_refseq  = 8
};

/// Access to EGCClient_GetAssemblyBySequenceFilter's attributes (values, names) as defined in spec
 const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EGCClient_GetAssemblyBySequenceFilter)(void);







///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::IsSetSequence_acc(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::CanGetSequence_acc(void) const
{
    return true;
}

inline
const CGCClient_GetAssemblyBySequenceRequest_Base::TSequence_acc& CGCClient_GetAssemblyBySequenceRequest_Base::GetSequence_acc(void) const
{
    return m_Sequence_acc;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TSequence_acc& CGCClient_GetAssemblyBySequenceRequest_Base::SetSequence_acc(void)
{
    m_set_State[0] |= 0x1;
    return m_Sequence_acc;
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::IsSetFilter(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::CanGetFilter(void) const
{
    return true;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::ResetFilter(void)
{
    m_Filter = eGCClient_GetAssemblyBySequenceFilter_all;
    m_set_State[0] &= ~0xc;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetDefaultFilter(void)
{
    ResetFilter();
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TFilter CGCClient_GetAssemblyBySequenceRequest_Base::GetFilter(void) const
{
    return m_Filter;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetFilter(CGCClient_GetAssemblyBySequenceRequest_Base::TFilter value)
{
    m_Filter = value;
    m_set_State[0] |= 0xc;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TFilter& CGCClient_GetAssemblyBySequenceRequest_Base::SetFilter(void)
{
#ifdef _DEBUG
    if (!IsSetFilter()) {
        memset(&m_Filter,UnassignedByte(),sizeof(m_Filter));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Filter;
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::IsSetSort(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::CanGetSort(void) const
{
    return true;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::ResetSort(void)
{
    m_Sort = eSort_default;
    m_set_State[0] &= ~0x30;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetDefaultSort(void)
{
    ResetSort();
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TSort CGCClient_GetAssemblyBySequenceRequest_Base::GetSort(void) const
{
    return m_Sort;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetSort(CGCClient_GetAssemblyBySequenceRequest_Base::TSort value)
{
    m_Sort = value;
    m_set_State[0] |= 0x30;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TSort& CGCClient_GetAssemblyBySequenceRequest_Base::SetSort(void)
{
#ifdef _DEBUG
    if (!IsSetSort()) {
        memset(&m_Sort,UnassignedByte(),sizeof(m_Sort));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Sort;
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::IsSetTop_assembly_only(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::CanGetTop_assembly_only(void) const
{
    return true;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::ResetTop_assembly_only(void)
{
    m_Top_assembly_only = 0;
    m_set_State[0] &= ~0xc0;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetDefaultTop_assembly_only(void)
{
    ResetTop_assembly_only();
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TTop_assembly_only CGCClient_GetAssemblyBySequenceRequest_Base::GetTop_assembly_only(void) const
{
    return m_Top_assembly_only;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetTop_assembly_only(CGCClient_GetAssemblyBySequenceRequest_Base::TTop_assembly_only value)
{
    m_Top_assembly_only = value;
    m_set_State[0] |= 0xc0;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TTop_assembly_only& CGCClient_GetAssemblyBySequenceRequest_Base::SetTop_assembly_only(void)
{
#ifdef _DEBUG
    if (!IsSetTop_assembly_only()) {
        memset(&m_Top_assembly_only,UnassignedByte(),sizeof(m_Top_assembly_only));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Top_assembly_only;
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::IsSetAdd_sequence_roles(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGCClient_GetAssemblyBySequenceRequest_Base::CanGetAdd_sequence_roles(void) const
{
    return IsSetAdd_sequence_roles();
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::ResetAdd_sequence_roles(void)
{
    m_Add_sequence_roles = 0;
    m_set_State[0] &= ~0x300;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TAdd_sequence_roles CGCClient_GetAssemblyBySequenceRequest_Base::GetAdd_sequence_roles(void) const
{
    if (!CanGetAdd_sequence_roles()) {
        ThrowUnassigned(4);
    }
    return m_Add_sequence_roles;
}

inline
void CGCClient_GetAssemblyBySequenceRequest_Base::SetAdd_sequence_roles(CGCClient_GetAssemblyBySequenceRequest_Base::TAdd_sequence_roles value)
{
    m_Add_sequence_roles = value;
    m_set_State[0] |= 0x300;
}

inline
CGCClient_GetAssemblyBySequenceRequest_Base::TAdd_sequence_roles& CGCClient_GetAssemblyBySequenceRequest_Base::SetAdd_sequence_roles(void)
{
#ifdef _DEBUG
    if (!IsSetAdd_sequence_roles()) {
        memset(&m_Add_sequence_roles,UnassignedByte(),sizeof(m_Add_sequence_roles));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Add_sequence_roles;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_GETASSEMBLYBYSEQU_BASE_HPP
